/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CountryHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentBillSubmitValidator
extends AbstractValidator {
    public void validate() {
        List orgIdList = ((Stream)Arrays.stream(this.dataEntities).parallel()).map(c -> c.getDataEntity().getDynamicObject("org").getLong("id")).distinct().collect(Collectors.toList());
        Map params = SystemParameterHelper.getBatchTm018(orgIdList);
        HashMap checkMap = new HashMap(16);
        HashMap<String, ExtendedDataEntity> extendedDataEntityHashMap = new HashMap<String, ExtendedDataEntity>(16);
        HashMap orgBillNos = new HashMap(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            List paymentChannels;
            String paymentChannel;
            String currentPaymentChannel;
            DynamicObject info = dataEntity.getDataEntity();
            Long orgId = info.getDynamicObject("org").getLong("id");
            DynamicObject accountBank = info.getDynamicObject("payeracctbank");
            if (0 == (Integer)params.get(String.valueOf(orgId)) && EmptyUtil.isNoEmpty((DynamicObject)accountBank)) {
                Set<Long> accountBankIdList;
                if (checkMap.get(orgId) == null) {
                    accountBankIdList = new HashSet<Long>();
                    accountBankIdList.add(accountBank.getLong("id"));
                    checkMap.put(orgId, accountBankIdList);
                } else {
                    accountBankIdList = (Set)checkMap.get(orgId);
                    accountBankIdList.add(accountBank.getLong("id"));
                    checkMap.put(orgId, accountBankIdList);
                }
            }
            if ("bei".equalsIgnoreCase(currentPaymentChannel = info.getString("paymentchannel"))) {
                boolean isCheckDcep;
                String businessType = info.getString("businesstype");
                DynamicObject settleType = info.getDynamicObject("settletype");
                boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
                boolean bl = isCheckDcep = !isDcep || PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType);
                if (isCheckDcep) {
                    DynamicObject country = info.getDynamicObject("reccountry");
                    boolean isChinaMainland = CountryHelper.isChina((DynamicObject)country);
                    String provinceTxt = info.getString("recprovince");
                    String cityTxt = info.getString("reccity");
                    boolean isCrossPay = info.getBoolean("iscrosspay");
                    if (isChinaMainland && !isCrossPay) {
                        if (EmptyUtil.isEmpty((String)provinceTxt) || EmptyUtil.isEmpty((String)cityTxt)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6536\u6b3e\u94f6\u884c\u7684\u7701\u4efd\uff08\u94f6\u4f01\uff09\u3001\u57ce\u5e02\uff08\u94f6\u4f01\uff09\u4fe1\u606f\u4e0d\u5b8c\u5584\uff0c\u8bf7\u5230\u3010\u884c\u540d\u884c\u53f7\u3011\u53ca\u65f6\u7ef4\u62a4\u3002", (String)"PaymentBillSubmint_Err00", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        }
                    } else if (EmptyUtil.isEmpty((String)cityTxt) && !isCrossPay) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6536\u6b3e\u94f6\u884c\u7684\u57ce\u5e02\uff08\u94f6\u4f01\uff09\u4fe1\u606f\u4e0d\u5b8c\u5584\uff0c\u8bf7\u5230\u3010\u884c\u540d\u884c\u53f7\u3011\u53ca\u65f6\u7ef4\u62a4\u3002", (String)"PaymentBillSubmint_Err01", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                }
            }
            ArrayList<String> billNos = new ArrayList<String>();
            if (orgBillNos.containsKey(orgId)) {
                billNos.addAll((Collection)orgBillNos.get(orgId));
                billNos.add(dataEntity.getBillNo());
            } else {
                billNos.add(dataEntity.getBillNo());
            }
            orgBillNos.put(orgId, billNos);
            extendedDataEntityHashMap.put(dataEntity.getBillNo(), dataEntity);
            DynamicObject settlementType = info.getDynamicObject("settletype");
            if (!Objects.nonNull(settlementType) || !StringUtils.isNotEmpty((CharSequence)(paymentChannel = settlementType.getString("paymentchannel"))) || !StringUtils.isNotEmpty((CharSequence)currentPaymentChannel) || (paymentChannels = ((Stream)Arrays.stream(paymentChannel.split(",")).parallel()).filter(StringUtils::isNotEmpty).collect(Collectors.toList())).contains(currentPaymentChannel)) continue;
            ArrayList<String> channelNames = new ArrayList<String>(paymentChannels.size());
            for (String channel : paymentChannels) {
                channelNames.add(PaymentChannelEnum.getName((String)channel));
            }
            String join = String.join((CharSequence)",", channelNames);
            String error = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u3010%1$s\u3011\u7684\u9650\u5b9a\u652f\u4ed8\u6e20\u9053\u4e3a\u3010%2$s\u3011\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"PaymentDynamicValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), settlementType.getString("name"), join);
            this.addErrorMessage(dataEntity, error);
        }
        Map checkResult = AccountBankHelper.batchCanUseAccountMap(checkMap);
        for (Map.Entry check : checkResult.entrySet()) {
            Long orgId = (Long)check.getKey();
            Boolean result = (Boolean)check.getValue();
            if (result.booleanValue()) continue;
            List billNos = (List)orgBillNos.get(orgId);
            for (String billNo : billNos) {
                ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)extendedDataEntityHashMap.get(billNo);
                if (EmptyUtil.isEmpty((Object)extendedDataEntity)) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\uff08\u4ed8\u6b3e\u4eba\u540d\u79f0&\u6536\u6b3e\u4eba\u540d\u79f0\uff09\u4e0e\u8be5\u8d26\u6237\u6237\u540d\u4e0d\u7b26\uff0c\u6216\u8d26\u6237\u5df2\u9500\u6237\u3002", (String)"CasErrorCode_3", (String)"fi-cas-business", (Object[])new Object[0]));
            }
        }
    }
}

