/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PayBillCrossHelper;

public class RecBillInnerAccountValidator
extends AbstractValidator {
    public void validate() {
        Set accBankIdSet = Arrays.stream(this.dataEntities).filter(o -> CasHelper.isNotEmpty((Object)o.getDataEntity().getDynamicObject("accountbank"))).map(o -> o.getDataEntity().getDynamicObject("accountbank").getLong("id")).collect(Collectors.toSet());
        Set ifmAccIds = PayBillCrossHelper.getIfmAccIds(accBankIdSet);
        Set innerAccountIdSet = Arrays.stream(this.dataEntities).filter(o -> CasHelper.isNotEmpty((Object)o.getDataEntity().getDynamicObject("inneraccount"))).map(o -> o.getDataEntity().getDynamicObject("inneraccount").get("bank.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("settlecenter", "in", innerAccountIdSet);
        DynamicObject[] settCenterDts = BusinessDataServiceHelper.load((String)"ifm_settcentersetting", (String)"settlecenter,usestatus", (QFilter[])new QFilter[]{qFilter});
        Map settleCenterMap = Arrays.stream(settCenterDts).collect(Collectors.toMap(o -> o.getDynamicObject("settlecenter").get("id"), Function.identity(), (a, b) -> a));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String payerType;
            DynamicObject accountBank;
            DynamicObject info = dataEntity.getDataEntity();
            if (EmptyUtil.isEmpty((DynamicObject)info.getDynamicObject("receivingtype")) || (accountBank = info.getDynamicObject("accountbank")) == null || !info.getDynamicObject("receivingtype").get("biztype").equals(PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue()) || ifmAccIds.contains(accountBank.getLong("id"))) continue;
            DynamicObject innerAccountDO = info.getDynamicObject("inneraccount");
            if (innerAccountDO == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u6536\u6b3e\u65f6\uff0c\u5173\u8054\u5185\u90e8\u8d26\u6237\u4fe1\u606f\u4e2d\u8d26\u53f7\u5fc5\u586b\u3002", (String)"RecBillInnerAccountValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            Object bankId = innerAccountDO.get("bank.id");
            Object innerAccountOrgId = innerAccountDO.get("company.id");
            DynamicObject settleCenter = (DynamicObject)settleCenterMap.get(bankId);
            if (null == settleCenter) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u4e0d\u662f\u5df2\u542f\u7528\u7684\u7ed3\u7b97\u4e2d\u5fc3\uff0c\u4e0d\u80fd\u4f7f\u7528\u8be5\u6536\u6b3e\u7c7b\u578b\u3002", (String)"RecBillInnerAccountValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            } else if (!Boolean.parseBoolean(settleCenter.get("usestatus").toString())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u4e0d\u662f\u5df2\u542f\u7528\u7684\u7ed3\u7b97\u4e2d\u5fc3\uff0c\u4e0d\u80fd\u4f7f\u7528\u8be5\u6536\u6b3e\u7c7b\u578b\u3002", (String)"RecBillInnerAccountValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            DynamicObject paymentType = info.getDynamicObject("receivingtype");
            String string = payerType = info.get("payertype") == null ? "" : info.get("payertype").toString();
            if (!payerType.equals(AsstActTypeEnum.COMPANY.getValue())) continue;
            Object payOrgId = info.get("payer");
            if (!paymentType.getString("biztype").equals(PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue()) || !payerType.equals(AsstActTypeEnum.COMPANY.getValue()) || payOrgId.toString().equals(innerAccountOrgId.toString())) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f01\u4e1a\u4e3b\u52a8\u4e0a\u5b58\u8d44\u91d1\u65f6\uff0c\u5185\u90e8\u8d26\u6237\u7ec4\u7ec7\u4e0e\u4ed8\u6b3e\u7ec4\u7ec7\u5fc5\u987b\u4e00\u81f4\u3002", (String)"RecBillInnerAccountValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

