/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecDraftSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            BigDecimal recAmount = info.getBigDecimal("actrecamt");
            DynamicObjectCollection draftInfoEntrys = info.getDynamicObjectCollection("cas_draftinfo");
            DynamicObjectCollection draftBillColl = (DynamicObjectCollection)info.get("draftbill");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)draftBillColl)) continue;
            List draftBillIdList = draftBillColl.stream().map(i -> i.getLong("fbasedataid.id")).collect(Collectors.toList());
            ArrayList logIdList = new ArrayList(10);
            BigDecimal totalDealAmount = BigDecimal.ZERO;
            ArrayList<Long> saveLogIdList = new ArrayList<Long>(10);
            draftInfoEntrys.stream().filter(v -> !EmptyUtil.isEmpty((Long)v.getLong("draftbilllogid"))).forEach(v -> logIdList.add(v.getLong("draftbilllogid")));
            if (!EmptyUtil.isEmpty(logIdList)) {
                QFilter qFilter = new QFilter("id", "in", logIdList);
                DynamicObject[] draftBillLogs = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,draftid,dealamount", (QFilter[])qFilter.toArray());
                Iterator iterator = draftBillIdList.iterator();
                while (iterator.hasNext()) {
                    long daftBillId = (Long)iterator.next();
                    for (DynamicObject draftBillLog : draftBillLogs) {
                        if (daftBillId != draftBillLog.getLong("draftid")) continue;
                        totalDealAmount = totalDealAmount.add(draftBillLog.getBigDecimal("dealamount"));
                        saveLogIdList.add(daftBillId);
                    }
                }
            }
            draftBillIdList.removeAll(saveLogIdList);
            DynamicObject[] draftDataArr = BusinessDataServiceHelper.load((Object[])draftBillIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_payandrecdraft_f7"));
            BigDecimal billAmount = Arrays.stream(draftDataArr).map(i -> i.getBigDecimal("availableamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            String fromRecClaim = this.getOption().getVariableValue("fromRecClaim", "false");
            billAmount = billAmount.add(totalDealAmount);
            if (recAmount.compareTo(billAmount) == 0 || "true".equals(fromRecClaim)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u53ef\u7528\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u4e0e\u6536\u6b3e\u5355\u91d1\u989d\u76f8\u540c\u3002", (String)"RecBillSelectDraftEdit_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

