/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.cas.business.errorcode.ReceivErrorCode;
import kd.fi.cas.enums.BillStatusEnum;

public class ReceivingBillAuditValidator
extends AbstractValidator {
    public void validate() {
        ReceivErrorCode receivErrorCode = new ReceivErrorCode();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            String billStatus = info.getString("billstatus");
            if (!billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
                String content = receivErrorCode.STATUS_CANNOT_AUDIT().getMessage();
                this.addMessage(dataEntity, content, ErrorLevel.Error);
            }
            long payee = info.getLong("payer");
            String payeename = info.getString("payername");
            DynamicObject type = info.getDynamicObject("receivingtype");
            Boolean isPart = Boolean.TRUE;
            if (type != null) {
                isPart = type.getBoolean("ispartreceivable");
            }
            if (!isPart.booleanValue() || payee != 0L || !StringUtils.isEmpty((CharSequence)payeename)) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceivingBillSaveValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

