/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cas.business.writeback.ar.ArWriteBackHelper;
import kd.fi.cas.business.writeback.ar.bean.RefundAndRenoteOrCancelParam;
import kd.fi.cas.business.writeback.ar.bean.Result;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import org.apache.commons.lang3.ArrayUtils;

public class ReceivingBillRefundPayAPValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntities : this.dataEntities) {
            long revId;
            QFilter filter;
            Object[] payBills;
            DynamicObject recBill = dataEntities.getDataEntity();
            if (!recBill.getBoolean("isrefund")) {
                this.addErrorMessage(dataEntities, ResManager.loadKDString((String)"\u5355\u636e\u672a\u8fdb\u884c\u9000\u6b3e\u3001\u9000\u7968\uff0c\u65e0\u9700\u6267\u884c\u53cd\u5199\u3002", (String)"ReceivingBillRefundPayAPValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection entry = recBill.getDynamicObjectCollection("entry");
            for (DynamicObject d : entry) {
                BigDecimal e_settledamt = d.getBigDecimal("e_settledamt");
                if (e_settledamt.compareTo(BigDecimal.ZERO) <= 0) continue;
                this.addErrorMessage(dataEntities, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5df2\u7ed3\u7b97\u3002", (String)"ReceivingBillRefundPayAPValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                break;
            }
            if (!ArrayUtils.isNotEmpty((Object[])(payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,sourcebilltype,billstatus,entry.id,entry.e_refundamt", (QFilter[])new QFilter[]{filter = new QFilter("refundbillid", "=", recBill.getPkValue())})))) continue;
            Object payBill = payBills[0];
            String sourcebilltype = payBill.getString("sourcebilltype");
            String payId = String.valueOf(payBill.getLong("id"));
            List ids = Stream.of(payId, String.valueOf(revId = recBill.getLong("id"))).collect(Collectors.toList());
            List lockedIds = TxCheckUtil.getLocked(ids);
            if (CollectionUtils.containsAny((Collection)lockedIds, ids)) {
                String error = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentCancelPayValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                throw new KDBizException(error);
            }
            WriteBackOperateEnum operateEnum = BillStatusEnum.REFUND.getValue().equals(payBill.getString("billstatus")) ? WriteBackOperateEnum.REFUND : WriteBackOperateEnum.RENOTE;
            RefundAndRenoteOrCancelParam param = ArWriteBackHelper.buildRefundRenoteParam((DynamicObject)payBill, (Long)revId, (WriteBackOperateEnum)operateEnum);
            Object res = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"RefundAndRenoteValidateService", (String)"validate", (Object[])new Object[]{JSONObject.toJSONString((Object)param)});
            Result result = (Result)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)res), Result.class);
            if ("0".equals(result.getCode())) continue;
            this.addErrorMessage(dataEntities, result.getErrorInfo());
        }
    }
}

