/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.business.opservice.helper.RecPayRuleHelper;
import kd.fi.cas.business.opservice.helper.ValidAndSetMatchInfoHelper;
import kd.fi.cas.business.opservice.impl.ValidateReclateOperation;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class ReceivingBillSaveValidator
extends AbstractValidator {
    private static final List<String> SRCBILL_TYPES = Arrays.asList("bei_transdetail_cas", "bei_transdetail", "bei_intelrec");

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object[] recVirtBill;
            DynamicObject receivingbill = dataEntity.getDataEntity();
            BigDecimal sumAmt = receivingbill.getBigDecimal("actrecamt");
            if (BigDecimal.valueOf(Math.pow(10.0, 13.0)).compareTo(sumAmt) <= 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u8d85\u8fc7\u6700\u5927\u503c\u3002", (String)"ReceivingBillSaveValidator_15", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (receivingbill.getDynamicObject("accountcash") != null && receivingbill.getDynamicObject("accountbank") != null) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u548c\u73b0\u91d1\u8d26\u53f7\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u3002", (String)"PaymentSaveValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            DynamicObjectCollection entrys = receivingbill.getDynamicObjectCollection("entry");
            BigDecimal amt = BigDecimal.ZERO;
            for (int i = 0; i < entrys.size(); ++i) {
                BigDecimal actAmt = ((DynamicObject)entrys.get(i)).getBigDecimal("e_actamt");
                if (actAmt.compareTo(BigDecimal.ZERO) == 0) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u4e2d\u7684\u5b9e\u6536\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"ReceivingBillSaveValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), i + 1));
                }
                amt = amt.add(actAmt);
            }
            if (receivingbill.getBigDecimal("actrecamt").compareTo(amt) != 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u5b9e\u6536\u91d1\u989d\u603b\u548c\u4e0e\u5355\u636e\u5934\u6536\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"ReceivingBillSaveValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (!EmptyUtil.isEmpty((Object[])(recVirtBill = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,sourcebilltype,isvirtual,actrecamt", (QFilter[])new QFilter[]{new QFilter("id", "=", receivingbill.getPkValue())})))) {
                boolean isvirtual = recVirtBill[0].getBoolean("isvirtual");
                String sourcebilltype = recVirtBill[0].getString("sourcebilltype");
                if (isvirtual && !EmptyUtil.isEmpty((String)sourcebilltype) && "cas_recbill".equals(sourcebilltype)) {
                    BigDecimal actRecAmtDB = recVirtBill[0].getBigDecimal("actrecamt");
                    BigDecimal actrecamtTemp = receivingbill.getBigDecimal("actrecamt");
                    if (actrecamtTemp != null && actrecamtTemp.compareTo(actRecAmtDB) != 0) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7684\u6536\u6b3e\u91d1\u989d\u6570\u503c\u4e0e\u539f\u6765\u91d1\u989d\u6570\u503c\u201c%s\u201d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"ReceivingBillSaveValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), actRecAmtDB));
                    }
                }
            }
            if (this.getOption().containsVariable("save_issupplecontract")) {
                this.getOption().removeVariable("save_issupplecontract");
                BigDecimal actrecamtTemp = receivingbill.getBigDecimal("actrecamt");
                DynamicObject recbillDO = BusinessDataServiceHelper.loadSingle((Object)receivingbill.getPkValue(), (String)"cas_recbill", (String)"actrecamt");
                BigDecimal actRecAmt = recbillDO.getBigDecimal("actrecamt");
                String actRecAmtSting = "";
                if (!CasHelper.isEmpty((Object)actRecAmt) && !CasHelper.isEmpty((Object)actrecamtTemp)) {
                    actRecAmtSting = actRecAmt.setScale(2, RoundingMode.HALF_UP).toString();
                    if (actrecamtTemp.compareTo(actRecAmt) != 0) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7684\u6536\u6b3e\u91d1\u989d\u6570\u503c\u4e0e\u539f\u6765\u91d1\u989d\u6570\u503c\u201c%s\u201d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"ReceivingBillSaveValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), actRecAmtSting));
                    }
                } else {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7684\u6536\u6b3e\u91d1\u989d\u6570\u503c\u4e0e\u539f\u6765\u91d1\u989d\u6570\u503c\u201c%s\u201d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"ReceivingBillSaveValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), actRecAmtSting));
                }
            }
            if (this.getOption().containsVariable("save_orgsdivide")) {
                List<String> targetStrings = Arrays.asList("cas_recbill", "ap_finapbill");
                new ValidateReclateOperation(receivingbill).targetBillReverseOpValidate(targetStrings);
            }
            String comment = receivingbill.getString("txt_description");
            TextProp property = (TextProp)receivingbill.getDataEntityType().getProperties().get((Object)"txt_description");
            int maxLenth = property.getMaxLenth();
            if (CasHelper.isNotEmpty((Object)comment) && comment.length() > maxLenth) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5b57\u6bb5\u201c\u6458\u8981\u201d\u8f93\u5165\u957f\u5ea6\u4e0d\u80fd\u8d85\u51fa\u9650\u5b9a\u8303\u56f40~%2$s\u3002", (String)"ReceivingBillSaveValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]), receivingbill.getString("billno"), maxLenth));
            }
            DynamicObject settletype = receivingbill.getDynamicObject("settletype");
            DynamicObject accountbank = receivingbill.getDynamicObject("accountbank");
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{VisibleVirtualAcctHelper.virtualAcctQf()});
            if (accountbank != null && ids.length > 0) {
                long count = Arrays.stream(ids).map(o -> accountbank.getPkValue().equals(o.getPkValue())).filter(o -> o).count();
                if (BaseDataHelper.isSettleTypeVirtual((DynamicObject)settletype) && count == 0L) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u865a\u62df\u7ed3\u7b97\u65b9\u5f0f\u53ea\u80fd\u9009\u62e9\u865a\u62df\u94f6\u884c\u8d26\u6237\u3002", (String)"ReceivingBillSaveValidator_12", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
            }
            this.validMatchInfo(dataEntity);
        }
    }

    private void validMatchInfo(ExtendedDataEntity dataEntity) {
        DynamicObject info = dataEntity.getDataEntity();
        String sourceBillType = info.getString("sourcebilltype");
        boolean isFromDb = info.getDataEntityState().getFromDatabase();
        String errInfo = "";
        if (!isFromDb && SRCBILL_TYPES.contains(sourceBillType)) {
            String returnDataStr = "";
            Map returnData = null;
            if (this.getOption().containsVariable("returnDataByOpHand")) {
                returnDataStr = String.valueOf(this.getOption().getVariables().get("returnDataByOpHand"));
                returnData = (Map)SerializationUtils.fromJsonString((String)returnDataStr, Map.class);
            } else if (this.getOption().containsVariable("returnDataByOpHandMerge")) {
                returnDataStr = String.valueOf(this.getOption().getVariables().get("returnDataByOpHandMerge"));
                returnData = (Map)SerializationUtils.fromJsonString((String)returnDataStr, Map.class);
            } else {
                returnData = RecPayRuleHelper.getInfoByMatchRule((DynamicObject)info, (String)"rec");
            }
            if (!CasHelper.isEmpty((Object)returnData) && returnData.size() > 0) {
                String e_payerType = String.valueOf(returnData.get("e_payertype"));
                Object e_payer = returnData.get("e_payer");
                if (EmptyUtil.isEmpty(e_payer)) {
                    errInfo = ValidAndSetMatchInfoHelper.validAndSetMatchInfo((DynamicObject)info, (String)e_payerType, (String)"rec", (boolean)false);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)errInfo)) {
            this.addErrorMessage(dataEntity, errInfo);
        }
    }
}

