/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.checkAcct;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidataErrorCode;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;

public class BalanceadjustValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String finishInit;
            boolean checked;
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject org = info.getDynamicObject("org");
            DynamicObject accountBank = info.getDynamicObject("accountbank");
            DynamicObject currency = info.getDynamicObject("currency");
            Date endDate = info.getDate("enddate");
            if (accountBank == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u94f6\u884c\u8d26\u6237\u3002", (String)"BalanceadjustValidator_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (currency == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceadjustValidator_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (endDate == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BalanceadjustValidator_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            DynamicObject initObj = null;
            if (org == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u7ec7\u3002", (String)"BalanceadjustValidator_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                initObj = SystemStatusCtrolHelper.loadCashMgtInit((long)org.getLong("id"));
            }
            if (initObj == null || !initObj.getBoolean("isfinishinit")) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u7ed3\u675f\u51fa\u7eb3\u5e94\u7528\u6216\u8d44\u91d1\u7ed3\u7b97\u5e94\u7528\u7684\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BalanceadjustValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (initObj != null && org != null && accountBank != null && currency != null) {
                QFilter commFilter = new QFilter("org", "=", org.getPkValue());
                commFilter.and(new QFilter("bankaccount", "=", accountBank.getPkValue()));
                commFilter.and(new QFilter("currency", "=", currency.getPkValue()));
                QFilter dateFilter2 = new QFilter("bizdate", ">", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false));
                boolean exsitLargerDateBalance = QueryServiceHelper.exists((String)"cas_balanceadjust", (QFilter[])new QFilter[]{commFilter, dateFilter2});
                if (exsitLargerDateBalance) {
                    String dateStr = DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd");
                    String error = String.format(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\u3002\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728%1$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\uff0c\u5982\u9700\u7ee7\u7eed\uff0c\u8bf7\u5c06%2$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\u5220\u9664\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BalanceadjustValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), dateStr, dateStr);
                    this.addSelfMessage(dataEntity, error, accountBank, currency);
                }
            }
            if (accountBank == null || endDate == null) continue;
            Date acctOpDate = accountBank.getDate("opendate");
            boolean bl = checked = acctOpDate.getTime() > endDate.getTime();
            if (this.getOption().containsVariable("finishinit") && "true".equalsIgnoreCase(finishInit = (String)this.getOption().getVariables().get("finishinit"))) {
                checked = Boolean.FALSE;
            }
            if (!checked) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u201c%s\u201d\u7684\u5f00\u6237\u65e5\u671f\u665a\u4e8e\u672c\u6b21\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\u7684\u622a\u6b62\u65e5\u671f\uff0c\u4e0d\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"CAS-E-472048", (String)"fi-cas-opplugin", (Object[])new Object[0]), accountBank.getString("number")));
        }
    }

    private void addSelfMessage(ExtendedDataEntity dataEntity, String error, DynamicObject accountBank, DynamicObject currency) {
        String content = String.format(ResManager.loadKDString((String)"%1$s(%2$s)\uff1a%3$s", (String)"BalanceadjustValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]), accountBank.getString("number"), currency.getString("name"), error);
        if (this.getValidateContext().getDataEntityLength() <= 1) {
            content = error;
        }
        Object pkId = dataEntity.getBillPkId();
        int dataIndex = dataEntity.getDataEntityIndex();
        String title = this.getOperationName();
        String errorCode = StringUtils.isNotBlank((Object)dataEntity.getValidataErrorCode()) ? ValidataErrorCode.AttTimeout.getCode() : "errorcode_001";
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, dataEntity.getRowIndex(), errorCode, title, content, this.errorLevel);
        info.setEntityKey(this.getEntityKey());
        info.setSubRowIndex(dataEntity.getSubRowIndex());
        info.setSubRowIndex(dataEntity.getSubRowIndex());
        this.validateResult.addErrorInfo((OperateErrorInfo)info);
    }
}

