/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.entrust;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentOrAgentCancelEntrustValidator
extends AbstractValidator {
    public void validate() {
        String billName;
        String entrustOrgKey;
        ExtendedDataEntity[] payOrAgentEntitys = this.getDataEntities();
        String entityType = this.getEntityKey();
        if ("cas_paybill".equals(entityType)) {
            entrustOrgKey = "entrustorg";
            billName = ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355", (String)"PaymentOrAgentEntrustValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
        } else {
            entrustOrgKey = "delegorg";
            billName = ResManager.loadKDString((String)"\u4ee3\u53d1\u5355", (String)"PaymentOrAgentEntrustValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]);
        }
        for (ExtendedDataEntity payOrAgentEntity : payOrAgentEntitys) {
            Map<Long, DynamicObject> entrustScheduleIdAndDyMap;
            DynamicObject payOrAgentBill = payOrAgentEntity.getDataEntity();
            if (payOrAgentBill.get(entrustOrgKey) == null) {
                String msg = ResManager.loadKDString((String)"\u4e0d\u662f\u59d4\u6258\u4ed8\u6b3e\u5355\u636e,\u4e0d\u80fd\u53d6\u6d88\u59d4\u6258\u4ed8\u6b3e\u3002", (String)"PaymentOrAgentCancelEntrustValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(payOrAgentEntity, msg);
                continue;
            }
            Set targetBillIds = CasBotpHelper.getDestBillBySrcBill((String)entityType, (Long)((Long)payOrAgentBill.getPkValue()), (String)entityType);
            if (CollectionUtils.isEmpty((Collection)targetBillIds)) {
                String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u59d4\u6258\u4ed8\u6b3e\u4e0b\u6e38\u5355\u636e\u3002", (String)"PaymentOrAgentCancelEntrustValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(payOrAgentEntity, msg);
                continue;
            }
            DynamicObjectCollection targetBills = "cas_paybill".equals(entityType) ? QueryServiceHelper.query((String)entityType, (String)"id,billno,billstatus,entry,entry.e_scheid", (QFilter[])new QFilter("id", "in", (Object)targetBillIds).toArray()) : QueryServiceHelper.query((String)entityType, (String)"billstatus", (QFilter[])new QFilter("id", "in", (Object)targetBillIds).toArray());
            Predicate<DynamicObject> fetchFun = targetBill -> BillStatusEnum.SAVE.getValue().equals(targetBill.getString("billstatus"));
            if (targetBills.stream().noneMatch(fetchFun)) {
                String msgFmt = ResManager.loadKDString((String)"\u5355\u636e[%1$s]\u4e0b\u63a8\u7684%2$s\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u59d4\u6258\u4ed8\u6b3e\u3002", (String)"PaymentOrAgentCancelEntrustValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(payOrAgentEntity, String.format(msgFmt, payOrAgentBill.getString("billno"), billName));
            }
            if (!"cas_paybill".equals(entityType) || !EmptyUtil.isNoEmpty((DynamicObjectCollection)targetBills) || CollectionUtils.isEmpty(entrustScheduleIdAndDyMap = targetBills.stream().filter(pay -> !BillStatusEnum.CHARGEBANK.getValue().equals(pay.getString("billstatus"))).filter(pay -> EmptyUtil.isNoEmpty((Long)pay.getLong("entry.e_scheid"))).collect(Collectors.toMap(pay -> pay.getLong("entry.e_scheid"), v -> v)))) continue;
            QFilter qFilter = new QFilter("id", "in", entrustScheduleIdAndDyMap.keySet());
            DynamicObjectCollection scheduleBillList = QueryServiceHelper.query((String)"psd_schedulebill", (String)String.join((CharSequence)",", "id", "schedulstatus"), (QFilter[])qFilter.toArray());
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)scheduleBillList)) continue;
            HashSet entrustPayBillNoSet = new HashSet(10);
            scheduleBillList.forEach(scheduleBill -> {
                DynamicObject payBill;
                if (!StringUtils.equals((CharSequence)scheduleBill.getString("schedulstatus"), (CharSequence)"noschedule") && EmptyUtil.isNoEmpty((DynamicObject)(payBill = (DynamicObject)entrustScheduleIdAndDyMap.get(scheduleBill.getLong("id"))))) {
                    entrustPayBillNoSet.add(payBill.getString("billno"));
                }
            });
            if (!EmptyUtil.isNoEmpty(entrustPayBillNoSet)) continue;
            StringBuilder errMsg = new StringBuilder();
            entrustPayBillNoSet.forEach(billNo -> {
                if (EmptyUtil.isNoEmpty((String)errMsg.toString())) {
                    errMsg.append("\r\n");
                }
                errMsg.append(String.format(ResManager.loadKDString((String)"\u59d4\u6258\u4ed8\u6b3e\u5355\u636e\u201c%s\u201d\u5df2\u8fdb\u5165\u4ed8\u6b3e\u6392\u7a0b\u4e2d\uff0c\u4e0d\u80fd\u53d6\u6d88\u59d4\u6258\u3002", (String)"PaymentOrAgentCancelEntrustValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), billNo));
            });
            this.addErrorMessage(payOrAgentEntity, errMsg.toString());
        }
    }
}

