/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.pay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.helper.DynamicObjectHelper;

public class PayBillScmcValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(PayBillScmcValidator.class);
    private static final Map<String, String> INTERFACE_MAP = new HashMap<String, String>(){
        {
            this.put("sctm_scpo", "scmc.sctm.SctmPoFiValidateService.payBillOverPayValService");
            this.put("pm_purorderbill", "scmc.pm.PurOrderFiValidateService.payBillOverPayValService");
            this.put("conm_purcontract", "scmc.conm.PurConmService.payBillOverPayValService");
        }
    };

    public void validate() {
        ExtendedDataEntity[] payBillEntitys = this.getDataEntities();
        List payBillList = Arrays.stream(payBillEntitys).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        for (Map.Entry<String, String> interfaceObj : INTERFACE_MAP.entrySet()) {
            String scmcSourceType = interfaceObj.getKey();
            List sameSourcePayBills = payBillList.stream().filter(p -> {
                DynamicObjectCollection entryList = p.getDynamicObjectCollection("entry");
                return entryList != null && entryList.stream().anyMatch(e -> scmcSourceType.equals(e.getString("e_corebilltype")));
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(sameSourcePayBills)) continue;
            List paramList = sameSourcePayBills.stream().map(payBill -> {
                HashMap<String, Object> param = new HashMap<String, Object>(6);
                param.put("id", payBill.getPkValue());
                param.put("billno", payBill.getString("billno"));
                param.put("payee", payBill.getLong("payee"));
                DynamicObjectCollection entryList = payBill.getDynamicObjectCollection("entry");
                ArrayList entrys = new ArrayList(entryList.size());
                param.put("entry", entrys);
                for (DynamicObject payEntry : entryList) {
                    if (!scmcSourceType.equals(payEntry.getString("e_corebilltype"))) continue;
                    HashMap<String, Object> entryParam = new HashMap<String, Object>(8);
                    entryParam.put("e_corebilltype", payEntry.getString("e_corebilltype"));
                    entryParam.put("e_corebillid", payEntry.getLong("e_corebillid"));
                    entryParam.put("settleorg", DynamicObjectHelper.getPk((DynamicObject)payEntry, (String)"settleorg"));
                    entryParam.put("e_payableamt", payEntry.getBigDecimal("e_payableamt"));
                    entryParam.put("e_refundamt", payEntry.getBigDecimal("e_refundamt"));
                    entrys.add(entryParam);
                }
                return param;
            }).collect(Collectors.toList());
            String[] serviceInfo = interfaceObj.getValue().split("[.]");
            logger.info("PayBillScmcValidator start", (Object)interfaceObj.getValue());
            Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)serviceInfo[0], (String)serviceInfo[1], (String)serviceInfo[2], (String)serviceInfo[3], (Object[])new Object[]{paramList});
            logger.info("PayBillScmcValidator end", (Object)resultMap);
            if (resultMap == null || resultMap.isEmpty()) continue;
            for (Map.Entry result : resultMap.entrySet()) {
                Optional<ExtendedDataEntity> entityOp = Arrays.stream(payBillEntitys).filter(p -> {
                    Long billPkId = (Long)p.getBillPkId();
                    return billPkId != null && billPkId.equals(result.getKey());
                }).findFirst();
                entityOp.ifPresent(extendedDataEntity -> this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, (String)result.getValue()));
            }
        }
    }
}

