/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.pay;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentDcepSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(PaymentDcepSubmitValidator.class);

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("billtype");
        preparePropertys.add("payeracctbank");
        preparePropertys.add("payeeacctbank");
        preparePropertys.add("businesstype");
        preparePropertys.add("institutioncode");
        preparePropertys.add("institutionname");
        return preparePropertys;
    }

    public void validate() {
        logger.info("PaymentDcepSubmitValidator validate start");
        for (ExtendedDataEntity data : this.dataEntities) {
            boolean isElecPaymentRec;
            long recAccBankId;
            DynamicObject recAccBank;
            DynamicObject info = data.getDataEntity();
            DynamicObject settleType = info.getDynamicObject("settletype");
            boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
            if (isDcep) {
                long payeeId;
                DynamicObject payAccBank;
                String businessType = info.getString("businesstype");
                if (EmptyUtil.isEmpty((String)businessType)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u6570\u5e01\u94b1\u5305\uff0c\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"PaymentDcepSubmitValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!(PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType))) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u6570\u5e01\u94b1\u5305\uff0c\u4e1a\u52a1\u7c7b\u578b\u8bf7\u9009\u62e9\u201c\u6570\u5e01\u5145\u503c\u201d\u6216\u201c\u6570\u5e01\u5b58\u73b0\u201d\u6216\u201c\u6570\u5e01\u8f6c\u8d26\u201d\u3002", (String)"PaymentDcepSubmitValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                if (!EmptyUtil.isNoEmpty((DynamicObject)(payAccBank = info.getDynamicObject("payeracctbank")))) continue;
                boolean isElecPaymentPay = payAccBank.getBoolean("iselecpayment");
                long recAccBankId2 = info.getLong("payeeacctbank");
                DynamicObject recAccBank2 = this.getRecAccountBank(recAccBankId2);
                if (recAccBank2 != null) {
                    boolean isElecPaymentRec2 = recAccBank2.getBoolean("iselecpayment");
                    if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                        if (isElecPaymentPay || !isElecPaymentRec2) {
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6570\u5e01\u5145\u503c\u7684\u4e1a\u52a1\uff0c\u4ed8\u6b3e\u65b9\u5fc5\u987b\u4e3a\u94f6\u884c\u8d26\u6237\uff0c\u6536\u6b3e\u65b9\u5fc5\u987b\u4e3a\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        }
                    } else if (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType) && (!isElecPaymentPay || isElecPaymentRec2)) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6570\u5e01\u5b58\u73b0\u7684\u4e1a\u52a1\uff0c\u4ed8\u6b3e\u65b9\u5fc5\u987b\u4e3a\u94b1\u5305\u8d26\u6237\uff0c\u6536\u6b3e\u65b9\u5fc5\u987b\u4e3a\u94f6\u884c\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                } else if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6570\u5e01\u5145\u503c\u7684\u4e1a\u52a1\uff0c\u4ed8\u6b3e\u65b9\u5fc5\u987b\u4e3a\u94f6\u884c\u8d26\u6237\uff0c\u6536\u6b3e\u65b9\u5fc5\u987b\u4e3a\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                } else if (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6570\u5e01\u5b58\u73b0\u7684\u4e1a\u52a1\uff0c\u4ed8\u6b3e\u65b9\u5fc5\u987b\u4e3a\u94b1\u5305\u8d26\u6237\uff0c\u6536\u6b3e\u65b9\u5fc5\u987b\u4e3a\u94f6\u884c\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                if (!PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) continue;
                if (!isElecPaymentPay) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u6570\u5e01\u94b1\u5305\u7684\u4e1a\u52a1\uff0c\u6536\u6b3e\u65b9\u8d26\u6237\u548c\u4ed8\u6b3e\u65b9\u8d26\u6237\u5fc5\u987b\u5747\u4e3a\u6570\u5e01\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                String payeeType = info.getString("payeetype");
                if (!AsstActTypeEnum.COMPANY.getValue().equals(payeeType) && !AsstActTypeEnum.SUPPLIER.getValue().equals(payeeType) && !AsstActTypeEnum.CUSTOMER.getValue().equals(payeeType)) continue;
                boolean checkInternalOrg = true;
                if (!AsstActTypeEnum.COMPANY.getValue().equals(payeeType) && EmptyUtil.isNoEmpty((Long)(payeeId = info.getLong("payee")))) {
                    DynamicObject payeeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeId, (String)payeeType, (String)"name");
                    DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)info.getDynamicObject("org"), (DynamicObject)payeeObj);
                    checkInternalOrg = EmptyUtil.isNoEmpty((DynamicObject)internalOrg);
                }
                String payeebanknum = info.getString("payeebanknum");
                recAccBank2 = AccountBankHelper.getAccountByNumber((String)payeebanknum);
                if (!checkInternalOrg || (!EmptyUtil.isNoEmpty((DynamicObject)recAccBank2) || recAccBank2.getBoolean("iselecpayment")) && !EmptyUtil.isEmpty((DynamicObject)recAccBank2)) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u6570\u5e01\u94b1\u5305\u7684\u4e1a\u52a1\uff0c\u6536\u6b3e\u65b9\u8d26\u6237\u548c\u4ed8\u6b3e\u65b9\u8d26\u6237\u5fc5\u987b\u5747\u4e3a\u6570\u5e01\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject payAccBank = info.getDynamicObject("payeracctbank");
            if (!EmptyUtil.isNoEmpty((DynamicObject)payAccBank)) continue;
            boolean isElecPaymentPay = (payAccBank = this.getRecAccountBank(payAccBank.getLong("id"))).getBoolean("iselecpayment");
            if (isElecPaymentPay) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u975e\u6570\u5e01\u94b1\u5305\uff0c\u4ed8\u6b3e\u8d26\u6237\u4e0d\u5141\u8bb8\u662f\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if ((recAccBank = this.getRecAccountBank(recAccBankId = info.getLong("payeeacctbank"))) == null || !(isElecPaymentRec = recAccBank.getBoolean("iselecpayment"))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u975e\u6570\u5e01\u94b1\u5305\uff0c\u6536\u6b3e\u8d26\u6237\u4e0d\u5141\u8bb8\u662f\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        logger.info("PaymentDcepSubmitValidator validate end");
    }

    private DynamicObject getRecAccountBank(long recAccBankId) {
        if (EmptyUtil.isNoEmpty((Long)recAccBankId)) {
            return AccountBankHelper.getAccountBankById((long)recAccBankId);
        }
        return null;
    }
}

