/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.payapply;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.helper.SystemParameterHelper;

public class PayApplyAmountValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set selectors = super.preparePropertys();
        selectors.add("e_payeeamount");
        selectors.add("payeeamount");
        selectors.add("e_splitid");
        selectors.add("entry_applyid");
        selectors.add("entry_paystatus");
        selectors.add("entry_payeeamount");
        selectors.add("payorg");
        return selectors;
    }

    public void validate() {
        block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            BigDecimal entry_payeeamount;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            BigDecimal payeeamount = dynamicObject.getBigDecimal("payeeamount");
            DynamicObjectCollection payEntry = dynamicObject.getDynamicObjectCollection("cas_payapplyentry");
            DynamicObjectCollection payInfo = dynamicObject.getDynamicObjectCollection("cas_payinfo");
            Map<String, BigDecimal> payEntryMap = payEntry.stream().collect(Collectors.groupingBy(o -> o.getString("e_splitid"), Collectors.mapping(o -> o.getBigDecimal("e_payeeamount"), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            Map<String, BigDecimal> payInfoMap = payInfo.stream().filter(item -> !PayStatusEnum.CLANCEL.getValue().equals(item.getString("entry_paystatus"))).collect(Collectors.groupingBy(o -> o.getString("entry_applyid"), Collectors.mapping(o -> o.getBigDecimal("entry_payeeamount"), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            if (payEntryMap.size() != payInfoMap.size()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4ed8\u6b3e\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u6536\u6b3e\u603b\u989d", (String)"PayApplyEntryEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), ""));
                continue;
            }
            BigDecimal e_payeeamount = payEntryMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            if (payeeamount.compareTo(e_payeeamount) != 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u7533\u8bf7\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u5e94\u7b49\u4e8e\u6536\u6b3e\u603b\u989d\u3002", (String)"PayApplyEntryEdit_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), ""));
            }
            if (payeeamount.compareTo(entry_payeeamount = payInfoMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4ed8\u6b3e\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u6536\u6b3e\u603b\u989d", (String)"PayApplyEntryEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), ""));
                continue;
            }
            boolean isDeficit = false;
            DynamicObject payOrg = dynamicObject.getDynamicObject("payorg");
            if (payOrg != null) {
                isDeficit = SystemParameterHelper.getParameterBoolean((long)payOrg.getLong("id"), (String)"isdeficit");
            }
            if (!isDeficit && payInfoMap.values().stream().anyMatch(o -> BigDecimal.ZERO.compareTo((BigDecimal)o) >= 0)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u7b49\u4e8e0\u3002", (String)"PayApplySplitPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            for (Map.Entry<String, BigDecimal> entry : payEntryMap.entrySet()) {
                e_payeeamount = entry.getValue();
                entry_payeeamount = BigDecimal.ZERO;
                if (payInfoMap.containsKey(entry.getKey())) {
                    entry_payeeamount = payInfoMap.get(entry.getKey());
                }
                if (e_payeeamount.compareTo(entry_payeeamount) == 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4ed8\u6b3e\u660e\u7ec6\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u6536\u6b3e\u603b\u989d", (String)"PayApplyEntryEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), ""));
                continue block0;
            }
        }
    }
}

