/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.payapply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.enums.PayApplyBillStatusEnum;
import kd.fi.cas.enums.PayApplyPayStatusEnum;
import kd.fi.cas.enums.PayApplyRecChgStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.PaymentQueryHelper;
import kd.fi.cas.opplugin.payapply.PayApplyComfirmScheOp;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyComfirmScheValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(PayApplyComfirmScheOp.class);

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject payApplyDy = dataEntity.getDataEntity();
            boolean result = true;
            boolean isForceStop = false;
            long id = Optional.ofNullable(payApplyDy.getPkValue()).map(o -> Long.parseLong(o.toString())).orElseGet(() -> 0L);
            if (0 == Long.compare(id, 0L)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\uff0c\u518d\u8fdb\u884c\u786e\u8ba4\u6392\u6b3e\u64cd\u4f5c\u3002", (String)"PayApplyBatchScheValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
                isForceStop = true;
            }
            if (payApplyDy.getBoolean("invalidflag")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5df2\u7ecf\u4f5c\u5e9f\uff0c\u4e0d\u652f\u6301\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PayApplyComfirmScheValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
                isForceStop = true;
            }
            String billStatus = payApplyDy.getString("billstatus");
            if (!isForceStop && PayApplyBillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u6216\u8005\u5ba1\u6838\u901a\u8fc7\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u5141\u8bb8\u64cd\u4f5c\u786e\u8ba4\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_16", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
            }
            String headerstatus = payApplyDy.getString("paidstatus");
            if (!isForceStop && !PayApplyPayStatusEnum.NOTPAYING.getValue().equals(headerstatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u672a\u4ed8\u6b3e\u5355\u636e\uff0c\u4e0d\u652f\u6301\u8fdb\u884c\u786e\u8ba4\u6392\u6b3e\u5904\u7406\u3002", (String)"PayApplyComfirmScheValidator_15", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
            }
            HashSet<String> chgStatus = new HashSet<String>(16);
            DynamicObjectCollection applyEntryCol = payApplyDy.getDynamicObjectCollection("cas_payapplyentry");
            BigDecimal payApplyAmt = BigDecimal.ZERO;
            if (!(isForceStop || null != applyEntryCol && applyEntryCol.size() != 0)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7533\u8bf7\u660e\u7ec6\u518d\u53d1\u8d77\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_12", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
            } else {
                for (DynamicObject entry : applyEntryCol) {
                    String chgstatus = entry.getString("e_chgstatus");
                    payApplyAmt = payApplyAmt.add(entry.getBigDecimal("e_payeeamount"));
                    if (!chgstatus.equals(PayApplyRecChgStatusEnum.CHGING.getValue())) continue;
                    chgStatus.add(chgstatus);
                }
            }
            if (!isForceStop && !chgStatus.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u7684\u7533\u8bf7\u5206\u5f55\u6570\u636e\u5904\u4e8e\u53d8\u66f4\u4e2d\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u786e\u8ba4\u6392\u6b3e\u5904\u7406\u3002", (String)"PayApplyComfirmScheValidator_14", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
            }
            DynamicObjectCollection payApplyEntryCol = payApplyDy.getDynamicObjectCollection("cas_payinfo");
            HashSet<String> status = new HashSet<String>(16);
            BigDecimal payInfoAmt = BigDecimal.ZERO;
            for (DynamicObject entry : payApplyEntryCol) {
                String payStatus = entry.getString("entry_paystatus");
                if (payStatus.equals(PayStatusEnum.NOTPAYING.getValue())) {
                    status.add(payStatus);
                }
                if (payStatus.equals(PayStatusEnum.CLANCEL.getValue())) continue;
                payInfoAmt = payInfoAmt.add(entry.getBigDecimal("entry_payeeamount"));
            }
            if (!isForceStop && status.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u6392\u6b3e\u6216\u4e0b\u63a8\u4ed8\u6b3e\uff0c\u65e0\u9700\u786e\u8ba4\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_13", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
            }
            if (!isForceStop && payInfoAmt.compareTo(payApplyAmt) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u603b\u91d1\u989d\u548c\u7533\u8bf7\u660e\u7ec6\u603b\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u652f\u6301\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_19", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                result = false;
            }
            if (isForceStop) continue;
            int count = 1;
            for (DynamicObject payApplyEntry : payApplyEntryCol) {
                String paymentChannel;
                DynamicObject settlementTypeObj = payApplyEntry.getDynamicObject("entry_settlementtype");
                if (null == settlementTypeObj) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u7684\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\uff0c\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u786e\u8ba4\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), count));
                    result = false;
                }
                boolean isCheckOurAcc = PaymentQueryHelper.isCheckOurAccBySysParam((DynamicObject)payApplyDy.getDynamicObject("payorg"), (DynamicObject)settlementTypeObj);
                DynamicObject payAcctObj = payApplyEntry.getDynamicObject("entry_payeraccbank");
                if (isCheckOurAcc && null == payAcctObj) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u7684\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\uff0c\u4ed8\u6b3e\u8d26\u6237\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u786e\u8ba4\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), count));
                    result = false;
                }
                if (EmptyUtil.isEmpty((String)(paymentChannel = payApplyEntry.getString("entry_paymentchannel")))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u7684\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\uff1a\u652f\u4ed8\u6e20\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u786e\u8ba4\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), count));
                    result = false;
                }
                if (null != settlementTypeObj && null != payAcctObj && !EmptyUtil.isEmpty((String)paymentChannel)) {
                    boolean judge = true;
                    String type = settlementTypeObj.getString("settlementtype");
                    if (SettleMentTypeEnum.MONEY.getValue().equals(type)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u7684\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\uff1a\u7ed3\u7b97\u65b9\u5f0f\u6682\u4e0d\u652f\u6301\u73b0\u91d1\u7c7b\u578b\uff0c\u65e0\u6cd5\u786e\u8ba4\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), count));
                        result = false;
                        judge = false;
                    }
                    if (judge) {
                        QFilter filter = new QFilter("acctstatus", "=", (Object)"normal");
                        DynamicObject payOrg = payApplyDy.getDynamicObject("payorg");
                        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)Long.valueOf(payOrg.getPkValue().toString()));
                        filter.and(acctFilter);
                        DynamicObject payeeCurrency = payApplyDy.getDynamicObject("payeecurrency");
                        Object acctCurrencyId = null;
                        if (null != payeeCurrency) {
                            acctCurrencyId = payeeCurrency.getPkValue();
                        }
                        filter.and("currency.fbasedataid.id", "in", acctCurrencyId);
                        filter.and("id", "=", payAcctObj.getPkValue());
                        boolean exist = QueryServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{filter});
                        if (!exist) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u7684\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\uff0c\u4ed8\u6b3e\u5e10\u53f7\u4f7f\u7528\u7ec4\u7ec7\u4e0d\u4e3a\u4ed8\u6b3e\u7ec4\u7ec7\uff0c\u6216\u5e01\u79cd\u4e0d\u5305\u542b\u6536\u6b3e\u5e01\u79cd\uff0c\u6216\u8d26\u6237\u72b6\u6001\u4e3a\u975e\u6b63\u5e38\u7684\u94f6\u884c\u8d26\u53f7\u3002\u8bf7\u52ff\u8fdb\u884c\u786e\u8ba4\u6392\u6b3e\u64cd\u4f5c\u3002", (String)"PayApplyComfirmScheValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]), count));
                            judge = false;
                            result = false;
                        }
                    }
                    if (judge) {
                        boolean issetbankinterface = payAcctObj.getBoolean("issetbankinterface");
                        boolean isopenbank = payAcctObj.getBoolean("isopenbank");
                        ArrayList values = new ArrayList(10);
                        values = issetbankinterface ? (isopenbank ? new ArrayList<String>(3){
                            {
                                this.add(PaymentChannelEnum.BEI.getValue());
                                this.add(PaymentChannelEnum.ONLINEBANK.getValue());
                                this.add(PaymentChannelEnum.COUNTER.getValue());
                            }
                        } : new ArrayList<String>(2){
                            {
                                this.add(PaymentChannelEnum.BEI.getValue());
                                this.add(PaymentChannelEnum.COUNTER.getValue());
                            }
                        }) : (isopenbank ? new ArrayList<String>(2){
                            {
                                this.add(PaymentChannelEnum.ONLINEBANK.getValue());
                                this.add(PaymentChannelEnum.COUNTER.getValue());
                            }
                        } : new ArrayList<String>(2){
                            {
                                this.add(PaymentChannelEnum.COUNTER.getValue());
                            }
                        });
                        if (!values.contains(paymentChannel)) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u7684\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u7b2c%s\u884c\uff0c\u652f\u4ed8\u6e20\u9053\u4e0d\u6ee1\u8db3\u8981\u6c42\uff0c\u65e0\u6cd5\u786e\u8ba4\u6392\u6b3e\u3002", (String)"PayApplyComfirmScheValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]), count));
                            result = false;
                            judge = false;
                        }
                    }
                }
                if (result) {
                    String usage = payApplyEntry.getString("entry_usage");
                    if (PaymentChannelEnum.BEI.getValue().equals(paymentChannel) && EmptyUtil.isEmpty((String)usage)) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"PayApplyComfirmScheValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u4f46\u8f6c\u8d26\u9644\u8a00\u672a\u586b\u5199\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayApplyComfirmScheValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Warning);
                    }
                }
                logger.info(String.format("\u7533\u8bf7\u5355\u3010%s\u3011\u786e\u8ba4\u6392\u6b3e\u6821\u9a8c\u7ed3\u679c: {%s};", payApplyDy.getString("billno"), result));
                ++count;
            }
        }
    }
}

