/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.payapply;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;

public class PayApplyEntryValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set selectors = super.preparePropertys();
        selectors.add("cas_payapplyentry");
        selectors.add("cas_payapplyentry.e_payee");
        selectors.add("cas_payapplyentry.e_payeetype");
        return selectors;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection payApplyEntry = dynamicObject.getDynamicObjectCollection("cas_payapplyentry");
            for (int rowIndex = 0; rowIndex < payApplyEntry.size(); ++rowIndex) {
                DynamicObject account;
                DynamicObject payApplyInfo = (DynamicObject)payApplyEntry.get(rowIndex);
                String accNumber = payApplyInfo.getString("e_payeeaccbanknum");
                boolean isCompany = AsstActTypeEnum.COMPANY.getValue().equals(payApplyInfo.get("e_payeetype"));
                String payeeName = payApplyInfo.getString("e_payeename");
                if (!isCompany || StringUtils.isBlank((CharSequence)accNumber) || StringUtils.isBlank((CharSequence)payeeName) || (account = AccountBankHelper.getAccountByNumber((String)accNumber)) == null) continue;
                DynamicObject payeeOrg = payApplyInfo.getDynamicObject("e_payee");
                if (payeeOrg != null) {
                    boolean canUseAccount = AccountBankHelper.canUseAccount((long)payeeOrg.getLong("id"), (long)account.getLong("id"));
                    if (canUseAccount) continue;
                    String msgFmt = ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6536\u6b3e\u4eba\u4e0e\u6536\u6b3e\u8d26\u53f7\u4e0d\u5339\u914d\uff0c\u6536\u6b3e\u4eba\u6ca1\u6709\u8be5\u6536\u6b3e\u8d26\u53f7\u7684\u4f7f\u7528\u6743\uff0c\u8bf7\u68c0\u67e5\u540e\u4fee\u6539", (String)"PayApplyEntryValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(msgFmt, rowIndex + 1));
                    continue;
                }
                QFilter qFilter = new QFilter("name", "=", (Object)payeeName);
                qFilter.or("simplename", "=", (Object)payeeName);
                Map orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (!orgs.isEmpty() && !orgs.values().stream().noneMatch(org -> AccountBankHelper.canUseAccount((long)org.getLong("id"), (long)account.getLong("id")))) continue;
                String msgFmt = ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6536\u6b3e\u4eba\u4e0e\u6536\u6b3e\u8d26\u53f7\u4e0d\u5339\u914d\uff0c\u6536\u6b3e\u4eba\u6ca1\u6709\u8be5\u6536\u6b3e\u8d26\u53f7\u7684\u4f7f\u7528\u6743\uff0c\u8bf7\u68c0\u67e5\u540e\u4fee\u6539", (String)"PayApplyEntryValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format(msgFmt, rowIndex + 1));
            }
        }
    }
}

