/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.payapply;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayApplySubmitValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set selectors = super.preparePropertys();
        selectors.add("payorg");
        selectors.add("paymenttype");
        selectors.add("e_payee");
        selectors.add("e_buspayeeamount");
        selectors.add("e_payeeamount");
        selectors.add("e_businesstype");
        selectors.add("payeecurrency");
        selectors.add("e_institutioncode");
        selectors.add("e_institutionname");
        selectors.add("e_payeetype");
        selectors.add("e_payeeaccbank");
        selectors.add("entry_businesstype");
        selectors.add("entry_payeraccbank");
        selectors.add("entry_paycurrency");
        selectors.add("e_settlementtype");
        selectors.add("entry_settlementtype");
        selectors.add("entry_payinstitutioncode");
        selectors.add("entry_recinstitutioncode");
        selectors.add("entry_payinstitutionname");
        selectors.add("entry_recinstitutionname");
        return selectors;
    }

    public void validate() {
        block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject payerAcctBank;
            DynamicObjectCollection dynamicObjectCollection;
            List diffOrg;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long payOrgId = dynamicObject.getDynamicObject("payorg").getLong("id");
            DynamicObject paymentType = dynamicObject.getDynamicObject("paymenttype");
            if (paymentType == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u4ed8\u6b3e\u7c7b\u578b\u3002", (String)"PayApplySubmitValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            if ((PayAndRecBizTypeEnum.TRANSFER_SAME.getValue().equals(paymentType.getString("biztype")) || PayAndRecBizTypeEnum.CASH_ACCESS.getValue().equals(paymentType.getString("biztype"))) && (diffOrg = (dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("cas_payapplyentry")).stream().filter(payApplyEntry -> {
                long payeeOrgId = payApplyEntry.getDynamicObject("e_payee") == null ? 0L : Long.parseLong(payApplyEntry.getDynamicObject("e_payee").getPkValue().toString());
                return payeeOrgId != payOrgId;
            }).collect(Collectors.toList())).size() > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b\u4e3a\u540c\u540d\u8f6c\u8d26\u6216\u73b0\u91d1\u5b58\u53d6\u65f6\uff0c\u6536\u4ed8\u6b3e\u65b9\u5fc5\u987b\u76f8\u540c\u3002", (String)"PayApplySubmitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            BigDecimal busPayeeAmount = BigDecimal.ZERO;
            BigDecimal payAmount = BigDecimal.ZERO;
            DynamicObjectCollection businessEntry = dynamicObject.getDynamicObjectCollection("cas_businessentry");
            DynamicObjectCollection payEntry = dynamicObject.getDynamicObjectCollection("cas_payapplyentry");
            for (DynamicObject business : businessEntry) {
                busPayeeAmount = busPayeeAmount.add(business.getBigDecimal("e_buspayeeamount"));
            }
            if (busPayeeAmount.compareTo(BigDecimal.ZERO) != 0) {
                for (DynamicObject pay : payEntry) {
                    payAmount = payAmount.add(pay.getBigDecimal("e_payeeamount"));
                }
                if (busPayeeAmount.compareTo(payAmount) != 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u660e\u7ec6\u6c47\u603b\u6536\u6b3e\u91d1\u989d\u4e0e\u7533\u8bf7\u660e\u7ec6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
            }
            if (!SystemStatusCtrolHelper.isInitEnable((long)payOrgId)) {
                this.addErrorMessage(dataEntity, SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)dynamicObject.getDynamicObject("payorg"), (String)"name")));
            }
            Set settlementType = payEntry.stream().filter(Objects::nonNull).filter(entry -> EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("e_settlementtype"))).map(entry -> entry.getDynamicObject("e_settlementtype").getString("settlementtype")).collect(Collectors.toSet());
            DynamicObjectCollection payInfoEntry = dynamicObject.getDynamicObjectCollection("cas_payinfo");
            if (settlementType.contains(SettleMentTypeEnum.DCEP.getValue()) && settlementType.size() > 1) continue;
            if (settlementType.contains(SettleMentTypeEnum.DCEP.getValue())) {
                String businessType;
                DynamicObject currency = dynamicObject.getDynamicObject("payeecurrency");
                String currencyCode = currency.getString("number");
                if (!"CNY".equals(currencyCode)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u4e3a\u6570\u5e01\u94b1\u5305\u65f6\uff0c\u6536\u6b3e\u5e01\u79cd\u9700\u4e3a\u4eba\u6c11\u5e01\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                for (DynamicObject entry2 : payEntry) {
                    int index;
                    if (EmptyUtil.isEmpty((String)entry2.getString("e_businesstype"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    businessType = entry2.getString("e_businesstype");
                    String payeeType = entry2.getString("e_payeetype");
                    DynamicObject payee = entry2.getDynamicObject("e_payee");
                    DynamicObject payeeAcctBank = entry2.getDynamicObject("e_payeeaccbank");
                    if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType)) {
                        if (!"bos_org".equals(payeeType)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6570\u5e01\u5145\u503c/\u6570\u5e01\u63d0\u73b0\u65f6\uff0c\u6536\u6b3e\u4eba\u7c7b\u578b\u9700\u4e3a\u516c\u53f8\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                            break;
                        }
                        if (payOrgId != payee.getLong("id")) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6570\u5e01\u5145\u503c/\u6570\u5e01\u63d0\u73b0\u65f6\uff0c\u6536\u6b3e\u4eba\u9700\u4e3a\u4ed8\u6b3e\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                            break;
                        }
                        if (EmptyUtil.isNoEmpty((DynamicObject)payeeAcctBank) && !payeeAcctBank.getBoolean("iselecpayment") && PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6570\u5e01\u5145\u503c/\u6570\u5e01\u8f6c\u8d26\u65f6\uff0c\u6536\u6b3e\u8d26\u53f7\u9700\u4e3a\u6570\u5e01\u8d26\u6237\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_10", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                            break;
                        }
                        if (EmptyUtil.isNoEmpty((DynamicObject)payeeAcctBank) && payeeAcctBank.getBoolean("iselecpayment") && PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6570\u5e01\u5b58\u73b0\u65f6\uff0c\u6536\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u6570\u5e01\u8d26\u6237\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_11", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                            break;
                        }
                    } else if (PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType) && EmptyUtil.isNoEmpty((DynamicObject)payeeAcctBank) && !payeeAcctBank.getBoolean("iselecpayment")) {
                        DynamicObject internalOrg;
                        Object object = internalOrg = "bd_supplier".equals(payeeType) || "bd_customer".equals(payeeType) ? BaseDataHelper.getInternalOrg((DynamicObject)payee) : null;
                        if ("bos_org".equals(payeeType) || internalOrg != null) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6570\u5e01\u5145\u503c/\u6570\u5e01\u8f6c\u8d26\u65f6\uff0c\u6536\u6b3e\u8d26\u53f7\u9700\u4e3a\u6570\u5e01\u8d26\u6237\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_10", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                            break;
                        }
                    }
                    if (!businessType.equals(((DynamicObject)payInfoEntry.get(index = payEntry.indexOf((Object)entry2))).getString("entry_businesstype"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u4e0e\u4ed8\u6b3e\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u9700\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_17", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    DynamicObject paySettleType = ((DynamicObject)payInfoEntry.get(index)).getDynamicObject("entry_settlementtype");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)paySettleType) || SettleMentTypeEnum.DCEP.getValue().equals(paySettleType.getString("settlementtype"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u4e3a\u6570\u5e01\u94b1\u5305\u65f6\uff0c\u4ed8\u6b3e\u660e\u7ec6\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u9700\u4e3a\u6570\u5e01\u94b1\u5305\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_18", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    break;
                }
                for (DynamicObject entry2 : payInfoEntry) {
                    if (EmptyUtil.isEmpty((String)entry2.getString("entry_businesstype"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_12", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        continue block0;
                    }
                    businessType = entry2.getString("entry_businesstype");
                    payerAcctBank = entry2.getDynamicObject("entry_payeraccbank");
                    if (EmptyUtil.isNoEmpty((DynamicObject)payerAcctBank) && !payerAcctBank.getBoolean("iselecpayment") && (PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6570\u5e01\u5b58\u73b0/\u6570\u5e01\u8f6c\u8d26\u65f6\uff0c\u4ed8\u6b3e\u8d26\u53f7\u9700\u4e3a\u6570\u5e01\u8d26\u6237\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_13", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        continue block0;
                    }
                    if (EmptyUtil.isNoEmpty((DynamicObject)payerAcctBank) && payerAcctBank.getBoolean("iselecpayment") && PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6570\u5e01\u5145\u503c\u65f6\uff0c\u4ed8\u6b3e\u8d26\u53f7\u4e0d\u80fd\u6570\u5e01\u8d26\u6237\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_14", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        continue block0;
                    }
                    DynamicObject payCurrency = entry2.getDynamicObject("entry_paycurrency");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)payCurrency) || "CNY".equals(payCurrency.getString("number"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u4e3a\u6570\u5e01\u94b1\u5305\u65f6\uff0c\u4ed8\u6b3e\u5e01\u79cd\u9700\u4e3a\u4eba\u6c11\u5e01\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_15", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    continue block0;
                }
                continue;
            }
            for (DynamicObject entry3 : payInfoEntry) {
                String businessType;
                int index = payInfoEntry.indexOf((Object)entry3);
                DynamicObject settleType = entry3.getDynamicObject("entry_settlementtype");
                String settleTypeString = EmptyUtil.isNoEmpty((DynamicObject)settleType) ? settleType.getString("settlementtype") : "";
                payerAcctBank = entry3.getDynamicObject("entry_payeraccbank");
                DynamicObject payeeAcctBank = index >= payEntry.size() ? null : ((DynamicObject)payEntry.get(index)).getDynamicObject("e_payeeaccbank");
                String string = businessType = index >= payEntry.size() ? null : ((DynamicObject)payEntry.get(index)).getString("e_businesstype");
                if (EmptyUtil.isNoEmpty((String)entry3.getString("entry_businesstype")) || EmptyUtil.isNoEmpty((String)businessType)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u975e\u6570\u5e01\u94b1\u5305\u65f6\uff0c\u7533\u8bf7\u660e\u7ec6/\u4ed8\u6b3e\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u9700\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_16", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    continue block0;
                }
                if (SettleMentTypeEnum.DCEP.getValue().equals(settleTypeString)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u975e\u6570\u5e01\u94b1\u5305\u65f6\uff0c\u4ed8\u6b3e\u660e\u7ec6\u7ed3\u7b97\u65b9\u5f0f.\u7c7b\u522b\u4e0d\u80fd\u4e3a\u6570\u5e01\u94b1\u5305\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_19", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    continue block0;
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)payerAcctBank) && payerAcctBank.getBoolean("iselecpayment")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\u65f6\uff0c\u4ed8\u6b3e\u8d26\u53f7\u4e0d\u80fd\u6570\u5e01\u8d26\u6237\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_20", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    continue block0;
                }
                if (!EmptyUtil.isNoEmpty((DynamicObject)payeeAcctBank) || !payeeAcctBank.getBoolean("iselecpayment")) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\u65f6\uff0c\u6536\u6b3e\u8d26\u53f7\u4e0d\u80fd\u6570\u5e01\u8d26\u6237\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u63d0\u4ea4\u3002", (String)"PayApplySubmitValidator_21", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue block0;
            }
        }
    }
}

