/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.fi.cas.helper.CasHelper;

public class CheckIsDrawValidator
extends AbstractValidator {
    public void validate() {
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)this.dataEntities[0].getDataEntity().getDataEntityType().getName());
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean isDrawBill;
            DynamicObject info = dataEntity.getDataEntity();
            if (!CasHelper.isNotEmpty((Object)info.getString("sourcebilltype")) || "CmpAgentPayBill".equals(info.getString("sourcebilltype")) || (isDrawBill = this.isDrawBill(info, linkSet))) continue;
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
            for (DynamicObject entryRow : entry) {
                if (this.isDrawEntryRow(entryRow, linkSet)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0b\u63a8\u751f\u6210\u7684\u5355\u636e\uff0c\u7f3a\u5931botp\u5173\u8054\u5173\u7cfb\u4fe1\u606f\u3002", (String)"CheckIsDrawValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean isDrawBill(DynamicObject billObj, LinkSetElement linkSet) {
        while (billObj.getParent() != null) {
            billObj = (DynamicObject)billObj.getParent();
        }
        ExtendedDataEntitySet dataSet = new ExtendedDataEntitySet();
        dataSet.Parse(new DynamicObject[]{billObj}, (MainEntityType)billObj.getDataEntityType());
        boolean isDraw = false;
        block1: for (LinkSetItemElement linkEntry : linkSet.getItems()) {
            ExtendedDataEntity[] rows;
            if (!StringUtils.equalsIgnoreCase((CharSequence)linkEntry.getParentEntityKey(), (CharSequence)billObj.getDataEntityType().getName()) || (rows = dataSet.FindByEntityKey(linkEntry.getLinkEntityKey())) == null || rows.length <= 0) continue;
            for (ExtendedDataEntity row : rows) {
                if (!this.haveSourceBillId(row.getDataEntity())) continue;
                isDraw = true;
                continue block1;
            }
        }
        return isDraw;
    }

    private boolean isDrawEntryRow(DynamicObject entryRow, LinkSetElement linkSet) {
        EntryType entryType = (EntryType)entryRow.getDataEntityType();
        boolean isDraw = false;
        block0: for (LinkSetItemElement linkEntry : linkSet.getItems()) {
            DynamicObjectCollection subEntryRows;
            if (StringUtils.equalsIgnoreCase((CharSequence)linkEntry.getParentEntityKey(), (CharSequence)entryType.getName())) {
                DynamicObjectCollection linkRows = entryRow.getDynamicObjectCollection(linkEntry.getLinkEntityKey());
                if (!this.haveSourceBillId(linkRows)) continue;
                isDraw = true;
                break;
            }
            IDataEntityProperty prop = (IDataEntityProperty)entryType.getProperties().get((Object)linkEntry.getParentEntityKey());
            if (prop == null || (subEntryRows = entryRow.getDynamicObjectCollection(linkEntry.getParentEntityKey())) == null || subEntryRows.isEmpty()) continue;
            for (DynamicObject subEntryRow : subEntryRows) {
                DynamicObjectCollection linkRows = subEntryRow.getDynamicObjectCollection(linkEntry.getLinkEntityKey());
                if (!this.haveSourceBillId(linkRows)) continue;
                isDraw = true;
                continue block0;
            }
        }
        return isDraw;
    }

    private boolean haveSourceBillId(DynamicObjectCollection linkRows) {
        if (linkRows == null || !linkRows.iterator().hasNext()) {
            return false;
        }
        for (DynamicObject linkRow : linkRows) {
            if (!this.haveSourceBillId(linkRow)) continue;
            return true;
        }
        return false;
    }

    private boolean haveSourceBillId(DynamicObject linkRow) {
        LinkEntryType linkType = (LinkEntryType)linkRow.getDataEntityType();
        Long sBillId = (Long)linkType.getSBillIdProp().getValueFast((Object)linkRow);
        return sBillId != null && sBillId != 0L;
    }
}

