/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;

public class PayImpTemplateValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities != null && this.dataEntities.length > 0 && this.getOption().containsVariable("tempid")) {
            Set<Long> idSet;
            String tempid = this.getOption().getVariableValue("tempid");
            if (CasHelper.isEmpty((Object)tempid)) {
                return;
            }
            Map idToExtDataMap = Arrays.stream(this.dataEntities).collect(Collectors.groupingBy(e -> e.getDataEntity().getLong("id"), Collectors.mapping(o -> o, Collectors.toList())));
            String noSaveMsg = ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u586b\u5145\u3002", (String)"PayImpTemplateValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            for (ExtendedDataEntity extDataEntitie : this.dataEntities) {
                DynamicObject dataEntitie = extDataEntitie.getDataEntity();
                if (BillStatusEnum.SAVE.getValue().equals(dataEntitie.get("billstatus"))) continue;
                idToExtDataMap.remove(dataEntitie.getLong("id"));
                this.addErrorMessage(extDataEntitie, noSaveMsg);
            }
            QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(tempid));
            filter.and(new QFilter("enable", "=", (Object)"1"));
            QFilter qFilter = null;
            DynamicObject payPlan = BusinessDataServiceHelper.loadSingle((String)"cas_interpayplan", (String)"id,number,org,filtercon,payeracctbank,settletype,paymentchannel,usage", (QFilter[])new QFilter[]{filter});
            if (payPlan != null) {
                String filterCon = payPlan.getString("filtercon");
                FilterCondition condition = (FilterCondition)JSON.parseObject((String)filterCon, FilterCondition.class);
                MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)"cas_paybill");
                FilterBuilder fb = new FilterBuilder(dataType, condition, true);
                fb.buildFilter(true);
                qFilter = fb.getQFilter();
            }
            if ((idSet = idToExtDataMap.keySet()).size() > 0) {
                QFilter qf = new QFilter("id", "in", idSet);
                if (payPlan != null && payPlan.getDynamicObject("org") != null) {
                    qf.and(new QFilter("org.id", "=", payPlan.getDynamicObject("org").getPkValue()));
                }
                if (qFilter != null) {
                    qf.and(qFilter);
                }
                DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billno,payeracctbank,payeracctcash,payerbank,settletype,paymentchannel,usage,openorg,settleorg", (QFilter[])new QFilter[]{qf});
                Set coincidentBillIdList = Arrays.stream(payBills).map(p -> p.getLong("id")).collect(Collectors.toSet());
                String nonconforming = ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u667a\u80fd\u586b\u5145\u65b9\u6848\u9002\u7528\u6761\u4ef6\u3002", (String)"PayImpTemplateValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                for (Map.Entry entry : idToExtDataMap.entrySet()) {
                    Long idKey = entry.getKey();
                    if (coincidentBillIdList.contains(idKey)) continue;
                    ExtendedDataEntity valueData = (ExtendedDataEntity)entry.getValue().get(0);
                    this.addErrorMessage(valueData, nonconforming);
                }
                if (!CasHelper.isEmpty((DynamicObject[])payBills) && payPlan != null) {
                    String cashNoFill = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u667a\u80fd\u586b\u5145\u65b9\u6848\u7684\u9ed8\u8ba4\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u7a7a\uff0c\u4ed8\u6b3e\u5355\u7684\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u4e3a\u73b0\u91d1\uff0c\u4e0d\u5141\u8bb8\u586b\u5145\u3002", (String)"PayImpTemplateValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    DynamicObject payPlanSettleType = payPlan.getDynamicObject("settletype");
                    for (DynamicObject payBill : payBills) {
                        DynamicObject payBillSettleType = payBill.getDynamicObject("settletype");
                        if (payPlanSettleType != null || !BaseDataHelper.isSettleTypeCash((DynamicObject)payBillSettleType)) continue;
                        long id = payBill.getLong("id");
                        ExtendedDataEntity extendedData = (ExtendedDataEntity)idToExtDataMap.get(id).get(0);
                        this.addErrorMessage(extendedData, cashNoFill);
                    }
                }
            }
        }
    }
}

