/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDException;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.enums.PaymentChannelEnum;

public class PaymentAuditValidator
extends AbstractValidator {
    public void validate() {
        PaymentErrorCode paymentErrorCode = new PaymentErrorCode();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            String paymentchannel = info.getString("paymentchannel");
            if (!PaymentChannelEnum.COUNTER.getValue().equals(paymentchannel)) continue;
            String payee = info.getString("payee");
            String payeename = info.getString("payeename");
            if (!StringUtils.isEmpty((CharSequence)payee) || !StringUtils.isEmpty((CharSequence)payeename)) continue;
            throw new KDException(paymentErrorCode.PAYEE_NOTNULL_COUNTER(), new Object[0]);
        }
    }
}

