/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.service.LetterCreditService;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class PaymentLCOpenValidator
extends AbstractValidator {
    private static final Map<String, String> CASOP_TO_LCOPMAP = new HashMap<String, String>(8);

    public void validate() {
        block9: {
            List<Object> lcOpenEntityList;
            String operateKey;
            block10: {
                boolean saveAndSubmit;
                operateKey = this.getOperateKey();
                boolean bl = saveAndSubmit = "save".equals(operateKey) || "submit".equals(operateKey);
                if (saveAndSubmit) {
                    lcOpenEntityList = new ArrayList(this.dataEntities.length);
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        DynamicObject dynamicObject = dataEntity.getDataEntity();
                        DynamicObject settleType = dynamicObject.getDynamicObject("settletype");
                        String settletNumber = dynamicObject.getString("settletnumber");
                        boolean lcOpenSettlement = PayBillHepler.isLCSettlement((DynamicObject)settleType, (SettleMentTypeEnum)SettleMentTypeEnum.CREDITOPEN);
                        if (lcOpenSettlement && PaymentChannelEnum.BEI.getValue().equals(dynamicObject.getString("paymentchannel"))) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u4e3a\u201c\u4fe1\u7528\u8bc1\u5f00\u7acb\u201d\u65f6\uff0c\u652f\u4ed8\u6e20\u9053\u4e0d\u5141\u8bb8\u9009\u62e9\u94f6\u4f01\u4e92\u8054\u3002", (String)"PaymentLCOpenValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (!lcOpenSettlement || !StringUtils.isNotBlank((CharSequence)settletNumber)) continue;
                        lcOpenEntityList.add(dataEntity);
                    }
                } else {
                    lcOpenEntityList = Arrays.stream(this.dataEntities).filter(data -> {
                        DynamicObject info = data.getDataEntity();
                        DynamicObject settleType = info.getDynamicObject("settletype");
                        String settletNumber = info.getString("settletnumber");
                        return StringUtils.isNotBlank((CharSequence)settletNumber) && PayBillHepler.isLCSettlement((DynamicObject)settleType, (SettleMentTypeEnum)SettleMentTypeEnum.CREDITOPEN);
                    }).collect(Collectors.toList());
                }
                if (lcOpenEntityList.isEmpty()) break block9;
                if (!CASOP_TO_LCOPMAP.containsKey(operateKey)) break block10;
                if (saveAndSubmit) {
                    for (ExtendedDataEntity extendedDataEntity : lcOpenEntityList) {
                        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                        Long pkValue = (Long)dataEntity.getPkValue();
                        if (pkValue != null && pkValue != 0L) continue;
                        long l2 = DB.genLongId((String)"cas_paybill");
                        dataEntity.set("id", (Object)l2);
                    }
                }
                Map<Long, List<ExtendedDataEntity>> idToObjMap = lcOpenEntityList.stream().collect(Collectors.groupingBy(e -> (Long)e.getDataEntity().getPkValue()));
                List list = idToObjMap.values().stream().map(e -> ((ExtendedDataEntity)e.get(0)).getDataEntity()).collect(Collectors.toList());
                String lcOperate = CASOP_TO_LCOPMAP.get(operateKey);
                Map idToMsgMap = LetterCreditService.callLetterCreditService((String)lcOperate, list);
                if (idToMsgMap == null || idToMsgMap.isEmpty()) break block9;
                for (Map.Entry idToMsg : idToMsgMap.entrySet()) {
                    Long id = (Long)idToMsg.getKey();
                    ExtendedDataEntity dataEntities = idToObjMap.get(id).get(0);
                    String errorMsg = (String)idToMsg.getValue();
                    if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
                    this.addErrorMessage(dataEntities, errorMsg);
                }
                break block9;
            }
            if ("unaudit".equals(operateKey)) {
                Set lcBillNoSet = lcOpenEntityList.stream().map(d -> d.getDataEntity().getString("settletnumber")).collect(Collectors.toSet());
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"lc_lettercredit", (String)"id,billno,sourcebilltype,srcbillid", (QFilter[])new QFilter[]{new QFilter("billno", "in", lcBillNoSet)});
                Map payBillIdToBillTypeMap = dynamicObjectCollection.stream().collect(Collectors.groupingBy(l -> l.getLong("srcbillid"), Collectors.mapping(l -> l.getString("sourcebilltype"), Collectors.toList())));
                for (ExtendedDataEntity extendedDataEntity : lcOpenEntityList) {
                    String billType;
                    Long id = extendedDataEntity.getDataEntity().getLong("id");
                    List billTypeList = payBillIdToBillTypeMap.get(id);
                    if (EmptyUtil.isEmpty(billTypeList) || !"cas_paybill".equals(billType = (String)billTypeList.get(0))) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u5355\u5df2\u4e0b\u63a8\u4fe1\u7528\u8bc1\u5f00\u8bc1\u5904\u7406\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002\u5982\u9700\u53cd\u5ba1\u6838\uff0c\u8bf7\u5220\u9664\u4e0b\u63a8\u7684\u5f00\u8bc1\u5904\u7406\u5355\u3002", (String)"PaymentLCOpenValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    static {
        CASOP_TO_LCOPMAP.put("save", "saveValidate");
        CASOP_TO_LCOPMAP.put("submit", "submitValidate");
        CASOP_TO_LCOPMAP.put("audit", "auditValidate");
        CASOP_TO_LCOPMAP.put("pay", "payValidate");
    }
}

