/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.fi.cas.helper.BotpFixLinkHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentSaveNewValidator
extends AbstractValidator {
    public void validate() {
        Set orgIds = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDataEntity().getDynamicObject("org"))).map(d -> d.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        Map orgCtrlMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIds);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject sysStatusCtrl;
            long orgId;
            DynamicObject info = dataEntity.getDataEntity();
            String srcBillType = info.getString("sourcebilltype");
            DynamicObject org = info.getDynamicObject("org");
            if (CasHelper.isEmpty((Object)org)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u4eba\u3002", (String)"ReceivingBillSaveValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            long l = orgId = CasHelper.isEmpty((Object)org) ? 0L : org.getLong("id");
            if (CasHelper.isNotEmpty((Object)srcBillType) && ((sysStatusCtrl = (DynamicObject)orgCtrlMap.get(String.valueOf(orgId))) == null || CasHelper.isEmpty((Object)sysStatusCtrl.getDynamicObject("standardcurrency")))) {
                KDBizException exception = new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"PaymentSaveImpl_0", (String)"fi-cas-business", (Object[])new Object[0]));
                this.exceptionProcess(dataEntity, (Exception)((Object)exception), ErrorLevel.Error);
                continue;
            }
            DynamicObject entrustorg = info.getDynamicObject("entrustorg");
            if (CasHelper.isNotEmpty((Object)entrustorg) && CasHelper.isNotEmpty((Object)org) && orgId == entrustorg.getLong("id")) {
                info.set("entrustorg", null);
            }
            if (!info.getBoolean("isheadpush")) continue;
            String srcBillId = info.getString("sourcebillid");
            String srcEntry = info.getString("sourceentry");
            new BotpFixLinkHelper().fixRowLink(info, "entry", "sourcebilltype", srcBillId, srcEntry, "e_sourcebillentryid");
        }
    }

    protected void exceptionProcess(ExtendedDataEntity dataEntity, Exception e, ErrorLevel error) {
        this.addMessage(dataEntity, e.getMessage(), error);
        this.getValidateResult().setSuccess(false);
    }
}

