/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recchg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.botp.helper.CasHelper;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.errorcode.CasErrorCode;
import kd.fi.cas.business.errorcode.ReceivErrorCode;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.journal.RecBillBookJournalbuilder;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.MultiBaseDataHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.helper.VoucherBookHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RecBillRecValidator
extends AbstractValidator {
    private JournalServiceAdapter journalServiceAdapter = null;

    public RecBillRecValidator(JournalServiceAdapter journalServiceAdapter) {
        this.journalServiceAdapter = journalServiceAdapter;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setOperationName(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u6536\u6b3e", (String)"ReceivRecOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
    }

    public void validate() {
        Set idSet = Arrays.stream(this.dataEntities).map(item -> item.getDataEntity().getLong("id")).collect(Collectors.toSet());
        Set orgIdSet = Arrays.stream(this.dataEntities).map(item -> item.getDataEntity().getLong("org.id")).collect(Collectors.toSet());
        Set accountBankIdSet = Arrays.stream(this.dataEntities).filter(o -> kd.fi.cas.helper.CasHelper.isNotEmpty((Object)o.getDataEntity().getDynamicObject("accountbank"))).map(o -> o.getDataEntity().getDynamicObject("accountbank").getLong("id")).collect(Collectors.toSet());
        Map orgAndCurrentPeriodMap = SystemStatusCtrolHelper.getCurrentPeriod(orgIdSet);
        boolean isContainAgent = Arrays.stream(this.dataEntities).anyMatch(item -> item.getDataEntity().getBoolean("isagent"));
        Pair agentTransInfo = Pair.of((Object)true, (Object)"");
        if (isContainAgent) {
            try {
                CasBotpHelper.checkpush((String)"cas_recbill", (String[])new String[]{"cas_recbill"});
            }
            catch (KDException e2) {
                agentTransInfo = Pair.of((Object)false, (Object)e2.getMessage());
            }
        }
        Map batchAccClosed = AccountBankHelper.isBatchClosed(accountBankIdSet);
        Map systemParamsMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIdSet));
        Map systemParamsCdmMap = SystemParameterHelper.getSystemParamsCdmByOrgIds(new ArrayList(orgIdSet));
        if (!this.getOption().containsVariable("draftbillno")) {
            Arrays.stream(this.dataEntities).filter(item -> {
                DynamicObject dataEntity = item.getDataEntity();
                String sourceBillType = (String)dataEntity.get("sourcebilltype");
                return !"cas_claimcenterbill".equals(sourceBillType) && !"cas_claimbill".equals(sourceBillType);
            });
        }
        DynamicObject draftBill = null;
        ArrayList<DynamicObject> bizBills = new ArrayList<DynamicObject>(10);
        if (this.getOption().containsVariable("draftbillno")) {
            String draftBillId = this.getOption().getVariableValue("draftbillno");
            draftBill = BusinessDataServiceHelper.loadSingle((Object)draftBillId, (String)"cdm_draftbillf7");
        }
        Map voucherNotSubmitMap = VoucherBookHelper.checkVoucherNotSubmit(idSet, (String)"cas_recbill");
        Set needInfoFinalIdSet = Arrays.stream(this.dataEntities).filter(item -> {
            DynamicObject info = item.getDataEntity();
            String receivingType = info.getDynamicObject("receivingtype").getString("biztype");
            return receivingType.equals(PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue());
        }).map(item -> item.getDataEntity().getPkValue()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("sourcebillid", "in", needInfoFinalIdSet);
        DynamicObjectCollection recTransBillRecordColl = QueryServiceHelper.query((String)"ifm_rectransbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{qFilter});
        Map<Object, List<DynamicObject>> pkAndFinalMap = recTransBillRecordColl.stream().collect(Collectors.groupingBy(item -> item.get("sourcebillid")));
        Map orgInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIdSet);
        List ids = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getString("id")).collect(Collectors.toList());
        List lockedIds = TxCheckUtil.getLocked(ids);
        String isLock = "false";
        if (this.getOption().containsVariable("isLock")) {
            isLock = this.getOption().getVariableValue("isLock");
        }
        DynamicObjectCollection dbBills = QueryServiceHelper.query((String)this.getEntityKey(), (String)"id,billstatus", (QFilter[])new QFilter("id", "in", idSet).toArray());
        Map<Long, String> statusMap = dbBills.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d.getString("billstatus")));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            List<DynamicObject> recTransBillRecords;
            String receivingType;
            DynamicObject accountBank;
            DynamicObject period;
            DynamicObject info = dataEntity.getDataEntity();
            if (!"true".equals(isLock) && lockedIds.contains(info.getString("id"))) {
                String error = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentCancelPayValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, error, ErrorLevel.Error);
            }
            DynamicObject org = info.getDynamicObject("org");
            Long currOrgId = org.getLong("id");
            String billStatus = "true".equals(this.getOption().getVariables().get("isHot")) ? info.getString("billstatus") : statusMap.get(info.getLong("id"));
            ReceivErrorCode receivErrorCode = new ReceivErrorCode();
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addMessage(dataEntity, receivErrorCode.STATUS_CANNOT_REC().getMessage(), ErrorLevel.Error);
                continue;
            }
            DynamicObject orgInit = (DynamicObject)orgInitMap.get(org.getString("id"));
            if (org == null || !SystemStatusCtrolHelper.isInitEnable((DynamicObject)orgInit)) {
                this.addErrorMessage(dataEntity, SystemStatusCtrolHelper.getNotInitMsg((String)kd.fi.cas.helper.CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
            }
            if ((period = (DynamicObject)orgAndCurrentPeriodMap.get(currOrgId)) == null) {
                this.addMessage(dataEntity, new CasErrorCode().CURRENTPERIOD_IS_NULL().getMessage(), ErrorLevel.Error);
                continue;
            }
            if (info.getBoolean("isagent")) {
                DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
                boolean isNullRealRecCompany = entry.stream().anyMatch(s -> s.get("realreccompany") == null);
                if (isNullRealRecCompany) {
                    this.addMessage(dataEntity, receivErrorCode.TRAG_CANNOT_REC().getMessage(), ErrorLevel.Error);
                }
                if (!((Boolean)agentTransInfo.getKey()).booleanValue()) {
                    this.addMessage(dataEntity, (String)agentTransInfo.getRight(), ErrorLevel.Error);
                    continue;
                }
            }
            String sourceBillType = (String)info.get("sourcebilltype");
            String hotAccount = (String)info.get("hotaccount");
            if (!(this.getOption().containsVariable("draftbillno") || "cas_claimcenterbill".equals(sourceBillType) || "cas_claimbill".equals(sourceBillType) || "2".equals(hotAccount))) {
                String key = DraftHelper.getKey((Object)info.get("settletype"));
                String msg = "";
                Boolean orgCS123Bool = (Boolean)((Map)systemParamsMap.get(currOrgId.toString())).get("cs123");
                if (orgCS123Bool.booleanValue() && PaymentBillPluginHelper.needSelectedDraft((DynamicObject)info)) {
                    if (!this.getOption().containsVariable("draftids")) {
                        msg = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u4e3a\u6c47\u7968\u6216\u652f\u7968\u6216\u672c\u7968\u7684\u6536\u6b3e\u5355\u4e0d\u652f\u6301\u6279\u91cf\u786e\u8ba4\u6536\u6b3e\uff0c\u8bf7\u9009\u62e9\u5355\u7b14\u6570\u636e\u8fdb\u884c\u786e\u8ba4\u6536\u6b3e\u3002", (String)"RecBillRecImpl_49", (String)"fi-cas-business", (Object[])new Object[0]);
                        this.addMessage(dataEntity, msg, ErrorLevel.Error);
                        continue;
                    }
                } else {
                    DynamicObjectCollection draftBillCol = info.getDynamicObjectCollection("draftbill");
                    msg = draftBillCol != null && draftBillCol.size() > 0 ? "" : DraftHelper.getRecWarnMesg((Map)systemParamsCdmMap, (String)key, (String)org.getString("id"));
                    if (!CasHelper.isEmpty((String)key) && !CasHelper.isEmpty((String)msg)) {
                        this.addMessage(dataEntity, msg, ErrorLevel.Error);
                        continue;
                    }
                }
            }
            if (null != (accountBank = info.getDynamicObject("accountbank")) && ((Boolean)batchAccClosed.get(accountBank.getLong("id"))).booleanValue()) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), accountBank.getString("number")), ErrorLevel.Error);
                continue;
            }
            if (((Boolean)voucherNotSubmitMap.get(info.getPkValue())).booleanValue()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u51ed\u8bc1\u51b2\u9500\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u786e\u8ba4\u6536\u6b3e\u3002", (String)"RecBillRecImpl_10", (String)"fi-cas-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (this.isNeedBook(info, draftBill)) {
                bizBills.add(info);
            }
            if ((receivingType = info.getDynamicObject("receivingtype").getString("biztype")).equals(PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue()) && !CollectionUtils.isEmpty(recTransBillRecords = pkAndFinalMap.get(info.getPkValue()))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u6e38\u5185\u90e8\u91d1\u878d\u6536\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u786e\u8ba4\u6536\u6b3e\u3002", (String)"RecBillRecImpl_11", (String)"fi-cas-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (this.isFromClaimNoticeAndDraftBill(info)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5185\u7684\u7968\u636e\u6682\u672a\u767b\u8bb0\u5165\u5e93\uff0c\u4e0d\u80fd\u786e\u8ba4\u6536\u6b3e\u3002", (String)"RecBillRecImpl_12", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            }
            HashMap<String, Integer> billNumberIndexMap = new HashMap<String, Integer>(16);
            DynamicObjectCollection entries = info.getDynamicObjectCollection("entry");
            int i = 1;
            for (DynamicObject entry : entries) {
                String coreBillType = entry.getString("e_corebilltype");
                String coreBillNo = entry.getString("e_corebillno");
                if (coreBillNo != null && "cas_paybill".equals(coreBillType)) {
                    billNumberIndexMap.put(coreBillNo, i + 1);
                }
                ++i;
            }
            if (billNumberIndexMap.isEmpty()) continue;
            ArrayList billNumbersToQuery = new ArrayList(billNumberIndexMap.keySet());
            QFilter qFilter1 = new QFilter("billno", "in", billNumbersToQuery);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billno", (QFilter[])new QFilter[]{qFilter1});
            Set billnos = query.stream().map(s -> s.getString("billno")).collect(Collectors.toSet());
            billNumberIndexMap.entrySet().stream().filter(s -> !billnos.contains(s.getKey())).forEach(e -> {
                String billNo = (String)e.getKey();
                Integer index = (Integer)e.getValue();
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u660e\u7ec6\u7b2c%1$s\u884c\uff1a\u4ed8\u6b3e\u5355%2$s\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5173\u8054\u8be5\u4ed8\u6b3e\u5355\u5e76\u786e\u8ba4\u6536\u6b3e\u3002", (String)"RecBillRecImpl_50", (String)"fi-cas-business", (Object[])new Object[0]), index, billNo), ErrorLevel.Error);
            });
        }
        if (bizBills.size() > 0) {
            HashMap errorResult = new HashMap();
            RecBillBookJournalbuilder builder = new RecBillBookJournalbuilder();
            builder.setIsValidata(Boolean.TRUE);
            this.journalServiceAdapter.validateBooks((IBookJournalBuilder)builder, bizBills, errorResult);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject info = dataEntity.getDataEntity();
                Exception recBookExc = (Exception)errorResult.get(info.getLong("id"));
                if (null == recBookExc) continue;
                this.addMessage(dataEntity, recBookExc.getMessage(), ErrorLevel.Error);
            }
        }
    }

    private boolean isNeedBook(DynamicObject info, DynamicObject draftBill) {
        if (draftBill != null) {
            info.set("settletnumber", (Object)draftBill.getString("draftbillno"));
            info.set("draftbill", (Object)MultiBaseDataHelper.generateMultiPropValue((DynamicObject)info, (String)"draftbill", (DynamicObject[])new DynamicObject[]{draftBill}));
            return false;
        }
        return RecBillHepler.isNeedBook((DynamicObject)info);
    }

    private boolean isFromClaimNoticeAndDraftBill(DynamicObject recBill) {
        String sourceBillType = recBill.getString("sourcebilltype");
        if ("cas_claimcenterbill".equals(sourceBillType)) {
            long sourceBillId = recBill.getLong("sourcebillid");
            QFilter claimCenterQFilter = new QFilter("id", "=", (Object)sourceBillId);
            DynamicObjectCollection claimCenterBills = QueryServiceHelper.query((String)"cas_claimannounce", (String)"datasource,sourceid", (QFilter[])new QFilter[]{claimCenterQFilter});
            if (claimCenterBills.size() > 0) {
                if (!"elerecticket".equals(((DynamicObject)claimCenterBills.get(0)).getString("datasource"))) {
                    return false;
                }
                Object[] eleRecTicketIds = claimCenterBills.stream().filter(o -> "elerecticket".equals(o.getString("datasource"))).map(o -> Long.parseLong(o.getString("sourceid"))).toArray();
                QFilter eleRecTicketQFilter = new QFilter("id", "in", (Object)eleRecTicketIds);
                DynamicObjectCollection eleRecTicketBills = QueryServiceHelper.query((String)"cdm_electronic_sign_deal", (String)"id,sourceid", (QFilter[])new QFilter[]{eleRecTicketQFilter});
                return !eleRecTicketBills.stream().allMatch(o -> o.getLong("sourceid") > 0L);
            }
            return false;
        }
        return false;
    }
}

