/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recclaim;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;

public class RecClaimCancelAccountValidator
extends AbstractValidator {
    public void validate() {
        block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject[] recBills;
            DynamicObject info = dataEntity.getDataEntity();
            String claimstatus = info.getString("claimstatus");
            if (!ClaimStatusEnum.SURE.getValue().equals(claimstatus)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u8ba4\u9886\u72b6\u6001\u4e3a\u201c\u5df2\u786e\u8ba4\u201d\u7684\u8ba4\u9886\u901a\u77e5\u5355\u624d\u80fd\u8fdb\u884c\u201c\u53d6\u6d88\u786e\u8ba4\u8ba4\u9886\u7ed3\u679c\u201d\u64cd\u4f5c\u3002", (String)"RecClaimCancelAccountValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            }
            BigDecimal payAmount = info.getBigDecimal("payamount");
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject[] entry : entrys) {
                String claimType = entry.getString("e_claimtype");
                if (ClaimTypeEnum.CLAIM.getValue().equals(claimType) || payAmount.compareTo(BigDecimal.ZERO) != 0) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u5355\u5df2\u53d1\u751f%s\uff0c\u4e0d\u80fd\u53d6\u6d88\u786e\u8ba4\u8ba4\u9886\u7ed3\u679c\u3002", (String)"RecClaimCancelAccountValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), ClaimTypeEnum.getName((String)claimType)), ErrorLevel.Error);
                break;
            }
            if ((recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,billstatus,hotaccount", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", info.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.CHARGEBANK.getValue())})) != null && recBills.length > 0) {
                for (DynamicObject recBill : recBills) {
                    if (info.getBoolean("isunclaim") && recBill.getBoolean("hotaccount") || BillStatusEnum.SAVE.getValue().equals(recBill.getString("billstatus"))) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u201c\u53d6\u6d88\u786e\u8ba4\u8ba4\u9886\u7ed3\u679c\u201d\u3002", (String)"RecClaimCancelAccountValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    break;
                }
            }
            DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus,sourcebilltype,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", info.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.CHARGEBANK.getValue())});
            if (recBills == null || payBills.length <= 0) continue;
            for (DynamicObject payBill : payBills) {
                if (BillStatusEnum.SAVE.getValue().equals(payBill.getString("billstatus"))) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u786e\u8ba4\u8ba4\u9886\u7ed3\u679c\u3002", (String)"RecClaimCancelAccountValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue block0;
            }
        }
    }
}

