/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.receivingbilltype;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ReceivingBillTypeValidator
extends AbstractValidator {
    public void validate() {
        List ids = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getLong("id")).collect(Collectors.toList());
        QFilter qFilterId = new QFilter("id", "in", ids);
        DynamicObject[] pbTypes = BusinessDataServiceHelper.load((String)"cas_receivingbilltype", (String)"number,name,ispartreceivable,biztype", (QFilter[])new QFilter[]{qFilterId});
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject rbType = dataEntity.getDataEntity();
            Boolean isPartReceivable = rbType.getBoolean("ispartreceivable");
            String bizType = rbType.getString("biztype");
            Boolean preData = rbType.getBoolean("predata");
            Long recTypeId = rbType.getLong("id");
            String number = rbType.getString("number");
            String name = ((OrmLocaleValue)rbType.get("name")).get((Object)"zh_CN");
            Boolean isNotModify = true;
            Set idsInDb = Arrays.stream(pbTypes).map(o -> o.getLong("id")).collect(Collectors.toSet());
            if (!idsInDb.contains(recTypeId)) continue;
            DynamicObject dbObj = Arrays.stream(pbTypes).filter(o -> Objects.equals(o.getLong("id"), recTypeId)).findFirst().orElse(null);
            if (idsInDb != null && idsInDb.size() != 0) {
                isNotModify = dbObj.getString("number").equals(number) && dbObj.getString("name").equals(name) && Boolean.valueOf(dbObj.getBoolean("ispartreceivable")).equals(isPartReceivable) && dbObj.getString("biztype").equals(bizType);
            }
            if (this.getOption().containsVariable("importtype") && this.getOption().getVariableValue("importtype") != null) {
                if (!isNotModify.booleanValue() && Boolean.TRUE.equals(preData)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u8bbe\u6570\u636e\u4e3a\u662f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7f16\u7801\u3001\u540d\u79f0\u3001\u53c2\u4e0e\u5e94\u6536\u7ed3\u7b97\u3001\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"ReceivingBillTypeSaveOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!Boolean.FALSE.equals(preData)) continue;
                this.quoteValidate(recTypeId, isNotModify, dataEntity);
                continue;
            }
            this.quoteValidate(recTypeId, isNotModify, dataEntity);
        }
    }

    private void quoteValidate(Long id, Boolean isNotModify, ExtendedDataEntity dataEntity) {
        QFilter qFilterType = new QFilter("receivingtype", "=", (Object)id);
        boolean existRecBill = QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])new QFilter[]{qFilterType});
        if (!isNotModify.booleanValue() && existRecBill) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7f16\u7801\u3001\u540d\u79f0\u3001\u53c2\u4e0e\u5e94\u6536\u7ed3\u7b97\u3001\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"ReceivingBillTypeSaveOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

