/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recinit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class RecInitAntiInitValidator
extends AbstractValidator {
    public void validate() {
        Set orgIdList = Arrays.stream(this.dataEntities).filter(c -> c.getDataEntity().getDynamicObject("org") != null).map(c -> c.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(orgIdList)) {
            return;
        }
        Map orgInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIdList);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject recInit = dataEntity.getDataEntity();
            DynamicObject org = recInit.getDynamicObject("org");
            boolean isfinishinit = recInit.getBoolean("isfinishinit");
            if (!isfinishinit) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u7684\u6570\u636e\u8fdb\u884c\u53cd\u521d\u59cb\u5316\u5904\u7406\u3002", (String)"RecInitAntiInitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            DynamicObject orgInit = (DynamicObject)orgInitMap.get(org.getString("id"));
            DynamicObject currentPeriod = orgInit.getDynamicObject("currentperiod");
            if (orgInit == null || currentPeriod == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u7ed3\u675f\u51fa\u7eb3\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u53cd\u521d\u59cb\u5316\u3002", (String)"RecInitAntiInitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            DynamicObject recInitPeriod = recInit.getDynamicObject("initperiod");
            if (currentPeriod != null && !currentPeriod.getPkValue().equals(recInitPeriod.getPkValue())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\u5df2\u53d8\u5316\uff0c\u8bf7\u786e\u8ba4\u5bf9\u8d26\u521d\u59cb\u5316\u671f\u95f4\u662f\u5426\u6b63\u786e\uff0c\u5982\u9700\u7ee7\u7eed\u8bf7\u5148\u53cd\u7ed3\u8d26\u4f7f\u5f97\u5f53\u524d\u671f\u95f4\u4e0e\u5bf9\u8d26\u521d\u59cb\u5316\u671f\u95f4\u76f8\u540c\u3002", (String)"RecInitAntiInitValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            QFilter oFilter = new QFilter("org", "=", (Object)org.getLong("id"));
            QFilter pFilter = new QFilter("period", "=", (Object)0L);
            QFilter recperiodFilter = new QFilter("recinitperiod", "=", recInitPeriod.getPkValue());
            QFilter cFilter = new QFilter("ischeck", "=", (Object)"1");
            boolean existsBS = QueryServiceHelper.exists((String)"cas_bankstatement", (QFilter[])new QFilter[]{oFilter, pFilter, recperiodFilter, cFilter});
            boolean existsBJ = QueryServiceHelper.exists((String)"cas_bankjournal", (QFilter[])new QFilter[]{oFilter, pFilter, recperiodFilter, cFilter});
            if (existsBS || existsBJ) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5f55\u5165\u7684\u672a\u8fbe\u8d26\u5df2\u88ab\u52fe\u5bf9\uff0c\u4e0d\u5141\u8bb8\u53cd\u521d\u59cb\u5316\u3002", (String)"RecInitAntiInitValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            Date endDate = recInitPeriod.getDate("enddate");
            Date lessDate = DateUtils.getDataFormat((Date)endDate, (boolean)false);
            DynamicObjectCollection largerDateBalances = QueryServiceHelper.query((String)"cas_balanceadjust", (String)"org,bizdate,bankaccount.number,currency.name", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("bizdate", ">", (Object)lessDate)});
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)largerDateBalances)) continue;
            String dateStr = DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd");
            ArrayList<String> errorList = new ArrayList<String>(largerDateBalances.size());
            ArrayList<String> exsitBalanceList = new ArrayList<String>(largerDateBalances.size());
            for (DynamicObject balance : largerDateBalances) {
                String accountNumber = balance.getString("bankaccount.number");
                String currencyName = balance.getString("currency.name");
                String key = accountNumber + currencyName;
                if (exsitBalanceList.contains(key)) continue;
                exsitBalanceList.add(key);
                String error = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u53cd\u521d\u59cb\u5316\u5931\u8d25\u3002\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728%3$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\uff0c\u5982\u9700\u7ee7\u7eed\uff0c\u8bf7\u5c06%4$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\u5220\u9664\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RecInitAntiInitValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), accountNumber, currencyName, dateStr, dateStr);
                errorList.add(error);
            }
            if (errorList.isEmpty()) continue;
            String msg = String.join((CharSequence)"\r\n", errorList);
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

