/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.refund;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.Pair;
import kd.fi.cas.business.writeback.WriteBackConfigInvoker;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.ar.ArWriteBackHelper;
import kd.fi.cas.business.writeback.ar.bean.Result;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.refund.RefundWriteBackConsumer;
import kd.fi.cas.consts.RefundConstants;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;

public class RevBillRefundRenoteValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(RevBillRefundRenoteValidator.class);
    private final DynamicObject[] bills;
    private final DynamicObject revBill;
    private Map<Long, DynamicObject> entrustSourceBills;

    public RevBillRefundRenoteValidator(DynamicObject[] bills, DynamicObject revBill, Map<Long, DynamicObject> entrustSourceBills) {
        this.bills = bills;
        this.revBill = revBill;
        this.entrustSourceBills = entrustSourceBills;
    }

    public void validate() {
        DynamicObject refundObj = this.dataEntities[0].getDataEntity();
        DynamicObject revInfo = (DynamicObject)refundObj.getDynamicObjectCollection("revlist").get(0);
        long revid = revInfo.getLong("revid");
        String releBillType = refundObj.getString("relebilltype");
        boolean releWithInfo = refundObj.getBoolean("relewithinfo");
        DynamicObjectCollection releBillList = RefundHelper.filterNotZeroRelaList((List)refundObj.getDynamicObjectCollection("relebilllist"));
        String operateKey = this.getOption().getVariableValue("operateKey");
        DynamicObjectCollection revEntryList = this.revBill.getDynamicObjectCollection("entry");
        BigDecimal settlementAmt = BigDecimal.ZERO;
        BigDecimal notSettlementAmt = BigDecimal.ZERO;
        BigDecimal refundSettlementAmt = BigDecimal.ZERO;
        BigDecimal refundNotSettlementAmt = BigDecimal.ZERO;
        for (DynamicObject revEntry : revEntryList) {
            BigDecimal bigDecimal = revEntry.getBigDecimal("e_receivableamt");
            if (revEntry.getBoolean("e_receivingtype.ispartreceivable")) {
                settlementAmt = settlementAmt.add(bigDecimal);
                continue;
            }
            notSettlementAmt = notSettlementAmt.add(bigDecimal);
        }
        boolean payBillIsDiffer = false;
        if ("cas_paybill".equals(releBillType)) {
            List needLockIds = Arrays.stream(this.bills).map(b -> String.valueOf(b.getPkValue())).collect(Collectors.toList());
            needLockIds.add(String.valueOf(revid));
            List list = TxCheckUtil.getLocked(needLockIds);
            if (CollectionUtils.containsAny((Collection)list, needLockIds)) {
                String error = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentCancelPayValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                throw new KDBizException(error);
            }
            payBillIsDiffer = this.bills[0].getBoolean("isdiffcur");
            for (DynamicObject payBill : this.bills) {
                boolean isDiffer = payBill.getBoolean("isdiffcur");
                if (isDiffer != payBillIsDiffer) {
                    String msg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5f02\u5e01\u79cd\u4ed8\u6b3e\u5355\u4e0e\u975e\u5f02\u5e01\u79cd\u4ed8\u6b3e\u5355\u540c\u65f6\u5173\u8054\u540c\u4e00\u7b14\u6536\u6b3e\u8fdb\u884c\u9000\u7968\u6216\u9000\u6b3e\u3002", (String)"RevBillRefundRenoteValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    throw new KDBizException(msg);
                }
                DynamicObjectCollection entryList = payBill.getDynamicObjectCollection("entry");
                BigDecimal payAmtSum = entryList.stream().map(o -> o.getBigDecimal("e_payableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal currentRefundAmt = releBillList.stream().filter(r -> r.getLong("id") == ((Long)payBill.getPkValue()).longValue()).map(r -> r.getBigDecimal("currentrefundamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (isDiffer && currentRefundAmt.compareTo(payBill.getBigDecimal("dpamt")) != 0) {
                    String msg = "refund".equals(operateKey) ? ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff0c\u5f02\u5e01\u79cd\u4ed8\u6b3e\u53ea\u652f\u6301\u5168\u989d\u9000\u6b3e\u3002\u5355\u636e\u7f16\u53f7\uff1a%1$s\u4e3a\u5f02\u5e01\u79cd\u4ed8\u6b3e\uff0c\u672c\u6b21\u9000\u91d1\u989d\u5408\u8ba1\u4e0e\u5b9e\u9645\u4ed8\u6b3e\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u65e0\u6cd5\u9000\u6b3e\u3002", (String)"RevBillRefundRenoteValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff0c\u5f02\u5e01\u79cd\u4ed8\u6b3e\u53ea\u652f\u6301\u5168\u989d\u9000\u7968\u3002\u5355\u636e\u7f16\u53f7\uff1a%1$s\u4e3a\u5f02\u5e01\u79cd\u4ed8\u6b3e\uff0c\u672c\u6b21\u9000\u91d1\u989d\u5408\u8ba1\u4e0e\u5b9e\u9645\u4ed8\u6b3e\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u65e0\u6cd5\u9000\u7968\u3002", (String)"RevBillRefundRenoteValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    throw new KDBizException(String.format(msg, payBill.getString("billno")));
                }
                if (RefundConstants.TRADE_BILL_TYPE.contains(payBill.getString("sourcebilltype")) && payAmtSum.compareTo(currentRefundAmt) != 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5b58\u5728\u4e0a\u6e38:%s\u4e0d\u5141\u8bb8\u64cd\u4f5c\u90e8\u5206\u9000\u6b3e\u9000\u7968\u3002", (String)"ReceivingBillRefundValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), payBill.getString("sourcebillnumber")));
                }
                if ("cfm_feebill".equals(payBill.getString("sourcebilltype"))) {
                    long feeBillId = payBill.getLong("sourcebillid");
                    DynamicObject feeBill = QueryServiceHelper.queryOne((String)"cfm_feebill", (String)"id,issettle", (QFilter[])new QFilter("id", "=", (Object)feeBillId).toArray());
                    if (payAmtSum.compareTo(currentRefundAmt) != 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u5355: \u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u6536\u6b3e\u91d1\u989d\u4e0d\u76f8\u7b49\u3002", (String)"ReceivingBillCancelRefundOp_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                    boolean issettle = feeBill.getBoolean("issettle");
                    if (!issettle) {
                        String msg = ResManager.loadKDString((String)"%s: \u4e1a\u52a1\u5355\u636e\u5173\u8054\u7684\u8d39\u7528\u660e\u7ec6\u5355\u672a\u7ed3\u7b97\u4ed8\u6b3e\u3002", (String)"ReceivingBillCancelRefundOp_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        throw new KDBizException(String.format(msg, payBill.getString("billno")));
                    }
                }
                Pair refundEntryAndAmt = RefundHelper.getRefundEntryAndAmt((DynamicObject)payBill, (List)releBillList, (boolean)releWithInfo);
                Map refundAmtMap = (Map)refundEntryAndAmt.getValue();
                for (DynamicObject refundEntry : (List)refundEntryAndAmt.getKey()) {
                    BigDecimal refundAmt = refundAmtMap.getOrDefault((Long)refundEntry.getPkValue(), BigDecimal.ZERO);
                    if (refundEntry.getBoolean("e_paymenttype.ispartpayment")) {
                        refundSettlementAmt = refundSettlementAmt.add(refundAmt);
                        continue;
                    }
                    refundNotSettlementAmt = refundNotSettlementAmt.add(refundAmt);
                }
            }
        } else {
            Map<Long, BigDecimal> refundAmtMap = releBillList.stream().filter(r -> BigDecimal.ZERO.compareTo(r.getBigDecimal("currentrefundamt")) != 0).collect(Collectors.toMap(r -> r.getLong("entryid"), r -> r.getBigDecimal("currentrefundamt")));
            for (DynamicObject agentBill : this.bills) {
                if (agentBill.getBoolean("isdiffcur")) {
                    String msg = ResManager.loadKDString((String)"%s: \u6682\u4e0d\u652f\u6301\u5f02\u5e01\u79cd\u4ed8\u6b3e\u4e1a\u52a1\u9000\u6b3e\u9000\u7968\uff0c\u656c\u8bf7\u671f\u5f85\u540e\u7eed\u4f18\u5316\u3002", (String)"ReceivingBillCancelRefundOp_3", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    throw new KDBizException(String.format(msg, agentBill.getString("billno")));
                }
                DynamicObjectCollection entryList = agentBill.getDynamicObjectCollection("entry");
                List refundEntryList = entryList.stream().filter(e -> refundAmtMap.containsKey((Long)e.getPkValue())).collect(Collectors.toList());
                boolean isPartPayment = agentBill.getBoolean("paymenttype.ispartpayment");
                for (DynamicObject agentEntry : refundEntryList) {
                    String encryptAmtStr = agentEntry.getString("e_encryptamount");
                    BigDecimal amt = AgentPayBillHelper.decodeAmount((String)encryptAmtStr);
                    BigDecimal refundAmt = refundAmtMap.getOrDefault((Long)agentEntry.getPkValue(), BigDecimal.ZERO);
                    if ("renote".equals(operateKey) && amt.compareTo(refundAmt) != 0) {
                        String msg = ResManager.loadKDString((String)"\u672c\u6b21\u9000\u91d1\u989d\u4e0e\u4ee3\u53d1\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u9000\u7968\u573a\u666f\u662f\u5168\u989d\u539f\u8def\u8fd4\u56de\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539", (String)"ReceivingBillCancelRefundOp_6", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        throw new KDBizException(msg);
                    }
                    if (isPartPayment) {
                        refundSettlementAmt = refundSettlementAmt.add(refundAmt);
                        continue;
                    }
                    refundNotSettlementAmt = refundNotSettlementAmt.add(refundAmt);
                }
            }
        }
        if (!(settlementAmt.compareTo(refundSettlementAmt) == 0 && notSettlementAmt.compareTo(refundNotSettlementAmt) == 0 || payBillIsDiffer)) {
            String msg = ResManager.loadKDString((String)"\u672c\u6b21\u9000\u91d1\u989d\u4e0e\u6536\u6b3e\u5355\u53ef\u9000\u91d1\u989d\uff0c\u53c2\u4e0e\u7ed3\u7b97\u91d1\u989d\u4e0e\u4e0d\u53c2\u4e0e\u7ed3\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"ReceivingBillCancelRefundOp_7", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        List<DynamicObject> finalReleList = this.getFinalReleList(releBillList, releBillType, releWithInfo);
        WriteBackOperateEnum writeBackOperateEnum = "refund".equals(operateKey) ? WriteBackOperateEnum.REFUNDVALIDATE : WriteBackOperateEnum.RENOTEVALIDATE;
        List writeBackBills = RefundHelper.replaceEntrustBills((DynamicObject[])this.bills, this.entrustSourceBills);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("revId", revid);
        param.put("releWithInfo", releWithInfo);
        param.put("releBillList", finalReleList);
        param.put("releBillType", releBillType);
        Map<String, List<DynamicObject>> billsBySource = writeBackBills.stream().collect(Collectors.groupingBy(bill -> bill.getString("sourcebilltype")));
        ArrayList<RefundRenoteOrCancelParam> refundParams = new ArrayList<RefundRenoteOrCancelParam>(billsBySource.size());
        for (Map.Entry<String, List<DynamicObject>> billsEntry : billsBySource.entrySet()) {
            Object resultObj;
            String sourceBillType = billsEntry.getKey();
            List<DynamicObject> payOrAgentBills = billsEntry.getValue();
            HashMap<String, DynamicObject[]> subParam = new HashMap<String, DynamicObject[]>(param);
            subParam.put("bills", payOrAgentBills.toArray(new DynamicObject[0]));
            try {
                RefundWriteBackConsumer writeBackConsumer = new RefundWriteBackConsumer();
                RefundRenoteOrCancelParam invokeParams = writeBackConsumer.initInvokeParams(subParam, releBillType, sourceBillType, writeBackOperateEnum);
                refundParams.add(invokeParams);
                if ("cas_paybill".equals(releBillType) && ArWriteBackHelper.isArApSourceType((String)sourceBillType)) continue;
                resultObj = WriteBackTaskHelper.batchAddWriteBackTask((DynamicObject[])payOrAgentBills.toArray(new DynamicObject[0]), (String)sourceBillType, (WriteBackOperateEnum)writeBackOperateEnum, (WriteBackConfigInvoker)writeBackConsumer, subParam);
            }
            catch (Exception e2) {
                LOGGER.error("rev refund renote validator error", (Throwable)e2);
                throw new KDBizException(String.valueOf(e2.getMessage()));
            }
            Result result = (Result)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)resultObj), Result.class);
            if (result == null || "0".equals(result.getCode())) continue;
            throw new KDBizException(result.getErrorInfo());
        }
        if ("cas_paybill".equals(releBillType)) {
            if (this.entrustSourceBills.isEmpty()) {
                ArWriteBackHelper.arApValidate((Long)revid, (WriteBackOperateEnum)writeBackOperateEnum, refundParams, (String)"RefundAndRenoteValidateService");
            } else {
                RefundRenoteOrCancelParam invokeParams = ArWriteBackHelper.buildApRefundParam((DynamicObject[])this.bills, this.entrustSourceBills, param, (WriteBackOperateEnum)writeBackOperateEnum);
                ArWriteBackHelper.arApValidate((Long)revid, (WriteBackOperateEnum)writeBackOperateEnum, Collections.singletonList(invokeParams), (String)"RefundAndRenoteValidateService");
            }
        }
    }

    private List<DynamicObject> getFinalReleList(DynamicObjectCollection releBillList, String releBillType, boolean releWithInfo) {
        ArrayList<DynamicObject> finalReleList = new ArrayList<DynamicObject>((Collection<DynamicObject>)releBillList);
        Map<Long, List<DynamicObject>> releInfoByBillId = releBillList.stream().collect(Collectors.groupingBy(r -> r.getLong("id")));
        for (DynamicObject bill : this.bills) {
            Long billId = (Long)bill.getPkValue();
            DynamicObject sourceBill = this.entrustSourceBills.get(billId);
            if (sourceBill == null) continue;
            List<DynamicObject> reles = releInfoByBillId.get(billId);
            if ("cas_paybill".equals(releBillType)) {
                Pair refundEntryAndAmt = RefundHelper.getRefundEntryAndAmt((DynamicObject)bill, reles, (boolean)releWithInfo);
                List copyReles = RefundHelper.copyReles((Long)((Long)sourceBill.getPkValue()), (List)((List)refundEntryAndAmt.getKey()), reles, (boolean)releWithInfo, (String)"cas_paybill");
                finalReleList.addAll(copyReles);
                continue;
            }
            Set refundEntryIds = reles.stream().filter(r -> BigDecimal.ZERO.compareTo(r.getBigDecimal("currentrefundamt")) != 0).map(r -> r.getLong("entryid")).collect(Collectors.toSet());
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("entry");
            List refundEntryList = entryList.stream().filter(entry -> refundEntryIds.contains(entry.getLong("id"))).collect(Collectors.toList());
            List copyReles = RefundHelper.copyReles((Long)((Long)sourceBill.getPkValue()), refundEntryList, reles, (boolean)releWithInfo, (String)"cas_agentpaybill");
            finalReleList.addAll(copyReles);
        }
        return finalReleList;
    }
}

