/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.compare.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.fi.cas.compare.CompareEngine;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.compare.strategy.MultiRuleOneToOneCompareStrategy;
import kd.fi.cas.compare.test.ITestDataProvider;
import kd.fi.cas.compare.test.data.MultiStrategyDataProvider;

public class Test {
    private static List<ITestDataProvider> testDataList = new ArrayList<ITestDataProvider>();

    public static void main(String[] args) {
        for (ITestDataProvider provider : testDataList) {
            String name = provider.getName();
            System.out.println("--------[" + name + "]--------\n\n");
            long time = System.nanoTime();
            List<Map<String, Object>> srcList = provider.getSrcDataList();
            List<Map<String, Object>> tarList = provider.getTarDataList();
            MultiRuleOneToOneCompareStrategy strategy = new MultiRuleOneToOneCompareStrategy(provider.getRule());
            CompareEngine engine = new CompareEngine(srcList, tarList);
            List<CompareResult> resultList = engine.compare(strategy);
            System.out.println("Comparator\t\tsize: " + String.format("%10d", resultList.stream().map(CompareResult::getSrcIdSet).count()) + "\t\t time: " + (System.nanoTime() - time));
            time = System.nanoTime();
            List<CompareResult> result = provider.runBruteForce();
            System.out.println("Brute Force\t\tsize: " + String.format("%10d", result.stream().map(CompareResult::getSrcIdSet).count()) + "\t\t time: " + (System.nanoTime() - time));
            System.out.println("\n\n--------[" + name + "]--------\n\n");
        }
    }

    static {
        testDataList.add(new MultiStrategyDataProvider());
    }
}

