/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.compare.test.data;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.cas.compare.data.CompareRule;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.compare.test.ITestDataProvider;
import kd.fi.cas.compare.test.TestUtil;

public class ComprehensiveDataProvider
implements ITestDataProvider {
    private static final int TAR_CNT = 10000;
    private static final int SRC_CNT = 25000;
    private static final int SRC_LEN = 40;
    private static final int TAR_LEN = 6;
    private List<Map<String, Object>> srcDataList;

    @Override
    public List<Map<String, Object>> getSrcDataList() {
        this.srcDataList = this.getDataList(25000);
        return this.srcDataList;
    }

    @Override
    public List<Map<String, Object>> getTarDataList() {
        ArrayList<Map<String, Object>> tarList = new ArrayList<Map<String, Object>>(this.srcDataList.size());
        SecureRandom random = new SecureRandom();
        for (Map<String, Object> src : this.srcDataList) {
            String remark = TestUtil.getRandomLetter(random, 40);
            src.put("remark", remark);
            HashMap<String, Object> mapClone = new HashMap<String, Object>(src);
            int startIdx = random.nextInt(34);
            mapClone.put("remark", remark.substring(startIdx, startIdx + 6));
            tarList.add(mapClone);
        }
        return tarList;
    }

    private List<Map<String, Object>> getDataList(int cnt) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(cnt);
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < cnt; ++i) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", TestUtil.getRandomId(random, 18));
            data.put("name", "name" + i / 400);
            data.put("company", "company" + i / 500);
            data.put("count", "count" + i / 600);
            data.put("amount", "amount" + i / 700);
            dataList.add(data);
        }
        return dataList;
    }

    @Override
    public List<List<CompareRule>> getRule() {
        return Collections.singletonList(Arrays.asList(new CompareRule(CompareRule.Symbol.EQUALS, "name"), new CompareRule(CompareRule.Symbol.EQUALS, "company"), new CompareRule(CompareRule.Symbol.EQUALS, "count"), new CompareRule(CompareRule.Symbol.EQUALS, "amount"), new CompareRule(CompareRule.Symbol.STR_MATCH, "remark")));
    }

    @Override
    public String getName() {
        return "ComprehensiveTest";
    }

    @Override
    public List<CompareResult> runBruteForce() {
        return new ArrayList<CompareResult>();
    }
}

