/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IPageCache;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.pojo.book.BookCheckResult;
import kd.fi.cas.pojo.book.BookInfo;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class AccountBankHelper {
    private static final Log log = LogFactory.getLog(AccountBankHelper.class);
    private static String[] temp_new = new String[]{"normal", "closing", "changing"};
    public static final String FROM_ACCOUNT_TRADE = "fromAccountTrade";
    public static final String FROM_ACCOUNT_ASSIGN_CANCEL = "fromAccountAssignCancel";

    public static DynamicObject getAccountBankById(long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bd_accountbanks");
    }

    public static List<Long> getUseableAccountPks(Collection<Long> orgIds) {
        QFilter[] filters = AccountBankHelper.getUsableAccountFilter(orgIds);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])filters);
        ArrayList<Long> accountPks = new ArrayList<Long>(accounts.length);
        for (DynamicObject account : accounts) {
            accountPks.add((Long)account.getPkValue());
        }
        return accountPks;
    }

    public static boolean canUseAccount(long orgId, long acctBankId) {
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company,acctstatus", (QFilter[])new QFilter("id", "=", (Object)acctBankId).toArray());
        return AccountBankHelper.validateAccountAuthByOrg(orgId, acctBankId) && ("normal".equals(account.getString("acctstatus")) || "freeze".equals(account.getString("acctstatus")) || "closing".equals(account.getString("acctstatus")));
    }

    public static String checkAccount(DynamicObject org, DynamicObject accountBank) {
        long acctBankId;
        long orgId = org.getLong("id");
        if (!AccountBankHelper.validateAccountAuthByOrg(orgId, acctBankId = accountBank.getLong("id"))) {
            return ResManager.loadKDString((String)"\u7ec4\u7ec7\u6ca1\u6709\u8d26\u6237\u7684\u4f7f\u7528\u6743\u9650\u3002", (String)"AccountBankHelper_9", (String)"fi-cas-common", (Object[])new Object[0]);
        }
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company,acctstatus", (QFilter[])new QFilter("id", "=", (Object)acctBankId).toArray());
        if ("freeze".equals(account.getString("acctstatus")) || "closed".equals(account.getString("acctstatus"))) {
            return ResManager.loadKDString((String)"\u8d26\u6237\u5df2\u9500\u6237\u6216\u51bb\u7ed3\u72b6\u6001\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u4ed8\u6b3e\u3002", (String)"AccountBankHelper_10", (String)"fi-cas-common", (Object[])new Object[0]);
        }
        return null;
    }

    public static String batchCanUseAccount(Map<Long, Set<Long>> checkMap) {
        for (Map.Entry<Long, Set<Long>> entry : checkMap.entrySet()) {
            Long orgId = entry.getKey();
            Set<Long> acctBankIdList = entry.getValue();
            QFilter qFilter = new QFilter("id", "in", acctBankIdList);
            qFilter.and(AccountBankHelper.getAccountBankFilterByOrg(orgId));
            DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,acctstatus", (QFilter[])new QFilter[]{qFilter});
            boolean flag = accountBanks.length == acctBankIdList.size() ? Boolean.TRUE : Boolean.FALSE;
            if (flag) {
                for (DynamicObject account : accountBanks) {
                    String acctStatus = account.getString("acctstatus");
                    if ("closed".equals(acctStatus)) {
                        return ResManager.loadKDString((String)"\u5df2\u9500\u6237\u72b6\u6001\u7684\u4ed8\u6b3e\u8d26\u6237\u4e0d\u80fd\u63d0\u4ea4\u4ed8\u6b3e\u3002", (String)"AccountBankHelper_11", (String)"fi-cas-common", (Object[])new Object[0]);
                    }
                    if (!"freeze".equals(acctStatus)) continue;
                    return ResManager.loadKDString((String)"\u51bb\u7ed3\u72b6\u6001\u7684\u4ed8\u6b3e\u8d26\u6237\u4e0d\u80fd\u63d0\u4ea4\u4ed8\u6b3e\u3002", (String)"AccountBankHelper_12", (String)"fi-cas-common", (Object[])new Object[0]);
                }
                continue;
            }
            return ResManager.loadKDString((String)"\u7ec4\u7ec7\u6ca1\u6709\u8d26\u6237\u7684\u4f7f\u7528\u6743\u9650\u3002", (String)"AccountBankHelper_9", (String)"fi-cas-common", (Object[])new Object[0]);
        }
        return null;
    }

    public static Map<Long, Boolean> batchCanUseAccountMap(Map<Long, Set<Long>> checkMap) {
        HashMap<Long, Boolean> checkResult = new HashMap<Long, Boolean>();
        for (Map.Entry<Long, Set<Long>> entry : checkMap.entrySet()) {
            Long orgId = entry.getKey();
            Set<Long> acctBankIdList = entry.getValue();
            QFilter qFilter = new QFilter("id", "in", acctBankIdList);
            qFilter.and(AccountBankHelper.getAccountBankFilterByOrg(orgId));
            DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,acctstatus", (QFilter[])new QFilter[]{qFilter});
            boolean flag = accountBanks.length == acctBankIdList.size() ? Boolean.TRUE : Boolean.FALSE;
            if (flag) {
                Boolean check = Boolean.TRUE;
                for (DynamicObject account : accountBanks) {
                    if ("normal".equals(account.getString("acctstatus")) || "closing".equals(account.getString("acctstatus")) || "freeze".equals(account.getString("acctstatus")) || "changing".equals(account.getString("acctstatus"))) continue;
                    check = Boolean.FALSE;
                    break;
                }
                checkResult.put(orgId, check);
                continue;
            }
            checkResult.put(orgId, Boolean.FALSE);
        }
        return checkResult;
    }

    public static Map<DynamicObject, Boolean> batchCanUseAccountMap(List<DynamicObject> dynamicObjects) {
        HashMap<DynamicObject, Boolean> checkResult = new HashMap<DynamicObject, Boolean>(2);
        Map objToAccId = dynamicObjects.stream().filter(o -> o.getDynamicObject("payeracctbank") != null).collect(Collectors.toMap(Function.identity(), o -> o.getDynamicObject("payeracctbank").getLong("id")));
        for (Map.Entry entry : objToAccId.entrySet()) {
            DynamicObject obj = (DynamicObject)entry.getKey();
            Long orgId = ((DynamicObject)entry.getKey()).getDynamicObject("org").getLong("id");
            Long acctBankId = entry.getValue();
            QFilter qFilter = new QFilter("id", "=", (Object)acctBankId);
            qFilter.and(AccountBankHelper.getAccountBankFilterByOrg(orgId));
            DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,acctstatus", (QFilter[])new QFilter[]{qFilter});
            boolean flag = accountBanks.length == 1 ? Boolean.TRUE : Boolean.FALSE;
            if (flag) {
                Boolean check = Boolean.TRUE;
                for (DynamicObject account : accountBanks) {
                    if ("normal".equals(account.getString("acctstatus")) || "closing".equals(account.getString("acctstatus")) || "freeze".equals(account.getString("acctstatus")) || "changing".equals(account.getString("acctstatus"))) continue;
                    check = Boolean.FALSE;
                    break;
                }
                checkResult.put(obj, check);
                continue;
            }
            checkResult.put(obj, Boolean.FALSE);
        }
        return checkResult;
    }

    public static boolean isEntrustCanUseAccount(long orgId, long acctBankId) {
        boolean accountStatus;
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company,acctstatus", (QFilter[])new QFilter("id", "=", (Object)acctBankId).toArray());
        boolean bl = accountStatus = !"closed".equals(account.getString("acctstatus"));
        if (accountStatus) {
            boolean canUse = AccountBankHelper.validateAccountAuthByOrg(orgId, acctBankId);
            if (!canUse) {
                QFilter fromOrgFilter = new QFilter("fromorg", "=", (Object)orgId);
                QFilter numberFilter = new QFilter("typerelation.number", "=", (Object)"accounting2capital");
                QFilter isPreSetFilter = new QFilter("typerelation.ispreset", "=", (Object)"1");
                QFilter[] qFilters = fromOrgFilter.and(numberFilter).and(isPreSetFilter).toArray();
                DynamicObject orgRelation = BusinessDataServiceHelper.loadSingle((String)"bos_org_orgrelation", (String)"toorg", (QFilter[])qFilters);
                if (Objects.nonNull(orgRelation)) {
                    DynamicObject toOrg = orgRelation.getDynamicObject("toorg");
                    return AccountBankHelper.validateAccountAuthByOrg((Long)toOrg.getPkValue(), acctBankId);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static Set<Long> getCurrencyPks(long acctBankId) {
        return AccountBankHelper.getCurrencyPks("bd_accountbanks", Collections.singletonList(acctBankId));
    }

    public static Set<Long> getCurrencyPks(List<Long> acctBankIds) {
        return AccountBankHelper.getCurrencyPks("bd_accountbanks", acctBankIds);
    }

    public static Set<Long> getCurrencyPksByOrg(List<Long> orgIdList) {
        HashSet<Long> currencyIdSet = new HashSet<Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AccountBankHelperQueryCurrency", (String)"bd_accountbanks", (String)"id,currency.fbasedataid.id,currency.fbasedataid.enable", (QFilter[])new QFilter[]{AccountBankHelper.getOrgFilter(orgIdList), new QFilter("currency.fbasedataid.enable", "=", (Object)Character.valueOf('1'))}, (String)"");){
            while (ds.hasNext()) {
                currencyIdSet.add(ds.next().getLong("currency.fbasedataid.id"));
            }
        }
        return currencyIdSet;
    }

    public static Map<Object, List<Long>> getBatchCurrencyPks(String acctEntityName, List<Long> acctIds) {
        if (null == acctIds || acctIds.size() == 0) {
            new HashMap();
        }
        DynamicObjectCollection queryAcctColl = QueryServiceHelper.query((String)acctEntityName, (String)"id,currency.fbasedataid.id,currency.fbasedataid.enable", (QFilter[])new QFilter[]{new QFilter("id", "in", acctIds), new QFilter("currency.fbasedataid.enable", "=", (Object)Character.valueOf('1'))}, null);
        Map<Object, List<Long>> acctIdCurrencyMap = queryAcctColl.stream().collect(Collectors.groupingBy(o -> o.get("id"), Collectors.mapping(o -> o.getLong("currency.fbasedataid.id"), Collectors.toList())));
        return acctIdCurrencyMap;
    }

    public static Set<Long> getCurrencyPks(String acctEntityName, List<Long> acctIds) {
        DynamicObjectCollection queryAcctColl = QueryServiceHelper.query((String)acctEntityName, (String)"id,currency.fbasedataid.id,currency.fbasedataid.enable", (QFilter[])new QFilter[]{new QFilter("id", "in", acctIds), new QFilter("currency.fbasedataid.enable", "=", (Object)Character.valueOf('1'))}, null);
        HashSet<Long> currencyIdSet = new HashSet<Long>(queryAcctColl.size());
        for (int i = 0; i < queryAcctColl.size(); ++i) {
            DynamicObject acctObj = (DynamicObject)queryAcctColl.get(i);
            currencyIdSet.add(acctObj.getLong("currency.fbasedataid.id"));
        }
        return currencyIdSet;
    }

    public static Set<Long> getBanksByOrg(List<Long> orgIdList) {
        DynamicObjectCollection queryAcctColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bank.id", (QFilter[])new QFilter[]{AccountBankHelper.getOrgFilter(orgIdList)}, null);
        HashSet<Long> bankIdSet = new HashSet<Long>(queryAcctColl.size());
        for (DynamicObject acctObj : queryAcctColl) {
            bankIdSet.add(acctObj.getLong("bank.id"));
        }
        return bankIdSet;
    }

    public static DynamicObject getDefaultPayAccount(Long orgId) {
        return AccountBankHelper.getDefaultAccount(orgId, "isdefaultpay");
    }

    public static DynamicObject getDefaultRecAccount(Long orgId) {
        return AccountBankHelper.getDefaultAccount(orgId, "isdefaultrec");
    }

    public static DynamicObject getDefaultAccount(Long orgId, String fieldName) {
        QFilter[] usableAccountFilter = new QFilter[]{AccountBankHelper.getCreateOrgFilter(orgId), AccountBankHelper.getUsableFilter(), new QFilter(fieldName, "=", (Object)"1")};
        DynamicObject account = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id", (QFilter[])usableAccountFilter);
        if (account != null) {
            account = BusinessDataServiceHelper.loadSingleFromCache((Object)account.getPkValue(), (String)"bd_accountbanks");
        }
        return account;
    }

    public static DynamicObject getAccountByNumber(String accountNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)accountNumber)};
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (QFilter[])filters);
        return account;
    }

    public static DynamicObject[] getAccountByNumbers(Set<String> accountNumbers) {
        QFilter[] filters = new QFilter[]{new QFilter("bankaccountnumber", "in", accountNumbers)};
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,name,bankaccountnumber,iselecpayment", (QFilter[])filters);
        return accounts;
    }

    public static List<Long> getUseCompanies(long accountId) {
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company", (QFilter[])new QFilter("id", "=", (Object)accountId).toArray());
        return Collections.singletonList(account.getLong("company"));
    }

    public static QFilter[] getUnclosedAccountFilter(long orgId) {
        return new QFilter[]{AccountBankHelper.getAccountBankFilterByOrg(orgId), new QFilter("acctstatus", "not in", (Object)BankAcctStatusEnum.CLOSED.getValue())};
    }

    public static QFilter[] getUsableAccountFilter(long orgId) {
        return new QFilter[]{AccountBankHelper.getAccountBankFilterByOrg(orgId), AccountBankHelper.getUsableFilter()};
    }

    public static QFilter[] getUsableAccountFilter_new(long orgId) {
        return new QFilter[]{AccountBankHelper.getAccountBankFilterByOrg(orgId), AccountBankHelper.getUsableFilter_new()};
    }

    public static QFilter[] getUsableAccountFilter(Collection<Long> orgIds) {
        return new QFilter[]{AccountBankHelper.getAccountBankFilterByOrg(orgIds), AccountBankHelper.getUsableFilter()};
    }

    public static QFilter getUsableFilter() {
        String[] temp = new String[]{"normal", "closing"};
        return new QFilter("acctstatus", "in", (Object)temp);
    }

    public static QFilter getUsableFilter_new() {
        return new QFilter("acctstatus", "in", (Object)temp_new);
    }

    public static QFilter[] getAccountFilter(Collection<Long> orgIds) {
        return new QFilter[]{AccountBankHelper.getOrgFilter(orgIds)};
    }

    public static QFilter[] getAccountFilterForOwn(Collection<Long> orgIds) {
        return new QFilter[]{AccountBankHelper.getCreateOrgFilter(orgIds)};
    }

    private static QFilter getOrgFilter(Collection<Long> orgIds) {
        return new QFilter("company", "in", orgIds);
    }

    private static QFilter getCreateOrgFilter(Collection<Long> orgIds) {
        return new QFilter("createorg", "in", orgIds);
    }

    private static QFilter getCreateOrgFilter(long orgId) {
        return new QFilter("createorg", "=", (Object)orgId);
    }

    public static String getBankNumberEncryptDisplay(String value) {
        if (value.length() < 9) {
            return String.join((CharSequence)"", Collections.nCopies(value.length(), "*"));
        }
        String preStr = value.substring(0, 4);
        String endStr = value.substring(value.length() - 4, value.length());
        return String.format("%s%s%s", preStr, String.join((CharSequence)"", Collections.nCopies(4, "*")), endStr);
    }

    public static boolean isClosed(long acctBankId) {
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"id,acctstatus", (QFilter[])new QFilter("id", "=", (Object)acctBankId).toArray());
        return "closed".equals(account.getString("acctstatus"));
    }

    public static Map<Long, Boolean> isBatchClosed(Set<Long> acctBankId) {
        DynamicObjectCollection accBankCol = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,acctstatus", (QFilter[])new QFilter("id", "in", acctBankId).toArray());
        HashMap<Long, Boolean> accBankMap = new HashMap<Long, Boolean>();
        for (DynamicObject accBank : accBankCol) {
            accBankMap.put(accBank.getLong("id"), "closed".equals(accBank.getString("acctstatus")));
        }
        return accBankMap;
    }

    public static DynamicObject getAccountByNumber(DynamicObject org, String accountNumber, Long payee, String payeeType) {
        if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeeType) || AsstActTypeEnum.CUSTOMER.getValue().equals(payeeType)) {
            DynamicObject internalOrg = BaseDataHelper.getInternalOrg(org, payee, payeeType);
            if (internalOrg != null) {
                payee = internalOrg.getLong("id");
            }
        } else if (!AsstActTypeEnum.COMPANY.getValue().equals(payeeType)) {
            return null;
        }
        if (payee == null || payee.intValue() == 0) {
            return null;
        }
        QFilter acctNumFilter = new QFilter("bankaccountnumber", "=", (Object)accountNumber);
        QFilter accountAuthAssignFilter = AccountBankHelper.getAccountBankFilterByOrg(payee);
        QFilter[] filters = new QFilter[]{acctNumFilter, accountAuthAssignFilter, AccountBankHelper.getUsableFilter()};
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (QFilter[])filters);
        return account;
    }

    public static QFilter getCurrencyFilter(DynamicObject currency) {
        if (currency != null) {
            return new QFilter("currency.fbasedataid.id", "=", currency.getPkValue());
        }
        return null;
    }

    public static boolean isAcctBankContainCurrency(String entityName, Object entityPk, DynamicObject currency) {
        if (CasHelper.isEmpty(entityName) || CasHelper.isEmpty(entityPk) || CasHelper.isEmpty(currency)) {
            return false;
        }
        QFilter idFilter = new QFilter("id", "=", entityPk);
        return QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{idFilter, AccountBankHelper.getCurrencyFilter(currency)});
    }

    public static String checkBalanceAdjust(DynamicObject journal, boolean isBook, boolean parameterBoolean, Map<String, DynamicObject> balanceResultMap) {
        if (StringUtils.equals((CharSequence)"cas_bankjournal", (CharSequence)journal.getDynamicObjectType().getName())) {
            Long org = DynamicObjectHelper.getPk(journal, "org");
            Long accountbank = DynamicObjectHelper.getPk(journal, "accountbank");
            Long currency = DynamicObjectHelper.getPk(journal, "currency");
            String keyStr = org + "_" + accountbank + "_" + currency;
            DynamicObject balanceAdust = null;
            Date bookDate = journal.getDate("bookdate");
            if (null != accountbank && null != currency) {
                balanceAdust = balanceResultMap.get(keyStr);
            } else if (bookDate != null && !parameterBoolean) {
                balanceAdust = BalanceAdjustHelper.getLastBalanceAdjust(org, accountbank, currency);
            } else {
                return "";
            }
            if (balanceAdust != null) {
                Date balanceAdjustBizDate = balanceAdust.getDate("bizdate");
                String billStatus = balanceAdust.getString("billstatus");
                if (bookDate != null && balanceAdjustBizDate != null && !parameterBoolean && DateUtils.formatString(bookDate, "yyyy-MM-dd").compareTo(DateUtils.formatString(balanceAdjustBizDate, "yyyy-MM-dd")) <= 0) {
                    String str = isBook ? ResManager.loadKDString((String)"\u767b\u8d26", (String)"AccountBankHelper_7", (String)"fi-cas-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d6\u6d88\u767b\u8d26", (String)"AccountBankHelper_6", (String)"fi-cas-common", (Object[])new Object[0]);
                    return String.format(ResManager.loadKDString((String)"\u767b\u8d26\u65e5\u671f[%1$s]\u5df2\u751f\u6210%2$s\u72b6\u6001\u7684\u4f59\u989d\u8c03\u8282\u8868[%3$s], \u4e0d\u5141\u8bb8%4$s", (String)"AccountBankHelper_3", (String)"fi-cas-common", (Object[])new Object[0]), DateUtils.formatString(bookDate, "yyyy-MM-dd"), BillStatusEnum.SUBMIT.getValue().equals(billStatus) ? ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"AccountBankHelper_4", (String)"fi-cas-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u5ba1\u6279", (String)"AccountBankHelper_5", (String)"fi-cas-common", (Object[])new Object[0]), balanceAdust.getString("billno"), str);
                }
            }
        }
        return "";
    }

    public static String checkBalanceAdjust(DynamicObject journal, boolean isBook) {
        Long currency;
        Long accountbank;
        Long org;
        DynamicObject balanceAdust;
        if (StringUtils.equals((CharSequence)"cas_bankjournal", (CharSequence)journal.getDynamicObjectType().getName()) && (balanceAdust = BalanceAdjustHelper.getLastBalanceAdjust(org = DynamicObjectHelper.getPk(journal, "org"), accountbank = DynamicObjectHelper.getPk(journal, "accountbank"), currency = DynamicObjectHelper.getPk(journal, "currency"))) != null) {
            Date balanceAdjustBizDate = balanceAdust.getDate("bizdate");
            String billStatus = balanceAdust.getString("billstatus");
            Date bookDate = journal.getDate("bookdate");
            boolean parameterBoolean = SystemParameterHelper.getParameterBoolean(org, "cs095");
            if (bookDate != null && balanceAdjustBizDate != null && !parameterBoolean && DateUtils.formatString(bookDate, "yyyy-MM-dd").compareTo(DateUtils.formatString(balanceAdjustBizDate, "yyyy-MM-dd")) <= 0) {
                String str = isBook ? ResManager.loadKDString((String)"\u767b\u8d26", (String)"AccountBankHelper_7", (String)"fi-cas-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d6\u6d88\u767b\u8d26", (String)"AccountBankHelper_6", (String)"fi-cas-common", (Object[])new Object[0]);
                return String.format(ResManager.loadKDString((String)"\u767b\u8d26\u65e5\u671f[%1$s]\u5df2\u751f\u6210%2$s\u72b6\u6001\u7684\u4f59\u989d\u8c03\u8282\u8868[%3$s], \u4e0d\u5141\u8bb8%4$s", (String)"AccountBankHelper_3", (String)"fi-cas-common", (Object[])new Object[0]), DateUtils.formatString(bookDate, "yyyy-MM-dd"), BillStatusEnum.SUBMIT.getValue().equals(billStatus) ? ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"AccountBankHelper_4", (String)"fi-cas-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u5ba1\u6279", (String)"AccountBankHelper_5", (String)"fi-cas-common", (Object[])new Object[0]), balanceAdust.getString("billno"), str);
            }
        }
        return "";
    }

    public static List<BookCheckResult> checkBalanceAdjust(List<BookInfo> bookInfos, boolean isBook) {
        if (bookInfos == null || bookInfos.size() == 0) {
            return new ArrayList<BookCheckResult>();
        }
        ArrayList<BookCheckResult> returns = new ArrayList<BookCheckResult>(bookInfos.size());
        ArrayList bankjournalsAll = new ArrayList();
        bookInfos.forEach(o -> bankjournalsAll.addAll(o.getBookObjs()));
        List bankjournals = bankjournalsAll.stream().filter(e -> StringUtils.equals((CharSequence)"cas_bankjournal", (CharSequence)e.getDynamicObjectType().getName())).collect(Collectors.toList());
        Set<Long> orgs = bankjournals.stream().map(o -> DynamicObjectHelper.getPk(o, "org")).collect(Collectors.toSet());
        Set<Long> accountbanks = bankjournals.stream().map(o -> DynamicObjectHelper.getPk(o, "accountbank")).collect(Collectors.toSet());
        Set<Long> currencys = bankjournals.stream().map(o -> DynamicObjectHelper.getPk(o, "currency")).collect(Collectors.toSet());
        Map<String, DynamicObject> balanceAdusts = BalanceAdjustHelper.getLastBalanceAdjust(orgs, accountbanks, currencys);
        if (balanceAdusts != null && balanceAdusts.size() > 0) {
            Iterator<BookInfo> iterator = bookInfos.iterator();
            while (iterator.hasNext()) {
                BookInfo bookInfo = iterator.next();
                List<DynamicObject> bookObjs = bookInfo.getBookObjs();
                for (DynamicObject bankjournal : bookObjs) {
                    String keyStr = BalanceAdjustHelper.getKeyStr(bankjournal.getLong("org"), bankjournal.getLong("accountbank"), bankjournal.getLong("currency"));
                    DynamicObject balanceAdust = balanceAdusts.get(keyStr);
                    if (balanceAdust == null) {
                        log.info(" balanceAdust is null.");
                        continue;
                    }
                    Long org = DynamicObjectHelper.getPk(bankjournal, "org");
                    Date balanceAdjustBizDate = balanceAdust.getDate("bizdate");
                    String billStatus = balanceAdust.getString("billstatus");
                    Date bookDate = bankjournal.getDate("bookdate");
                    boolean parameterBoolean = SystemParameterHelper.getParameterBoolean(org, "cs095");
                    if (bookDate == null || balanceAdjustBizDate == null || parameterBoolean || DateUtils.formatString(bookDate, "yyyy-MM-dd").compareTo(DateUtils.formatString(balanceAdjustBizDate, "yyyy-MM-dd")) > 0) continue;
                    String str = isBook ? ResManager.loadKDString((String)"\u767b\u8d26", (String)"AccountBankHelper_7", (String)"fi-cas-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d6\u6d88\u767b\u8d26", (String)"AccountBankHelper_6", (String)"fi-cas-common", (Object[])new Object[0]);
                    String info = String.format(ResManager.loadKDString((String)"\u767b\u8d26\u65e5\u671f[%1$s]\u5df2\u751f\u6210%2$s\u72b6\u6001\u7684\u4f59\u989d\u8c03\u8282\u8868[%3$s], \u4e0d\u5141\u8bb8%4$s", (String)"AccountBankHelper_3", (String)"fi-cas-common", (Object[])new Object[0]), DateUtils.formatString(bookDate, "yyyy-MM-dd"), BillStatusEnum.SUBMIT.getValue().equals(billStatus) ? ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"AccountBankHelper_4", (String)"fi-cas-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u5ba1\u6279", (String)"AccountBankHelper_5", (String)"fi-cas-common", (Object[])new Object[0]), balanceAdust.getString("billno"), str);
                    BookCheckResult result = new BookCheckResult();
                    result.setBizId(bookInfo.getBizId());
                    result.setBizBillNo(bookInfo.getBizBillNo());
                    result.setInfo(info);
                    returns.add(result);
                    iterator.remove();
                }
            }
        }
        return returns;
    }

    public static String checkBalanceAdjustOfStatement(Long org, Long accountbank, Long currency, Date bookDate, boolean isAdd, boolean isUpdate) {
        DynamicObject initOne = QueryServiceHelper.queryOne((String)"cas_cashmgtinit", (String)"id, org, currentperiod.begindate begindate", (QFilter[])new QFilter("org", "=", (Object)org).toArray());
        if (EmptyUtil.isEmpty(initOne) || EmptyUtil.isEmpty(initOne.getDate("begindate"))) {
            return ResManager.loadKDString((String)"\u672a\u51fa\u7eb3\u521d\u59cb\u5316", (String)"AccountBankHelper_13", (String)"fi-cas-common", (Object[])new Object[0]);
        }
        boolean cs096Boolean = SystemParameterHelper.getParameterBoolean(org, "cs096");
        if (bookDate != null && DateUtils.formatString(bookDate, "yyyy-MM-dd").compareTo(DateUtils.formatString(initOne.getDate("begindate"), "yyyy-MM-dd")) < 0 && !cs096Boolean) {
            return isAdd ? ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u6240\u5728\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u8be5\u671f\u95f4\u5bf9\u8d26\u5355", (String)"AccountBankHelper_14", (String)"fi-cas-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u6240\u5728\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c", (String)"AccountBankHelper_15", (String)"fi-cas-common", (Object[])new Object[0]);
        }
        DynamicObject balanceAdust = BalanceAdjustHelper.getLastBalanceAdjust(org, accountbank, currency);
        if (balanceAdust != null) {
            Date balanceAdjustBizDate = balanceAdust.getDate("bizdate");
            String billStatus = balanceAdust.getString("billstatus");
            boolean cs095Boolean = SystemParameterHelper.getParameterBoolean(org, "cs095");
            if (bookDate != null && balanceAdjustBizDate != null && DateUtils.formatString(bookDate, "yyyy-MM-dd").compareTo(DateUtils.formatString(balanceAdjustBizDate, "yyyy-MM-dd")) <= 0 && !cs095Boolean) {
                String str = isAdd ? ResManager.loadKDString((String)"\u5728\u6b64\u4e4b\u524d\u65b0\u589e\u94f6\u884c\u5bf9\u8d26\u5355", (String)"AccountBankHelper_0", (String)"fi-cas-common", (Object[])new Object[0]) : (isUpdate ? ResManager.loadKDString((String)"\u4fee\u6539\u5728\u6b64\u4e4b\u524d\u7684\u94f6\u884c\u5bf9\u8d26\u5355", (String)"AccountBankHelper_16", (String)"fi-cas-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5220\u9664\u5728\u6b64\u4e4b\u524d\u7684\u94f6\u884c\u5bf9\u8d26\u5355", (String)"AccountBankHelper_1", (String)"fi-cas-common", (Object[])new Object[0]));
                return String.format(ResManager.loadKDString((String)"%1$s\u5df2\u751f\u6210%2$s\u72b6\u6001\u7684\u4f59\u989d\u8c03\u8282\u8868[%3$s], \u4e0d\u5141\u8bb8%4$s", (String)"AccountBankHelper_2", (String)"fi-cas-common", (Object[])new Object[0]), DateUtils.formatString(balanceAdjustBizDate, "yyyy-MM-dd"), BillStatusEnum.SUBMIT.getValue().equals(billStatus) ? ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"CheckByHandHelper_5", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u5ba1\u6279", (String)"CheckByHandHelper_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), balanceAdust.getString("billno"), str);
            }
        }
        return "";
    }

    public static QFilter getAccountBankFilterByOrg(Long orgID) {
        return BaseDataServiceHelper.getLookUpListFilter((String)"bd_accountbanks", (Long)orgID, null);
    }

    public static QFilter getAccountBankFilterByOrg(Collection<Long> orgIDs) {
        return BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", new ArrayList<Long>(orgIDs), (boolean)true);
    }

    public static QFilter getAccountBankFilterByOrg(Collection<Long> orgIDs, boolean isRemoveDup) {
        return BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", new ArrayList<Long>(orgIDs), (boolean)isRemoveDup);
    }

    public static boolean validateAccountAuthByOrg(long orgId, long acctBankId) {
        QFilter qFilter = AccountBankHelper.getAccountBankFilterByOrg(orgId);
        qFilter.and(new QFilter("id", "=", (Object)acctBankId));
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return accountBanks.length > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static QFilter[] getCreateOrgAccountFilter(long orgId) {
        return new QFilter[]{AccountBankHelper.getCreateOrgFilter(Collections.singletonList(orgId)), AccountBankHelper.getUsableFilter()};
    }

    public static QFilter[] getCreateOrgAccountFilter(Collection<Long> orgIds) {
        return new QFilter[]{AccountBankHelper.getCreateOrgFilter(orgIds), AccountBankHelper.getUsableFilter()};
    }

    public static boolean isAuthorityAccount(DynamicObject accountBank, DynamicObject org) {
        if (accountBank == null || org == null) {
            return false;
        }
        return org.getLong("id") == accountBank.getDynamicObject("createorg").getLong("id");
    }

    public static boolean isAuthorityAccount(DynamicObject accountBank, Long orgId) {
        if (accountBank == null) {
            return false;
        }
        return orgId.equals(accountBank.getDynamicObject("createorg").getLong("id"));
    }

    public static Set<Long> getUserAuthorityOrgs(Long accountBankId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fuseorgid from ").append("t_bd_accountbanks_u").append(" where fdataid= ?");
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks");
        ResultSetHandler<Set<Long>> action = new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> list = new HashSet<Long>(10);
                while (rs.next()) {
                    list.add(rs.getLong("fuseorgid"));
                }
                return list;
            }
        };
        Set result = (Set)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)sql.toString(), (Object[])new Object[]{accountBankId}, (ResultSetHandler)action);
        return result;
    }

    public static Map<Long, Set<Long>> getUserAuthorityOrgsByAccIds(Set<Long> accountBankId, Set<Long> orgIds) {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (Long accountBank : accountBankId) {
            stringJoiner.add(String.valueOf(accountBank));
        }
        String ksql = "select fuseorgid,fdataid from t_bd_accountbanks_u  where fdataid in (" + stringJoiner + ")";
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks");
        ResultSetHandler<Map<Long, Set<Long>>> action = new ResultSetHandler<Map<Long, Set<Long>>>(){

            public Map<Long, Set<Long>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Set<Long>> mapOfAccAndOrg = new HashMap<Long, Set<Long>>();
                while (rs.next()) {
                    Long dataid = rs.getLong("fdataid");
                    Long useorgid = rs.getLong("fuseorgid");
                    if (mapOfAccAndOrg.containsKey(dataid)) {
                        ((Set)mapOfAccAndOrg.get(dataid)).add(useorgid);
                        continue;
                    }
                    HashSet<Long> orgIdSet = new HashSet<Long>();
                    orgIdSet.add(useorgid);
                    mapOfAccAndOrg.put(dataid, orgIdSet);
                }
                return mapOfAccAndOrg;
            }
        };
        Map result = (Map)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)ksql, (ResultSetHandler)action);
        return result;
    }

    public static Set<Long> getUserOrgsByAccIds(Object[] accountBankId) {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (Object accountBank : accountBankId) {
            stringJoiner.add(String.valueOf(accountBank));
        }
        String ksql = "select fuseorgid,fdataid from t_bd_accountbanks_u  where fdataid in (" + stringJoiner + ")";
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks");
        ResultSetHandler<Set<Long>> action = new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> list = new HashSet<Long>(10);
                while (rs.next()) {
                    list.add(rs.getLong("fuseorgid"));
                }
                return list;
            }
        };
        Set result = (Set)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)ksql, (ResultSetHandler)action);
        return result;
    }

    public static Map<Long, Set<Long>> getUseOrgsByAccIds(Object[] accountBankId) {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (Object accountBank : accountBankId) {
            stringJoiner.add(String.valueOf(accountBank));
        }
        String ksql = "select fuseorgid,fdataid from t_bd_accountbanks_u  where fdataid in (" + stringJoiner + ")";
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks");
        ResultSetHandler<Map<Long, Set<Long>>> action = new ResultSetHandler<Map<Long, Set<Long>>>(){

            public Map<Long, Set<Long>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(16);
                while (rs.next()) {
                    Long accountId = rs.getLong("fdataid");
                    Long orgId = rs.getLong("fuseorgid");
                    HashSet<Long> orgIds = (HashSet<Long>)map.get(accountId);
                    if (orgIds == null) {
                        orgIds = new HashSet<Long>(16);
                        map.put(accountId, orgIds);
                    }
                    orgIds.add(orgId);
                }
                return map;
            }
        };
        Map result = (Map)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)ksql, (ResultSetHandler)action);
        return result;
    }

    public static DynamicObject[] getAccountBanksByCreateOrg(Long orgID) {
        QFilter[] qFilter = AccountBankHelper.getCreateOrgAccountFilter(orgID);
        return BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,company,openorg,createorg,bankaccountnumber", (QFilter[])qFilter);
    }

    public static Set<Long> getVirtualBankIds(Set<Long> acctBankIds) {
        QFilter qFilter = new QFilter("id", "in", acctBankIds);
        QFilter qVirtual = new QFilter("isvirtual", "=", (Object)"1");
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{qFilter, qVirtual});
        HashSet<Long> isVirtualBankIds = new HashSet<Long>(accounts.size());
        for (DynamicObject account : accounts) {
            Long id = account.getLong("id");
            isVirtualBankIds.add(id);
        }
        return isVirtualBankIds;
    }

    public static Map<String, Boolean> isEntrustCanUseAccounts(Set<Long> orgIds, Set<Long> acctBankIds, Map<Long, Set<Long>> accBankIdAndOrgIdMap) {
        HashMap<String, Boolean> accBankBoolMap = new HashMap<String, Boolean>();
        QFilter qFilter = new QFilter("id", "in", acctBankIds);
        QFilter qFilter1 = new QFilter("acctstatus", "!=", (Object)"closed");
        QFilter qFilter2 = qFilter.and(qFilter1);
        long startTime1 = System.currentTimeMillis();
        log.info(" acctstatus  start:" + startTime1);
        log.info(" acctstatus  orgIds is:" + SerializationUtils.toJsonString(orgIds));
        log.info(" acctstatus  acctBankIds is:" + SerializationUtils.toJsonString(acctBankIds));
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,company,acctstatus", (QFilter[])qFilter2.toArray());
        log.info(" acctstatus  end:" + (System.currentTimeMillis() - startTime1));
        Set<Long> theNextacctBankIds = accounts.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        log.info(" acctstatus  theNextacctBankIds is:" + SerializationUtils.toJsonString(theNextacctBankIds));
        for (Long bankId : acctBankIds) {
            if (theNextacctBankIds.contains(bankId)) continue;
            accBankBoolMap.put(String.valueOf(bankId), Boolean.FALSE);
        }
        if (theNextacctBankIds.size() > 0) {
            Set<Long> theLastSet = AccountBankHelper.validateAccountAuthByOrgs(orgIds, theNextacctBankIds, accBankBoolMap, Boolean.FALSE, new HashMap<Long, Long>());
            log.info(" acctstatus  theLastSet is:" + SerializationUtils.toJsonString(theLastSet));
            log.info(" acctstatus  orgIds after validateAccountAuthByOrgs is:" + SerializationUtils.toJsonString(orgIds));
            if (theLastSet.size() > 0) {
                HashMap<Long, DynamicObject> orgIdAndToorgMap = new HashMap<Long, DynamicObject>();
                HashMap<Long, Long> orgIdAndFromOrgIdMap = new HashMap<Long, Long>();
                QFilter fromOrgFilter = new QFilter("fromorg", "in", orgIds);
                QFilter numberFilter = new QFilter("typerelation.number", "=", (Object)"accounting2capital");
                QFilter isPreSetFilter = new QFilter("typerelation.ispreset", "=", (Object)"1");
                QFilter[] qFilters = fromOrgFilter.and(numberFilter).and(isPreSetFilter).toArray();
                AccountBankHelper.getToorgData(orgIdAndToorgMap, orgIdAndFromOrgIdMap, qFilters);
                log.info(" acctstatus  orgIdAndFromOrgIdMap is:" + SerializationUtils.toJsonString(orgIdAndFromOrgIdMap));
                if (orgIdAndFromOrgIdMap.size() > 0) {
                    Set<Long> toorgPkSet = orgIdAndFromOrgIdMap.keySet();
                    Set<Long> resultSet = AccountBankHelper.validateAccountAuthByOrgs(toorgPkSet, theLastSet, accBankBoolMap, Boolean.TRUE, orgIdAndFromOrgIdMap);
                    log.info("resultSet size is:" + resultSet.size());
                } else {
                    for (Long accBankId : theLastSet) {
                        accBankBoolMap.put(String.valueOf(accBankId), Boolean.FALSE);
                    }
                }
            }
        }
        return accBankBoolMap;
    }

    private static void getToorgData(Map<Long, DynamicObject> orgIdAndToorgMap, Map<Long, Long> orgIdAndFromOrgIdMap, QFilter[] qFilters) {
        Long startTime1 = System.currentTimeMillis();
        log.info(" getToorgData  start:" + startTime1);
        DynamicObject[] orgRelations = BusinessDataServiceHelper.load((String)"bos_org_orgrelation", (String)"toorg,fromorg", (QFilter[])qFilters);
        log.info(" getToorgData  end:" + (System.currentTimeMillis() - startTime1));
        Map<Long, List<DynamicObject>> orgIdSet = Arrays.stream(orgRelations).collect(Collectors.groupingBy(e -> e.getDynamicObject("fromorg").getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : orgIdSet.entrySet()) {
            DynamicObject data = entry.getValue().get(0);
            orgIdAndToorgMap.put(entry.getKey(), data);
            orgIdAndFromOrgIdMap.put(data.getDynamicObject("toorg").getLong("id"), entry.getKey());
        }
    }

    public static Set<Long> validateAccountAuthByOrgs(Set<Long> orgIds, Set<Long> acctBankIds, Map<String, Boolean> accBankBoolMap, Boolean isLasTime, Map<Long, Long> orgIdAndFromOrgIdMap) {
        HashSet<Long> theLastSet = new HashSet<Long>();
        Map<Long, Set<Long>> billAndDetailBenaMap = AccountBankHelper.getUserAuthorityOrgsByAccIds(acctBankIds, orgIds);
        log.info(" acctstatus  billAndDetailBenaMap is:" + SerializationUtils.toJsonString(billAndDetailBenaMap));
        for (Long accountBankId : acctBankIds) {
            if (null != billAndDetailBenaMap.get(accountBankId)) {
                Set<Long> datas = billAndDetailBenaMap.get(accountBankId);
                for (Long orgId : datas) {
                    if (isLasTime.booleanValue()) {
                        if (orgIdAndFromOrgIdMap != null && orgIdAndFromOrgIdMap.size() > 0) {
                            log.info("\u6709\u4f7f\u7528\u6743\u9650\u7684\u7ec4\u7ec7:{}", (Object)orgId);
                            if (orgIdAndFromOrgIdMap.containsKey(orgId)) {
                                Long fromOrg = orgIdAndFromOrgIdMap.get(orgId);
                                String keyStr = accountBankId + "_" + fromOrg;
                                accBankBoolMap.put(keyStr, Boolean.TRUE);
                            }
                        } else {
                            log.info("orgIdAndFromOrgIdMap is null!");
                        }
                    }
                    if (orgIds.contains(orgId)) {
                        String keyStr = accountBankId + "_" + orgId;
                        accBankBoolMap.put(keyStr, Boolean.TRUE);
                        continue;
                    }
                    if (isLasTime.booleanValue()) continue;
                    theLastSet.add(accountBankId);
                }
                continue;
            }
            if (!isLasTime.booleanValue()) {
                theLastSet.add(accountBankId);
                continue;
            }
            log.info(" validateAccountAuthByOrgs  accountBankId false:" + accountBankId);
            accBankBoolMap.put(String.valueOf(accountBankId), Boolean.FALSE);
        }
        log.info("\u8fd4\u56de\u4fe1\u606ftheLastSet:{}", (Object)SerializationUtils.toJsonString(theLastSet));
        return theLastSet;
    }

    public static String commitBeiValidate(Long id) {
        if (id == null || id.compareTo(0L) == 0) {
            return null;
        }
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"am_accountbank");
        if (EmptyUtil.isEmpty(account)) {
            return null;
        }
        if ("3".equals(account.getString("finorgtype"))) {
            return null;
        }
        String bankFunc = account.getString("bebankfunc");
        if (StringUtils.isNotEmpty((CharSequence)bankFunc) && bankFunc.contains("pay") && account.getBoolean("issetbankinterface")) {
            return null;
        }
        return ResManager.loadKDString((String)"\u8d26\u6237\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\u4e14\u52fe\u9009\u4e86\u652f\u4ed8\u529f\u80fd\u6216\u8005\u8d26\u6237\u5f00\u6237\u884c\u7c7b\u522b=\u8d22\u52a1\u516c\u53f8\u624d\u80fd\u63d0\u4ea4\u94f6\u4f01", (String)"AccountBankHelper_8", (String)"fi-cas-common", (Object[])new Object[0]);
    }

    public static void initOrgForAccountManagerTransfer(ListShowParameter listShowParameter, List<FilterColumn> commonFilterColumns, IPageCache pageCache) {
        Map customParams = listShowParameter.getCustomParams();
        if (pageCache.get(FROM_ACCOUNT_TRADE) == null && customParams != null && customParams.containsKey(FROM_ACCOUNT_TRADE)) {
            for (FilterColumn filterColumn : commonFilterColumns) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (!"org.id".equals(fieldName) || !customParams.containsKey("org")) continue;
                if (customParams.containsKey(FROM_ACCOUNT_ASSIGN_CANCEL)) {
                    Set orgIds = (Set)SerializationUtils.fromJsonString((String)customParams.get("org").toString(), HashSet.class);
                    commonFilterColumn.setDefaultValues(orgIds.toArray(new Object[0]));
                    continue;
                }
                commonFilterColumn.setDefaultValues(new Object[]{customParams.get("org").toString()});
            }
        }
    }

    public static void initForAccountManagerTransfer(ListShowParameter listShowParameter, List<FilterColumn> commonFilterColumns, IPageCache pageCache) {
        Map customParams = listShowParameter.getCustomParams();
        if (pageCache.get(FROM_ACCOUNT_TRADE) == null && customParams != null && customParams.containsKey(FROM_ACCOUNT_TRADE)) {
            pageCache.put(FROM_ACCOUNT_TRADE, "1");
            for (FilterColumn filterColumn : commonFilterColumns) {
                String fieldName;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                switch (fieldName = commonFilterColumn.getFieldName()) {
                    case "bizdate": {
                        if (!customParams.containsKey("bizdate")) break;
                        commonFilterColumn.setDefaultValue((String)customParams.get("bizdate"));
                        break;
                    }
                    case "accountbank.id": 
                    case "bankaccount.id": {
                        if (!customParams.containsKey("accountbank")) break;
                        commonFilterColumn.setDefaultValue(customParams.get("accountbank").toString());
                        break;
                    }
                    case "period.name": {
                        if (!customParams.containsKey("periodId")) break;
                        commonFilterColumn.setDefaultValue(customParams.get("periodId").toString());
                    }
                }
            }
            customParams.remove(FROM_ACCOUNT_TRADE);
        }
    }

    public static QFilter getUseAuthAccountBankFilterByOrg(Collection<Long> orgIDs) {
        return AccountBankHelper.getAccountBankFilterByOrg(orgIDs).or(AccountBankHelper.getAccountBankHistoryUseOrgFilter(orgIDs));
    }

    public static QFilter getAccountBankHistoryUseOrgFilter(Collection<Long> orgIDs) {
        StringJoiner orgIdJoiner = new StringJoiner(",");
        orgIDs.stream().map(String::valueOf).forEach(orgIdJoiner::add);
        return QFilter.sqlExpress((String)"id", (String)"in", (String)("select faccountid from t_am_unassign_org_u where fuseorgid in (" + orgIdJoiner + ")"));
    }

    public static Set<Long> getUseAuthorityOrg(Long accountBankId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fuseorgid from ").append("t_bd_accountbanks_u").append(" where fdataid = ? ");
        sql.append("union all ");
        sql.append("select fuseorgid from ").append("t_am_unassign_org_u").append(" where faccountid = ? ");
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks");
        ResultSetHandler<Set<Long>> action = new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> list = new HashSet<Long>(10);
                while (rs.next()) {
                    list.add(rs.getLong("fuseorgid"));
                }
                return list;
            }
        };
        Set result = (Set)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)sql.toString(), (Object[])new Object[]{accountBankId, accountBankId}, (ResultSetHandler)action);
        return result;
    }

    public static Map<Long, Set<Long>> getUseAuthorityOrgByAccIds(Object[] accountBankId) {
        StringJoiner stringJoiner = new StringJoiner(",");
        Arrays.stream(accountBankId).map(String::valueOf).forEach(stringJoiner::add);
        String ksql = "select fuseorgid,fdataid from t_bd_accountbanks_u where fdataid in (" + stringJoiner + ") union all select fuseorgid,faccountid as fdataid from t_am_unassign_org_u where faccountid in (" + stringJoiner + ") ";
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks");
        ResultSetHandler<Map<Long, Set<Long>>> action = new ResultSetHandler<Map<Long, Set<Long>>>(){

            public Map<Long, Set<Long>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(16);
                while (rs.next()) {
                    Long accountId = rs.getLong("fdataid");
                    Long orgId = rs.getLong("fuseorgid");
                    HashSet<Long> orgIds = (HashSet<Long>)map.get(accountId);
                    if (EmptyUtil.isEmpty(orgIds)) {
                        orgIds = new HashSet<Long>(16);
                        map.put(accountId, orgIds);
                    }
                    orgIds.add(orgId);
                }
                return map;
            }
        };
        return (Map)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)ksql, (ResultSetHandler)action);
    }
}

