/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class AccountCashHelper {
    public static DynamicObject getAccountCashById(long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"cas_accountcash");
    }

    public static DynamicObject getFirstAcctCashByOrg(long orgId) {
        String selector = "id,name,number,opendate,isbycurrency,defaultcurrency,org.name";
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("closestatus", "=", (Object)"0")};
        DynamicObject[] accountCashs = BusinessDataServiceHelper.load((String)"cas_accountcash", (String)selector, (QFilter[])filters, (String)"number", (int)1);
        return accountCashs != null && accountCashs.length > 0 ? accountCashs[0] : null;
    }

    public static List<Long> getCurrencyListByCashAcct(long cashAcctId) {
        return AccountCashHelper.getCurrencys(Collections.singletonList(cashAcctId));
    }

    public static List<Long> getCurrencys(Collection<Long> accountCashIds) {
        DynamicObjectCollection queryAcctColl = QueryServiceHelper.query((String)"cas_accountcash", (String)"id,currency.fbasedataid.id,currency.fbasedataid.enable", (QFilter[])new QFilter[]{new QFilter("id", "in", accountCashIds), new QFilter("currency.fbasedataid.enable", "=", (Object)"1")}, null);
        ArrayList<Long> currencys = new ArrayList<Long>(queryAcctColl.size());
        for (int i = 0; i < queryAcctColl.size(); ++i) {
            DynamicObject acctObj = (DynamicObject)queryAcctColl.get(i);
            currencys.add(acctObj.getLong("currency.fbasedataid.id"));
        }
        return currencys;
    }

    public static DynamicObjectCollection getCurrencyCollByCashAcct(long cashAcctId) {
        return QueryServiceHelper.query((String)"getCurrencyByCashAcct", (String)"bd_currency", (String)"id,name,number,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", AccountCashHelper.getCurrencyListByCashAcct(cashAcctId))}, null);
    }

    public static QFilter[] getUsableAccountFilter(Long orgId) {
        return AccountCashHelper.getUsableAccountFilter(Collections.singletonList(orgId));
    }

    public static QFilter[] getUsableAccountFilter(Collection<Long> orgIds) {
        return new QFilter[]{AccountCashHelper.getOrgFilter(orgIds), AccountCashHelper.getUsableFilter()};
    }

    public static QFilter[] getAccountFilter(Collection<Long> orgIds) {
        return new QFilter[]{AccountCashHelper.getOrgFilter(orgIds)};
    }

    public static QFilter getUsableFilter() {
        return new QFilter("closestatus", "=", (Object)"0");
    }

    private static QFilter getOrgFilter(Collection<Long> orgIds) {
        return new QFilter("org", "in", orgIds);
    }

    public static Long getDefaultAccountcash(Long orgId, String defaultType) {
        Long pk = null;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter[] orgFilter = AccountCashHelper.getUsableAccountFilter(orgId);
        qFilters.addAll(Arrays.asList(orgFilter));
        if ("payee".equals(defaultType)) {
            qFilters.add(new QFilter("isdefaultpayee", "=", (Object)"1"));
        } else {
            qFilters.add(new QFilter("isdefaultpayer", "=", (Object)"1"));
        }
        DynamicObject accountcash = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_accountcash", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (null != accountcash) {
            pk = accountcash.getLong("id");
        }
        return pk;
    }

    public static DynamicObject[] getAcctCashByNumbers(Set<String> numbers) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", numbers)};
        String selector = "id,name,number";
        DynamicObject[] cashes = BusinessDataServiceHelper.load((String)"cas_accountcash", (String)selector, (QFilter[])filters);
        return cashes;
    }
}

