/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.util.EmptyUtil;

public class BalanceAccHelper {
    private BalanceAccHelper() {
    }

    public static Boolean isStartBalanceAcc(Long orgId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject recEdc = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod", (QFilter[])new QFilter[]{orgFilter});
        if (EmptyUtil.isEmpty(recEdc)) {
            return false;
        }
        return true;
    }

    public static DynamicObject balanceAcc(Long orgId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject recEdc = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod", (QFilter[])new QFilter[]{orgFilter});
        return recEdc;
    }

    public static DynamicObject[] balanceAccByOrgIds(Set<Long> orgIds) {
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        DynamicObject[] recEdc = BusinessDataServiceHelper.load((String)"cas_rec_edc", (String)"id, org, recperiod", (QFilter[])new QFilter[]{orgFilter});
        return recEdc;
    }

    public static Boolean validateRecInit(Long account, Date endDate) {
        DynamicObject accountBank = AccountBankHelper.getAccountBankById(account);
        DynamicObject inits = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_rec_edc", (String)"org,isfinishinit,startperiod,currentperiod,recperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", accountBank.getDynamicObject("createorg").getPkValue())});
        if (inits == null || EmptyUtil.isEmpty(inits)) {
            return false;
        }
        DynamicObject recPeriod = inits.getDynamicObject("recperiod");
        if (recPeriod == null || EmptyUtil.isEmpty(recPeriod)) {
            return false;
        }
        Object recPeriodId = null;
        if (recPeriod != null && EmptyUtil.isNoEmpty(recPeriod)) {
            recPeriodId = recPeriod.getPkValue();
        }
        QFilter periodFilter = new QFilter("initperiod", "=", recPeriodId);
        QFilter finishinitFilter = new QFilter("isfinishinit", "=", (Object)"1");
        QFilter orgFilter = new QFilter("org", "=", accountBank.getDynamicObject("createorg").getPkValue());
        Map recInitObject = BusinessDataServiceHelper.loadFromCache((String)"cas_rec_init", (String)"id, org, entrybank, entrybank.bank_currency, initperiod, entrybank.bank_accountbank , entrybank.bank_statementbalance", (QFilter[])new QFilter[]{orgFilter, periodFilter, finishinitFilter});
        if (recInitObject == null || EmptyUtil.isEmpty(recInitObject) || recInitObject.size() == 0) {
            return false;
        }
        Date recPeriodBegin = recPeriod.getDate("begindate");
        if (endDate.before(recPeriodBegin)) {
            return false;
        }
        return true;
    }
}

