/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.botp.enums.AsstActTypeEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.enums.SysParamCs126Enum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.info.AdminDivision;
import kd.fi.cas.info.SCAccountInfo;
import org.apache.commons.lang3.StringUtils;

public class BaseDataHelper {
    public static final String SETTLECATE_COMMERCE = "5";
    public static final String SETTLECATE_BANK = "6";
    public static final String SETTLECATE_PROM = "1";
    public static final String SETTLECATE_CHECK = "2";

    public static BigDecimal getExchangeRate(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (date == null) {
            date = new Date();
        }
        if (sourceCurrencyId == null || sourceCurrencyId == 0L || targetCurrencyId == null || targetCurrencyId == 0L || sourceCurrencyId.equals(targetCurrencyId)) {
            return exchangeRate;
        }
        if (sourceCurrencyId.longValue() == targetCurrencyId.longValue()) {
            return exchangeRate;
        }
        Long exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable(orgId).getLong("id");
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
        return exchangeRate;
    }

    public static BigDecimal getExchangeRateByTable(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date exratedate, Long exchangeRateTableId) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (sourceCurrencyId == null || sourceCurrencyId == 0L || targetCurrencyId == null || targetCurrencyId == 0L || sourceCurrencyId.equals(targetCurrencyId)) {
            return exchangeRate;
        }
        if (sourceCurrencyId.longValue() == targetCurrencyId.longValue()) {
            return exchangeRate;
        }
        if (exchangeRateTableId == 0L || CasHelper.isEmpty(exchangeRateTableId)) {
            exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable(orgId).getLong("id");
        }
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)exratedate);
        return exchangeRate;
    }

    public static DynamicObject getDefaultSettleType() {
        QFilter[] filters = new QFilter[]{new QFilter("isdefault", "=", (Object)SETTLECATE_PROM), new QFilter("enable", "=", (Object)SETTLECATE_PROM)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"id, name, number, ispaythroughbe, settlementtype, paymentchannel, defaultpaymentchannel", (QFilter[])filters);
    }

    public static DynamicObject getInternalOrg(DynamicObject basedata) {
        if (basedata == null) {
            return null;
        }
        String entity = basedata.getDataEntityType().getName();
        if ((basedata = BusinessDataServiceHelper.loadSingleFromCache((Object)basedata.getPkValue(), (String)entity, (String)"internal_company")) == null) {
            return null;
        }
        return basedata.getDynamicObject("internal_company");
    }

    public static DynamicObject getInternalOrg(DynamicObject org, DynamicObject basedata) {
        if (basedata == null) {
            return null;
        }
        String entity = basedata.getDataEntityType().getName();
        if ((basedata = BusinessDataServiceHelper.loadSingleFromCache((Object)basedata.getPkValue(), (String)entity, (String)"internal_company")) == null) {
            return null;
        }
        if (BaseDataHelper.isInternalOrg(org)) {
            return basedata.getDynamicObject("internal_company");
        }
        return null;
    }

    public static boolean isInternalOrg(DynamicObject org) {
        Set<String> cs126;
        return org == null || !(cs126 = SystemParameterHelper.getParameterComboxs(org.getLong("id"), "cs126")).contains(SysParamCs126Enum.INTERNAL.getValue());
    }

    public static int getCS126Param(DynamicObject org) {
        int cs126 = SystemParameterHelper.getParameterInteger(org.getLong("id"), "cs126");
        return cs126;
    }

    public static String getSupplierLiquidationParam(Long payeeId, boolean isCrossPay, DynamicObject org, String payeeBankNum) {
        DynamicObject supplierDO;
        String liquidationParam = "";
        if (!CasHelper.isEmpty(payeeId) && !CasHelper.isEmpty(supplierDO = BusinessDataServiceHelper.loadSingle((Object)payeeId, (String)"bd_supplier", (String)"internal_company.id,entry_bank.bankaccount,entry_bank.settlment,entry_bank.liquidationparam,entry_bank.isdefault_bank"))) {
            DynamicObjectCollection entry_banks = supplierDO.getDynamicObjectCollection("entry_bank");
            DynamicObject internalCompany = supplierDO.getDynamicObject("internal_company");
            if (CasHelper.isNotEmpty(internalCompany)) {
                boolean flag = BaseDataHelper.isInternalOrg(org);
                if (!flag) {
                    liquidationParam = BaseDataHelper.getLiquidationParam(payeeBankNum, liquidationParam, entry_banks);
                }
            } else {
                liquidationParam = BaseDataHelper.getLiquidationParam(payeeBankNum, liquidationParam, entry_banks);
            }
        }
        return liquidationParam;
    }

    private static String getLiquidationParam(String payeeBankNum, String liquidationParam, DynamicObjectCollection entry_banks) {
        if (!CasHelper.isEmpty(entry_banks)) {
            for (int i = 0; i < entry_banks.size(); ++i) {
                DynamicObject entry_bank = (DynamicObject)entry_banks.get(i);
                String bankAccount = entry_bank.getString("bankaccount");
                if (!payeeBankNum.equalsIgnoreCase(bankAccount)) continue;
                liquidationParam = entry_bank.getString("liquidationparam");
                break;
            }
        }
        return liquidationParam;
    }

    public static SCAccountInfo getDefaultBankInfo(DynamicObject basedata) {
        if (basedata == null) {
            return null;
        }
        String entity = basedata.getDataEntityType().getName();
        basedata = BusinessDataServiceHelper.loadSingleFromCache((Object)basedata.getPkValue(), (String)entity);
        DynamicObjectCollection bankColls = basedata.getDynamicObjectCollection("entry_bank");
        DynamicObject defaultBankAccountInfo = null;
        for (int i = 0; i < bankColls.size(); ++i) {
            if (i != 0 && !((DynamicObject)bankColls.get(i)).getBoolean("isdefault_bank")) continue;
            defaultBankAccountInfo = (DynamicObject)bankColls.get(i);
        }
        if (defaultBankAccountInfo != null) {
            SCAccountInfo scAccountInfo = new SCAccountInfo();
            scAccountInfo.setAccount(defaultBankAccountInfo.getString("bankaccount"));
            scAccountInfo.setAccountName(defaultBankAccountInfo.getLocaleString("accountname").getLocaleValue());
            scAccountInfo.setCurrency(defaultBankAccountInfo.getDynamicObject("currency"));
            scAccountInfo.setDefault(defaultBankAccountInfo.getBoolean("isdefault_bank"));
            scAccountInfo.setBeBank(defaultBankAccountInfo.getDynamicObject("bank"));
            scAccountInfo.setSupplierBankId(Long.valueOf(defaultBankAccountInfo.getPkValue().toString()));
            return scAccountInfo;
        }
        return null;
    }

    public static SCAccountInfo loadBankInfo(String asstactType, Long entryPk) {
        SCAccountInfo scAccountInfo = new SCAccountInfo();
        DynamicObject customerOrSupplier = BusinessDataServiceHelper.loadSingle((String)asstactType, (String)"bankaccount,accountname,bank,currency,isdefault_bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", (Object)entryPk)});
        if (customerOrSupplier == null) {
            return scAccountInfo;
        }
        DynamicObjectCollection entryBanks = customerOrSupplier.getDynamicObjectCollection("entry_bank");
        for (DynamicObject row : entryBanks) {
            if (!row.getPkValue().equals(entryPk)) continue;
            scAccountInfo.setAccount(row.getString("bankaccount"));
            scAccountInfo.setAccountName(row.getString("accountname"));
            scAccountInfo.setCurrency(row.getDynamicObject("currency"));
            scAccountInfo.setDefault(row.getBoolean("isdefault_bank"));
            scAccountInfo.setBeBank(row.getDynamicObject("bank"));
            scAccountInfo.setSupplierBankId(entryPk);
            return scAccountInfo;
        }
        return scAccountInfo;
    }

    public static AdminDivision getAdminDivision(String beBankNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)beBankNumber)};
        DynamicObject beBank = BusinessDataServiceHelper.loadSingle((String)"bd_bebank", (String)"name,city,basedatafield1", (QFilter[])filters);
        return BaseDataHelper.getAdminDivision(beBank);
    }

    public static AdminDivision getAdminDivision(DynamicObject beBank) {
        if (beBank == null) {
            return null;
        }
        beBank = BusinessDataServiceHelper.loadSingleFromCache((Object)beBank.getPkValue(), (String)beBank.getDataEntityType().getName());
        String province2 = null;
        String city2 = null;
        DynamicObject adminDivision = null;
        IDataEntityProperty cityProp = (IDataEntityProperty)beBank.getDataEntityType().getProperties().get((Object)"city");
        if (cityProp == null) {
            cityProp = (IDataEntityProperty)beBank.getDataEntityType().getProperties().get((Object)"basedatafield1");
            if (cityProp == null) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u65e2\u6ca1\u6709city,\u4e5f\u6ca1\u6709basedatafield1,\u4f60\u5230\u5e95\u8981\u95f9\u54ea\u6837\u513f\uff01\uff01\uff01", (String)"BaseDataHelper_0", (String)"fi-cas-common", (Object[])new Object[0]));
            }
            adminDivision = beBank.getDynamicObject("basedatafield1");
        } else {
            adminDivision = beBank.getDynamicObject("city");
        }
        if (adminDivision == null) {
            return null;
        }
        adminDivision = BusinessDataServiceHelper.loadSingleFromCache((Object)adminDivision.getLong("id"), (String)"bd_admindivision");
        DynamicObject country = adminDivision.getDynamicObject("country");
        int level = adminDivision.getInt("level");
        if (level == 1) {
            province2 = adminDivision.getString("name");
        } else if (level == 2) {
            province2 = adminDivision.getString("parent.name");
            city2 = adminDivision.getString("name");
        } else if (level == 3) {
            DynamicObject city = BusinessDataServiceHelper.loadSingle((Object)adminDivision.getLong("parent.id"), (String)"bd_admindivision", (String)"id, name, level, iscity, basedatafield.id, basedatafield.name, parent.id, parent.name,country");
            province2 = city.getString("parent.name");
            city2 = city.getString("name");
        }
        AdminDivision adminDivision2 = new AdminDivision();
        adminDivision2.setCountry(country);
        adminDivision2.setProvince(province2);
        adminDivision2.setCity(city2);
        return adminDivision2;
    }

    public static boolean isSettleTypeCash(DynamicObject settleType) {
        if (settleType == null) {
            return false;
        }
        return "0".equals(settleType.getString("settlementtype"));
    }

    public static boolean isSettleTypeDcep(DynamicObject settleType) {
        if (settleType == null) {
            return false;
        }
        return SettleMentTypeEnum.DCEP.getValue().equals(settleType.getString("settlementtype"));
    }

    public static boolean isSettleTypeDraft(DynamicObject settleType) {
        if (settleType == null) {
            return false;
        }
        return SETTLECATE_COMMERCE.equals(settleType.getString("settlementtype")) || SETTLECATE_BANK.equals(settleType.getString("settlementtype"));
    }

    public static boolean isSettleTypeCheck(DynamicObject settleType) {
        if (settleType == null) {
            return false;
        }
        return SETTLECATE_CHECK.equals(settleType.getString("settlementtype"));
    }

    public static boolean isSettleTypeProm(DynamicObject settleType) {
        if (settleType == null) {
            return false;
        }
        return SETTLECATE_PROM.equals(settleType.getString("settlementtype"));
    }

    public static boolean isSettleTypeVirtual(DynamicObject settleType) {
        if (settleType == null) {
            return false;
        }
        return "14".equals(settleType.getString("settlementtype"));
    }

    public static boolean isSettleTypeMatch(DynamicObject settleType) {
        if (settleType == null) {
            return false;
        }
        String settlementType = settleType.getString("settlementtype");
        return StringUtils.equalsAny((CharSequence)settlementType, (CharSequence[])new CharSequence[]{"0", "14", SETTLECATE_BANK, SETTLECATE_COMMERCE, SETTLECATE_CHECK, SETTLECATE_PROM, "16"});
    }

    public static String getPictureUrl(Long basedataId, String basedataType) {
        if (CasHelper.isEmpty(basedataId)) {
            return null;
        }
        if ("bd_supplier".equals(basedataType) || "bd_customer".equals(basedataType)) {
            DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((Object)basedataId, (String)basedataType, (String)"picturefield");
            if (baseData != null && !CasHelper.isEmpty(baseData.get("picturefield"))) {
                return BaseDataHelper.getImageFullPath((String)baseData.get("picturefield"));
            }
        } else if ("bos_user".equals(basedataType)) {
            return BaseDataHelper.getUserImageFullPath(basedataId);
        }
        return null;
    }

    public static DynamicObject getInternalOrg(Long payee, String payeeType) {
        if (payee == null || payee.intValue() == 0 || !AsstActTypeEnum.SUPPLIER.getValue().equals(payeeType) && !AsstActTypeEnum.CUSTOMER.getValue().equals(payeeType)) {
            return null;
        }
        DynamicObject customerOrSupplier = BusinessDataServiceHelper.loadSingleFromCache((Object)payee, (String)payeeType, (String)"internal_company");
        if (customerOrSupplier == null) {
            return null;
        }
        return customerOrSupplier.getDynamicObject("internal_company");
    }

    public static DynamicObject getInternalOrg(DynamicObject org, Long payee, String payeeType) {
        if (payee == null || payee.intValue() == 0 || !AsstActTypeEnum.SUPPLIER.getValue().equals(payeeType) && !AsstActTypeEnum.CUSTOMER.getValue().equals(payeeType)) {
            return null;
        }
        DynamicObject customerOrSupplier = BusinessDataServiceHelper.loadSingleFromCache((Object)payee, (String)payeeType, (String)"internal_company");
        if (customerOrSupplier == null) {
            return null;
        }
        if (BaseDataHelper.isInternalOrg(org)) {
            return customerOrSupplier.getDynamicObject("internal_company");
        }
        return null;
    }

    public static String getUserImageFullPath(Long userId) {
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(userId);
        Map userAvatarPath = UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
        return userAvatarPath.size() > 0 ? (String)userAvatarPath.get(userId) : null;
    }

    public static String getImageFullPath(String pictureUrl) {
        if (!pictureUrl.toLowerCase(Locale.ENGLISH).startsWith("http")) {
            pictureUrl = UrlService.getImageFullUrl((String)pictureUrl);
        }
        return pictureUrl;
    }
}

