/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class BotpFixLinkHelper {
    public void fixRowLink(DynamicObject targetBillObj, String targetEntryKey, String srcBillTypeFld, String srcBillId, String srcEntryKey, String srcEntryIdFld) {
        TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)targetBillObj.getDataEntityType().getName(), (String)targetEntryKey);
        String srcBillType = targetBillObj.getString(srcBillTypeFld);
        TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)srcBillType, (String)srcEntryKey);
        DynamicObject sourceBillObj = this.loadSourceBill(srcTableDefine, srcBillId);
        this.createLinkEntity(targetTableDefine, targetBillObj, srcTableDefine, sourceBillObj, srcEntryIdFld);
    }

    private DynamicObject loadSourceBill(TableDefine srcTableDefine, String srcBillID) {
        HashSet<String> selectFields = new HashSet<String>();
        selectFields.add("id");
        selectFields.add(srcTableDefine.getEntityKey() + ".id");
        DynamicObject sourceBillObj = BusinessDataServiceHelper.loadSingle((Object)srcBillID, (String)srcTableDefine.getEntityNumber(), (String)StringUtils.join((Object[])selectFields.toArray(), (String)","));
        return sourceBillObj;
    }

    private void createLinkEntity(TableDefine targetTableDefine, DynamicObject targetBillObj, TableDefine srcTableDefine, DynamicObject sourceBillObj, String srcEntryIdFld) {
        HashSet<String> srcRowIds = new HashSet<String>();
        DynamicObjectCollection srcRows = sourceBillObj.getDynamicObjectCollection(srcTableDefine.getEntityKey());
        for (DynamicObject srcRow : srcRows) {
            srcRowIds.add(srcRow.getString("id"));
        }
        Long srcTableId = srcTableDefine.getTableId();
        Long srcId = sourceBillObj.getLong("id");
        String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
        DynamicObjectCollection targetRows = targetBillObj.getDynamicObjectCollection(targetTableDefine.getEntityKey());
        for (DynamicObject targetRow : targetRows) {
            String srcRowId;
            DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
            if (!linkRows.isEmpty() || EmptyUtil.isEmpty(linkRows.getDynamicObjectType()) || !srcRowIds.contains(srcRowId = targetRow.getString(srcEntryIdFld))) continue;
            DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
            linkRows.add((Object)linkRow);
            linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
            linkRow.set(lkEntryKey + "_sbillid", (Object)srcId);
            linkRow.set(lkEntryKey + "_sid", (Object)srcRowId);
        }
    }
}

