/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.helper.CasHelper;

public class CasPayeeOrPayerHelper {
    public static Map<String, Object> getPayeeOrPayerInfo(Object payeeOrPayer, Object payeeOrPayerType, String billName) {
        DynamicObject supplierCustDO;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String entityNameTemp = "";
        String addressPropName = "";
        if (CasPayeeOrPayerHelper.isSupplier(payeeOrPayerType)) {
            entityNameTemp = AsstActTypeEnum.SUPPLIER.getValue();
            addressPropName = "supplieraddress";
        }
        if (CasPayeeOrPayerHelper.isCustomer(payeeOrPayerType)) {
            entityNameTemp = AsstActTypeEnum.CUSTOMER.getValue();
            addressPropName = "customeraddress";
        }
        Object bankaccount = null;
        DynamicObject payeebank = null;
        String accountname = null;
        if (!(CasHelper.isEmpty(entityNameTemp) || CasHelper.isEmpty(payeeOrPayer) || CasHelper.isEmpty(supplierCustDO = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeOrPayer, (String)entityNameTemp, (String)("entry_bank.isdefault_bank,entry_bank.bankaccount,entry_bank.bank,entry_bank.accountname,entry_address." + addressPropName))))) {
            DynamicObjectCollection addressls;
            DynamicObjectCollection entry_banks = supplierCustDO.getDynamicObjectCollection("entry_bank");
            if (!CasHelper.isEmpty(entry_banks)) {
                for (int i = 0; i < entry_banks.size(); ++i) {
                    if (i != 0 && !((DynamicObject)entry_banks.get(i)).getBoolean("isdefault_bank")) continue;
                    DynamicObject entry_bank = (DynamicObject)entry_banks.get(i);
                    bankaccount = entry_bank.get("bankaccount");
                    payeebank = entry_bank.getDynamicObject("bank");
                    accountname = entry_bank.getLocaleString("accountname").getLocaleValue();
                }
            }
            if (!CasHelper.isEmpty(bankaccount)) {
                if (SourceBillTypeEnum.PAYBILL.getValue().equals(billName)) {
                    resultMap.put("payeebanknum", bankaccount);
                }
                if (SourceBillTypeEnum.RECBILL.getValue().equals(billName)) {
                    resultMap.put("payeracctbanknum", bankaccount);
                }
            }
            if (!CasHelper.isEmpty(payeebank)) {
                if (SourceBillTypeEnum.PAYBILL.getValue().equals(billName)) {
                    resultMap.put("payeebank", payeebank);
                }
                if (SourceBillTypeEnum.RECBILL.getValue().equals(billName)) {
                    resultMap.put("f7_payerbank", payeebank);
                }
            }
            if (!CasHelper.isEmpty(accountname)) {
                if (SourceBillTypeEnum.PAYBILL.getValue().equals(billName)) {
                    resultMap.put("accountname", accountname);
                }
                if (SourceBillTypeEnum.RECBILL.getValue().equals(billName)) {
                    resultMap.put("accountname", accountname);
                }
            } else {
                accountname = supplierCustDO.getLocaleString("name").getLocaleValue();
                resultMap.put("accountname", accountname);
            }
            if ((addressls = supplierCustDO.getDynamicObjectCollection("entry_address")) != null && addressls.size() > 0) {
                HashSet<Object> addressIds = new HashSet<Object>();
                for (DynamicObject a : addressls) {
                    addressIds.add(a.get(addressPropName + "_id"));
                }
                DynamicObject[] addresses = BusinessDataServiceHelper.load((String)"bd_address", (String)"default,detailaddress,addemail", (QFilter[])new QFilter[]{new QFilter("id", "in", addressIds)});
                if (addresses != null) {
                    for (DynamicObject address : addresses) {
                        if (!address.getBoolean("default")) continue;
                        resultMap.put("payeeemail", address.getString("addemail"));
                        resultMap.put("payeeaddress", address.getString("detailaddress"));
                        break;
                    }
                }
            }
        }
        return resultMap;
    }

    private static boolean isSupplier(Object payeeType) {
        return CasPayeeOrPayerHelper.isAimType(AsstActTypeEnum.SUPPLIER, payeeType);
    }

    private static boolean isCustomer(Object payeeType) {
        return CasPayeeOrPayerHelper.isAimType(AsstActTypeEnum.CUSTOMER, payeeType);
    }

    private static boolean isAimType(AsstActTypeEnum asstactType, Object payeeType) {
        return asstactType.getValue().equals(payeeType);
    }
}

