/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.ChgTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.SettleRecordQueryHelperForCas;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class CasPluginHelper {
    private static Log logger = LogFactory.getLog(CasPluginHelper.class);

    public static void getCasQFilter(ListShowParameter listShowParameter, FilterContainerInitArgs args) {
        JSONArray orgIdrange = (JSONArray)listShowParameter.getCustomParam("orgIdrange");
        HashSet<Long> casPayOrgIdSet = new HashSet<Long>(8);
        for (Object ob : orgIdrange) {
            casPayOrgIdSet.add(Long.parseLong(ob.toString()));
        }
        if (null != args) {
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                if ("org.id".equals(filterColumn.getFieldName())) {
                    filterColumn.setDefaultValues(casPayOrgIdSet.toArray());
                }
                if ("bizdate".equals(filterColumn.getFieldName())) {
                    filterColumn.setDefaultValue("");
                }
                if (!"billstatus".equals(filterColumn.getFieldName())) continue;
                filterColumn.setDefaultValue("D");
            }
        }
    }

    public static boolean isTrack(FormShowParameter formShowParameter) {
        Object isTrack = formShowParameter.getCustomParam("isTrack");
        return !EmptyUtil.isEmpty(isTrack) && (Boolean)isTrack != false;
    }

    public static void viewDrafBill(BillList billList, IFormView view, String entity) {
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] selectedRowPks = selectedRows.getPrimaryKeyValues();
        if (selectedRowPks.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CasPluginHelper_3", (String)"fi-cas-common", (Object[])new Object[0]));
        } else if (selectedRowPks.length > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8054\u67e5\u3002", (String)"CasPluginHelper_4", (String)"fi-cas-common", (Object[])new Object[0]));
        } else {
            Object primaryKey = selectedRowPks[0];
            DynamicObject paybill = BusinessDataServiceHelper.loadSingle((Object)primaryKey, (String)entity, (String)"id,draftbill");
            DynamicObjectCollection draftBills = paybill.getDynamicObjectCollection("draftbill");
            if (draftBills == null || draftBills.size() <= 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u7968\u636e\u8bb0\u5f55\u3002", (String)"CasPluginHelper_5", (String)"fi-cas-common", (Object[])new Object[0]));
                return;
            }
            HashSet<Long> idSet = new HashSet<Long>();
            for (DynamicObject draftBill : draftBills) {
                idSet.add(((DynamicObject)draftBill.get("fbasedataid")).getLong("id"));
            }
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("cdm_payandrecdraft_f7");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setLookUp(true);
            QFilter qFilter = new QFilter("id", "in", idSet);
            parameter.getListFilterParameter().getQFilters().add(qFilter);
            view.showForm((FormShowParameter)parameter);
        }
    }

    public static Map<Long, Long> getInternalCompanyMap(String formId, Set<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)formId, (String)"id,internal_company", (QFilter[])filter.toArray());
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(2);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject item : dynamicObjects) {
                DynamicObject orgDo = item.getDynamicObject("internal_company");
                if (orgDo == null) continue;
                idMap.put(item.getLong("id"), orgDo.getLong("id"));
            }
        }
        return idMap;
    }

    public static Boolean cancelCheckSettleForPay(IFormPlugin formPlugin, IFormView view, List<Long> ids, DynamicObjectCollection objs) {
        return CasPluginHelper.cancelCheckSettle(formPlugin, view, ids, objs, "ap_settlerecord", "cas_paybill");
    }

    public static Boolean cancelCheckSettleForRec(IFormPlugin formPlugin, IFormView view, List<Long> ids, DynamicObjectCollection objs) {
        return CasPluginHelper.cancelCheckSettle(formPlugin, view, ids, objs, "ar_settlerecord", "cas_recbill");
    }

    private static Boolean cancelCheckSettle(IFormPlugin formPlugin, IFormView view, List<Long> ids, DynamicObjectCollection billCol, String settleRecordEntity, String entity) {
        Boolean result = Boolean.FALSE;
        List<Long> mainBillIds = SettleRecordQueryHelperForCas.getBillIdsByMain(settleRecordEntity, entity, ids.toArray(), null);
        List<Long> asstBillIds = SettleRecordQueryHelperForCas.getBillIdsByAsst(settleRecordEntity, entity, ids.toArray(), null);
        HashSet<Long> settleRecordIds = new HashSet<Long>();
        settleRecordIds.addAll(mainBillIds);
        settleRecordIds.addAll(asstBillIds);
        if (settleRecordIds.size() > 0) {
            StringBuilder settleSb = new StringBuilder();
            int settleFlag = 0;
            for (DynamicObject obj : billCol) {
                if (!settleRecordIds.contains(obj.getLong("id"))) continue;
                ++settleFlag;
                String billno = obj.getString("billno");
                settleSb.append(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u5b8c\u6210\u7ed3\u7b97\r\n", (String)"CasPluginHelper_0", (String)"fi-cas-common", (Object[])new Object[0]), billno));
            }
            if (settleFlag == 1) {
                String msg = ResManager.loadKDString((String)"%s\u5982\u679c\u7ee7\u7eed\u64cd\u4f5c\u5c06\u4f1a\u81ea\u52a8\u53cd\u7ed3\u7b97\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CasPluginHelper_1", (String)"fi-cas-common", (Object[])new Object[]{settleSb.substring(0, settleSb.length() - 1) + "\uff0c"});
                view.showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_SETTLE_CALLBACK", formPlugin));
            } else if (settleFlag > 1) {
                view.showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728%d\u4e2a\u5df2\u7ecf\u5b8c\u6210\u7ed3\u7b97\u7684\u5355\u636e\uff0c\u5982\u679c\u7ee7\u7eed\u64cd\u4f5c\u5c06\u4f1a\u81ea\u52a8\u53cd\u7ed3\u7b97\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CasPluginHelper_2", (String)"fi-cas-common", (Object[])new Object[0]), settleFlag), settleSb.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_SETTLE_CALLBACK", formPlugin));
            }
            result = Boolean.TRUE;
        }
        return result;
    }

    public static Boolean cancelCheckSettleForPay(IFormPlugin formPlugin, IFormView view, DynamicObject bill) {
        return CasPluginHelper.cancelCheckSettle(formPlugin, view, bill, "ap_settlerecord", "cas_paybill");
    }

    public static Boolean cancelCheckSettleForRec(IFormPlugin formPlugin, IFormView view, DynamicObject bill) {
        return CasPluginHelper.cancelCheckSettle(formPlugin, view, bill, "ar_settlerecord", "cas_recbill");
    }

    private static Boolean cancelCheckSettle(IFormPlugin formPlugin, IFormView view, DynamicObject bill, String settleRecordEntity, String entity) {
        Boolean result = Boolean.FALSE;
        boolean exists = SettleRecordQueryHelperForCas.isExistsSettlesByMain(settleRecordEntity, entity, new Object[]{bill.getPkValue()}, null);
        boolean exists2 = SettleRecordQueryHelperForCas.isExistsSettlesByAsst(settleRecordEntity, entity, new Object[]{bill.getPkValue()}, null);
        if (exists || exists2) {
            StringBuilder settleSb = new StringBuilder();
            String billno = bill.getString("billno");
            settleSb.append(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u5b8c\u6210\u7ed3\u7b97", (String)"CasPluginHelper_6", (String)"fi-cas-common", (Object[])new Object[0]), billno));
            view.showConfirm(settleSb.append("\uff0c").append(ResManager.loadKDString((String)"\u5982\u679c\u7ee7\u7eed\u64cd\u4f5c\u5c06\u4f1a\u81ea\u52a8\u53cd\u7ed3\u7b97\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CasPluginHelper_7", (String)"fi-cas-common", (Object[])new Object[0])).toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_SETTLE_CALLBACK", formPlugin));
            result = Boolean.TRUE;
        }
        return result;
    }

    public static void viewSettleForPay(BillList billList, IFormView view) {
        CasPluginHelper.viewSettle(billList, view, "ap_settlerecord", "cas_paybill");
    }

    public static void viewSettleForRec(BillList billList, IFormView view) {
        CasPluginHelper.viewSettle(billList, view, "ar_settlerecord", "cas_recbill");
    }

    private static void viewSettle(BillList billList, IFormView view, String settleRecordEntity, String entityKey) {
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] selectedRowPks = selectedRows.getPrimaryKeyValues();
        if (selectedRowPks.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CasPluginHelper_3", (String)"fi-cas-common", (Object[])new Object[0]));
        } else {
            Set selectedPrimaryKeys = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            Set<Long> mainSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByMain(settleRecordEntity, entityKey, selectedPrimaryKeys.toArray());
            Set<Long> asstSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByAsst(settleRecordEntity, entityKey, selectedPrimaryKeys.toArray());
            HashSet<Long> settleRecordIds = new HashSet<Long>();
            settleRecordIds.addAll(mainSettleIds);
            settleRecordIds.addAll(asstSettleIds);
            if (settleRecordIds.size() > 0) {
                ListShowParameter parameter = new ListShowParameter();
                parameter.setBillFormId(settleRecordEntity);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                ListFilterParameter param = new ListFilterParameter();
                param.setFilter(new QFilter("id", "in", settleRecordIds));
                parameter.setListFilterParameter(param);
                parameter.setCustomParam("checkKey", (Object)Boolean.TRUE);
                view.showForm((FormShowParameter)parameter);
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"CasPluginHelper_8", (String)"fi-cas-common", (Object[])new Object[0]));
            }
        }
    }

    public static void trackdownChgBill(IFormView view) {
        BillList list = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        Object[] selectedIds = selectedRows.getPrimaryKeyValues();
        if (selectedIds.length != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CasPluginHelper_9", (String)"fi-cas-common", (Object[])new Object[0]));
            return;
        }
        Object[] paychgbill = BusinessDataServiceHelper.load((String)"cas_paychgbill", (String)"id,chgtype", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", selectedIds[0])});
        if (EmptyUtil.isEmpty(paychgbill) || paychgbill.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6b64\u5355\u65e0\u53d8\u66f4\u5355\u3002", (String)"CasPluginHelper_10", (String)"fi-cas-common", (Object[])new Object[0]));
            return;
        }
        int length = paychgbill.length;
        if (length == 1) {
            String formId = "";
            formId = ChgTypeEnum.RECCHG.getValue().equals(paychgbill[0].getString("chgtype")) ? "cas_paychgbill_recchg" : "cas_paychgbill_paychg";
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(formId);
            showParameter.setPkId(paychgbill[0].getPkValue());
            showParameter.getOpenStyle().setShowType(ShowType.NonModal);
            view.showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setHasRight(true);
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId("cas_paychgbill");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            HashSet<Object> pks = new HashSet<Object>(paychgbill.length);
            for (Object targetBill : paychgbill) {
                pks.add(targetBill.get("id"));
            }
            qFilters.add(new QFilter("id", "in", pks));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            showParameter.setCustomParam("istmctracebillop", (Object)"yes");
            view.showForm((FormShowParameter)showParameter);
        }
    }

    public static void createShowDynForm(String formId, Map<String, Object> map, AbstractFormPlugin plugin, String actionId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(formId);
        parameter.getCustomParams().putAll(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm(parameter);
    }

    public static boolean isFromControlCenter(IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object isUnTreated = formShowParameter.getCustomParam("isUnTreated");
        return !EmptyUtil.isEmpty(isUnTreated) && (Boolean)isUnTreated != false;
    }

    public static void viewBatchInput(IFormView view, String formId, String title) {
        FormShowParameter showPage = new FormShowParameter();
        showPage.setFormId(formId);
        showPage.setAppId("cas");
        showPage.setStatus(OperationStatus.EDIT);
        showPage.getOpenStyle().setShowType(ShowType.Modal);
        if (EmptyUtil.isNoEmpty(title)) {
            showPage.setCaption(title);
        }
        view.showForm(showPage);
    }

    public static void viewBatchInput(IFormView view, String formId) {
        CasPluginHelper.viewBatchInput(view, formId, null);
    }

    public static void chargeBack(IFormPlugin formPlugin, IFormView view, Object billid, String closeCallBackFlag) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_chargeback");
        showParameter.setCustomParam("billid", billid);
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setCloseCallBack(new CloseCallBack(formPlugin, closeCallBackFlag));
        view.showForm(showParameter);
    }

    public static boolean isExistOnlineNetBank(DynamicObject acctBank) {
        if (null != acctBank) {
            DynamicObjectCollection onlineBankAccts = acctBank.getDynamicObjectCollection("netbank");
            return null != onlineBankAccts && onlineBankAccts.size() != 0;
        }
        return false;
    }

    public static void filterNetBankAcct(BasedataEdit onlineBankAcct, DynamicObject acctBank) {
        onlineBankAcct.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection onlineBankAccts;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<Long> ids = new ArrayList<Long>();
            if (null != acctBank && null != (onlineBankAccts = acctBank.getDynamicObjectCollection("netbank")) && onlineBankAccts.size() > 0) {
                for (DynamicObject bankAcct : onlineBankAccts) {
                    ids.add((Long)bankAcct.getDynamicObject("fbasedataid").getPkValue());
                }
            }
            if (ids.size() == 0) {
                ids.add(0L);
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    public static boolean batchDealRec(Set<Long> recSelectDraftProcessDySet, DynamicObject[] dbDatas) {
        HashSet<String> currNumSet = new HashSet<String>(16);
        HashSet<Long> settleTypeSet = new HashSet<Long>(16);
        HashSet<String> peyerTypeSet = new HashSet<String>(16);
        HashSet<String> payerNameSet = new HashSet<String>(16);
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        HashSet<DynamicObject> hasDraftRecBillSet = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> noDraftRecBillSet = new HashSet<DynamicObject>(16);
        String payOrRec = dbDatas[0].getDataEntityType().getName();
        for (DynamicObject casRecBill : dbDatas) {
            DynamicObject currency = casRecBill.getDynamicObject("currency");
            DynamicObject settletype = casRecBill.getDynamicObject("settletype");
            String payername = "";
            String payertype = "";
            String paramKey = "";
            String billstatus = casRecBill.getString("billstatus");
            if (!"C".equals(billstatus)) {
                return true;
            }
            if (EmptyUtil.isNoEmpty(settletype)) {
                if ("cas_paybill".equals(payOrRec)) {
                    payername = casRecBill.getString("payeename");
                    payertype = casRecBill.getString("payeetype");
                    paramKey = "cs122";
                } else if ("cas_recbill".equals(payOrRec)) {
                    payername = casRecBill.getString("payername");
                    payertype = casRecBill.getString("payertype");
                    paramKey = "cs123";
                }
                String settleTypeBizType = settletype.getString("settlementtype");
                long settleTypeId = settletype.getLong("id");
                if (!(SettleMentTypeEnum.BUSINESS.getValue().equals(settleTypeBizType) || SettleMentTypeEnum.BANK.getValue().equals(settleTypeBizType) || SettleMentTypeEnum.CHECK.getValue().equals(settleTypeBizType))) {
                    return true;
                }
                DynamicObject orgData = casRecBill.getDynamicObject("org");
                long pkValue = orgData.getLong("id");
                boolean isOpenUseDraftParams = PaymentBillPluginHelper.needSelectedDraft(casRecBill);
                boolean selectDraftFlag = SystemParameterHelper.getParameterBoolean(pkValue, paramKey);
                if (isOpenUseDraftParams && selectDraftFlag) {
                    DynamicObjectCollection draftColl = casRecBill.getDynamicObjectCollection("draftbill");
                    if (EmptyUtil.isNoEmpty(draftColl) && draftColl.size() > 0) {
                        boolean isAllPayDrafBill;
                        if ("cas_paymentbill".equals(payOrRec) && !(isAllPayDrafBill = DraftHelper.isAllPayDrafBill(draftColl))) {
                            return true;
                        }
                        hasDraftRecBillSet.add(casRecBill);
                    } else {
                        noDraftRecBillSet.add(casRecBill);
                    }
                    if (hasDraftRecBillSet.size() > 0 && noDraftRecBillSet.size() > 0) {
                        return true;
                    }
                    if (hasDraftRecBillSet.size() > 0 && noDraftRecBillSet.size() == 0 || hasDraftRecBillSet.size() != 0 || noDraftRecBillSet.size() <= 0) continue;
                    String number = currency.getString("number");
                    if (EmptyUtil.isEmpty(currNumSet) || currNumSet.size() == 0) {
                        currNumSet.add(number);
                    } else if (!currNumSet.contains(number)) {
                        return true;
                    }
                    if (EmptyUtil.isEmpty(orgIdSet) || orgIdSet.size() == 0) {
                        orgIdSet.add(pkValue);
                    } else if (!orgIdSet.contains(pkValue)) {
                        return true;
                    }
                    if (EmptyUtil.isEmpty(settleTypeSet) || settleTypeSet.size() == 0) {
                        settleTypeSet.add(settleTypeId);
                    } else if (!settleTypeSet.contains(settleTypeId)) {
                        return true;
                    }
                    if (EmptyUtil.isEmpty(peyerTypeSet) || peyerTypeSet.size() == 0) {
                        peyerTypeSet.add(payertype);
                    } else if (!peyerTypeSet.contains(payertype)) {
                        return true;
                    }
                    if (EmptyUtil.isEmpty(payerNameSet) || payerNameSet.size() == 0) {
                        payerNameSet.add(payername);
                    } else if (!payerNameSet.contains(payername)) {
                        return true;
                    }
                    recSelectDraftProcessDySet.add(casRecBill.getLong("id"));
                    continue;
                }
                return true;
            }
            return true;
        }
        return false;
    }
}

