/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.helper.LspWapper;
import kd.fi.cas.util.EmptyUtil;
import kd.sdk.fi.cas.extpoint.dynamiclisthelper.IDynamicListHelper;

public class DynamicListHelper {
    public static final String appId = "cas";

    public static ListShowParameter createDynamicListShowParameter(String entity, String entry, List<String> showFields) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entity, (boolean)false, (int)2);
        lsp.setCustomParam("entity", (Object)entity);
        lsp.setCustomParam("entry", (Object)entry);
        lsp.setCustomParam("isEntryMain", (Object)Boolean.TRUE);
        lsp.setCustomParam("showFields", showFields);
        LspWapper lspWapper = new LspWapper(lsp);
        lspWapper.clearPlugins();
        lspWapper.registerScript("kingdee.fi.cas.page.dynamiclistscriptplugin");
        lspWapper.setMergeRow(false);
        lsp.setAppId(appId);
        return lsp;
    }

    public static List<String> getShowFieldsForSupplierBankInfo(List<String> showFields) {
        PluginProxy pluginProxy = PluginProxy.create(IDynamicListHelper.class, (String)"kd.sdk.fi.cas.extpoint.dynamiclisthelper.IDynamicListHelper.setShowFieldsForSupplierBankInfo");
        List lists = pluginProxy.callReplace(o -> o.setShowFieldsForSupplierBankInfo(showFields));
        if (EmptyUtil.isNoEmpty(lists) && EmptyUtil.isNoEmpty(lists.get(0))) {
            return (List)lists.get(0);
        }
        return showFields;
    }

    public static List<String> getShowFieldsForCustomerBankInfo(List<String> showFields) {
        PluginProxy pluginProxy = PluginProxy.create(IDynamicListHelper.class, (String)"kd.sdk.fi.cas.extpoint.dynamiclisthelper.IDynamicListHelper.setShowFieldsForCustomerBankInfo");
        List lists = pluginProxy.callReplace(o -> o.setShowFieldsForCustomerBankInfo(showFields));
        if (EmptyUtil.isNoEmpty(lists) && EmptyUtil.isNoEmpty(lists.get(0))) {
            return (List)lists.get(0);
        }
        return showFields;
    }

    public static ListShowParameter getSupplierBankInfoShowParameter(Object pk) {
        List<String> showFields = new ArrayList<String>();
        showFields.add("bank.name");
        showFields.add("bankaccount");
        showFields.add("accountname");
        showFields.add("currency.name");
        showFields.add("isdefault_bank");
        showFields.add("agentbank");
        showFields.add("agentbankaccount");
        showFields = DynamicListHelper.getShowFieldsForSupplierBankInfo(showFields);
        ListShowParameter lsp = DynamicListHelper.createDynamicListShowParameter("bd_supplier", "entry_bank", showFields);
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(new QFilter("id", "=", pk));
        lsp.setListFilterParameter(lfp);
        lsp.setCaption(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546-\u94f6\u884c\u4fe1\u606f", (String)"DynamicListHelper_0", (String)"fi-cas-common", (Object[])new Object[0]));
        return lsp;
    }

    public static ListShowParameter getCustomerBankInfoShowParameter(Object pk) {
        List<String> showFields = new ArrayList<String>();
        showFields.add("bank.name");
        showFields.add("bankaccount");
        showFields.add("accountname");
        showFields.add("currency.name");
        showFields.add("isdefault_bank");
        showFields = DynamicListHelper.getShowFieldsForCustomerBankInfo(showFields);
        ListShowParameter lsp = DynamicListHelper.createDynamicListShowParameter("bd_customer", "entry_bank", showFields);
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(new QFilter("id", "=", pk));
        lsp.setListFilterParameter(lfp);
        lsp.setCaption(ResManager.loadKDString((String)"\u5ba2\u6237-\u94f6\u884c\u4fe1\u606f", (String)"DynamicListHelper_1", (String)"fi-cas-common", (Object[])new Object[0]));
        return lsp;
    }

    public static ListShowParameter getSupplierBankInfoHWShowParameter(Object pk) {
        ArrayList<String> showFields = new ArrayList<String>();
        showFields.add("bank.name");
        showFields.add("bankaccount");
        showFields.add("accountname");
        showFields.add("currency.name");
        showFields.add("isdefault_bank");
        ListShowParameter lsp = DynamicListHelper.createDynamicListShowParameter("bd_suppliersite", "entry_bank", showFields);
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(new QFilter("id", "=", pk));
        lsp.setListFilterParameter(lfp);
        lsp.setCaption(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546-\u94f6\u884c\u4fe1\u606f", (String)"DynamicListHelper_0", (String)"fi-cas-common", (Object[])new Object[0]));
        return lsp;
    }

    public static ListShowParameter getCustomerBankInfoHWShowParameter(Object pk) {
        ArrayList<String> showFields = new ArrayList<String>();
        showFields.add("bank.name");
        showFields.add("bankaccount");
        showFields.add("accountname");
        showFields.add("currency.name");
        showFields.add("isdefault_bank");
        ListShowParameter lsp = DynamicListHelper.createDynamicListShowParameter("bd_customersite", "entry_bank", showFields);
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(new QFilter("id", "=", pk));
        lsp.setListFilterParameter(lfp);
        lsp.setCaption(ResManager.loadKDString((String)"\u5ba2\u6237-\u94f6\u884c\u4fe1\u606f", (String)"DynamicListHelper_1", (String)"fi-cas-common", (Object[])new Object[0]));
        return lsp;
    }

    public static void fillEntryList(String entryName, AbstractFormDataModel model, List<Map<String, Object>> dataList) {
        DynamicListHelper.fillEntryList(entryName, model, dataList, false);
    }

    public static void fillEntryList(String entryName, AbstractFormDataModel model, List<Map<String, Object>> dataList, boolean clearOld) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        if (clearOld) {
            model.deleteEntryData(entryName);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (Map<String, Object> data : dataList) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof DynamicObject) {
                    value = ((DynamicObject)value).getPkValue();
                }
                vs.addField(entry.getKey(), new Object[]{value});
            }
        }
        model.batchCreateNewEntryRow(entryName, vs);
    }
}

