/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.fcm.mservice.CheckItemDetail;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.ClosePeriodUtils;
import kd.fi.cas.util.EmptyUtil;

public class FinalCheckOutHelper {
    private static Log logger = LogFactory.getLog(FinalCheckOutHelper.class);

    private FinalCheckOutHelper() {
    }

    public static FinalCheckOutHelper getInstance() {
        return Singleton.instance;
    }

    public Boolean toCreateBalanceAdjust(DynamicObject finalCheckout, boolean isClosePeriod) {
        DynamicObject currentPeriod = finalCheckout.getDynamicObject("period");
        logger.info("--->>> FinalCheckOutHelper.toCreateBalanceAdjust(),currentPeriod={}", (Object)currentPeriod);
        DynamicObject org = finalCheckout.getDynamicObject("org");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod", (QFilter[])new QFilter[]{filter});
        if (EmptyUtil.isEmpty(dynamicObject)) {
            return false;
        }
        DynamicObject recPeriod = dynamicObject.getDynamicObject("recperiod");
        long orgId = org.getLong("id");
        Boolean permitCloseAccount = isClosePeriod ? this.checkItemIsEffective(orgId) : SystemParameterHelper.getParameterBoolean(orgId, "cs093");
        logger.info("--->>> FinalCheckOutHelper.toCreateBalanceAdjust(),recPeriod={},permitCloseAccount={}", (Object)recPeriod, (Object)permitCloseAccount);
        if (PeriodHelper.before(currentPeriod, recPeriod)) {
            return false;
        }
        if (!permitCloseAccount.booleanValue() && (PeriodHelper.after(currentPeriod, recPeriod) || PeriodHelper.equal(currentPeriod, recPeriod))) {
            return false;
        }
        if (permitCloseAccount.booleanValue() && PeriodHelper.after(currentPeriod, recPeriod)) {
            logger.info("--->>> FinalCheckOutHelper.toCreateBalanceAdjust,cs093=true,currentPeriod>recPeriod");
            return true;
        }
        if (permitCloseAccount.booleanValue() && PeriodHelper.equal(currentPeriod, recPeriod)) {
            logger.info("--->>> FinalCheckOutHelper.toCreateBalanceAdjust,cs093=true currentPeriod=recPeriod");
            return true;
        }
        return false;
    }

    private boolean checkItemIsEffective(long orgId) {
        List<CheckItemDetail> checkItems = ClosePeriodUtils.getCheckItemList(orgId, null);
        if (checkItems.isEmpty()) {
            return false;
        }
        return checkItems.stream().filter(v -> "4.1-CheckWithFinishInitChecker".equals(v.getNumber())).findFirst().get().getIsEffective();
    }

    public Boolean isFinishInit(DynamicObject finalCheckout, boolean isClosePeriod) {
        boolean permitCloseAccount;
        DynamicObject org = finalCheckout.getDynamicObject("org");
        long orgId = org.getLong("id");
        boolean bl = permitCloseAccount = isClosePeriod ? this.checkItemIsEffective(orgId) : SystemParameterHelper.getParameterBoolean(orgId, "cs093");
        if (!permitCloseAccount) {
            return true;
        }
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod", (QFilter[])new QFilter[]{filter});
        if (EmptyUtil.isEmpty(dynamicObject)) {
            return true;
        }
        DynamicObject recPeriod = dynamicObject.getDynamicObject("recperiod");
        filter.and(new QFilter("initperiod", "=", recPeriod.getPkValue()));
        DynamicObject recInitObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_init", (String)"id, isfinishinit", (QFilter[])new QFilter[]{filter});
        if (EmptyUtil.isEmpty(recInitObject)) {
            return false;
        }
        return recInitObject.getBoolean("isfinishinit");
    }

    static class Singleton {
        private static final FinalCheckOutHelper instance = new FinalCheckOutHelper();

        Singleton() {
        }
    }
}

