/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.mutex.impl.DataLocker;

public class MutexLockerHelper
implements AutoCloseable {
    private static final Log logger = LogFactory.getLog(MutexLockerHelper.class);
    private DataLocker iLocker;
    private String batchID = this.getBatchID();

    public MutexLockerHelper(String entityKey, String operationKey) {
        this.iLocker = new DataLocker(this.batchID, entityKey, operationKey);
    }

    private String getBatchID() {
        String batchID = null;
        batchID = UUID.randomUUID().toString();
        return batchID;
    }

    public Map<String, Boolean> batchRequire(List<String> idList) {
        return this.iLocker.batchLock(idList);
    }

    public void batchRelease(List<String> idList) {
        this.iLocker.batchUnlock(idList);
    }

    public boolean require(String pk) {
        return this.iLocker.lock(pk);
    }

    public void release(String pk) {
        this.iLocker.unlock(pk);
    }

    @Override
    public void close() {
        logger.info("auto release bizLock");
        if (this.iLocker != null) {
            this.iLocker.doRelease(null);
        }
    }
}

