/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.param.ClaimNoticeMesParam;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class PayInfoChgHelper {
    public static void saveChangeChg(IFormView view, String btnGroup, Map<String, Object> data) {
        String sourcetype = view.getFormShowParameter().getFormId();
        if (view.getFormShowParameter() instanceof ListShowParameter) {
            sourcetype = ((ListShowParameter)view.getFormShowParameter()).getBillFormId();
        }
        Object userField = data.get("userField");
        String changeCause = (String)data.get("changeCause");
        Object billNo = data.get("billNo");
        Object billName = data.get("billName");
        Object creator = data.get("creator");
        String sourceAction = (String)data.get("sourceAction");
        BillList billList = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Long sourceId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject bizBill = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)sourcetype);
        DynamicObjectCollection entry = bizBill.getDynamicObjectCollection("entry");
        Object selectEntryRowStr = data.get("selectEntryRows");
        List selectEntryRows = new ArrayList(10);
        if (!EmptyUtil.isEmpty(selectEntryRowStr)) {
            selectEntryRows = JSONArray.parseArray((String)selectEntryRowStr.toString(), Object.class);
        }
        ArrayList<DynamicObject> selectAgtEntryDo = new ArrayList<DynamicObject>();
        for (DynamicObject rowDO : entry) {
            if (selectEntryRows.size() >= 1 && !selectEntryRows.contains(rowDO.getPkValue())) continue;
            selectAgtEntryDo.add(rowDO);
        }
        DynamicObject payChgBillObj = BusinessDataServiceHelper.newDynamicObject((String)"cas_paychgbill");
        payChgBillObj.set("billstatus", (Object)"A");
        payChgBillObj.set("sourcebillno", bizBill.get("billno"));
        if ("payAction".equalsIgnoreCase(sourceAction)) {
            payChgBillObj.set("chgtype", (Object)"paychg");
        } else {
            payChgBillObj.set("chgtype", (Object)"recchg");
        }
        payChgBillObj.set("sourcetype", (Object)sourcetype);
        payChgBillObj.set("sourcebilltype", (Object)sourcetype);
        payChgBillObj.set("sourcebillid", (Object)sourceId);
        payChgBillObj.set("org", bizBill.getDynamicObject("org") == null ? null : bizBill.getDynamicObject("org"));
        payChgBillObj.set("sourcecurrency", (Object)bizBill.getDynamicObject("currency").getLong("id"));
        payChgBillObj.set("applyuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
        payChgBillObj.set("remark", (Object)changeCause);
        Object alterationUser = "B".equals(btnGroup) ? creator : userField;
        payChgBillObj.set("alterationuser", alterationUser);
        payChgBillObj.set("billname", billName);
        payChgBillObj.set("billscode", billNo);
        payChgBillObj.set("chgdate", (Object)DateUtils.getCurrentDate());
        boolean needEncrypVisable = PayInfoChgHelper.isNeedEncrypVisable(bizBill);
        DynamicObjectCollection entryObjCol = payChgBillObj.getDynamicObjectCollection("entrys");
        if ("payAction".equalsIgnoreCase(sourceAction)) {
            DynamicObject entryObj = entryObjCol.addNew();
            entryObj.set("Seq", (Object)0);
            entryObj.set("paychannel", bizBill.get("paymentchannel"));
            DynamicObject settletypeObj = bizBill.getDynamicObject("settletype");
            Long settletype = null;
            if (!EmptyUtil.isEmpty(settletypeObj)) {
                settletype = (Long)settletypeObj.getPkValue();
            }
            entryObj.set("settletype", (Object)settletype);
            entryObj.set("settletnumber", (Object)bizBill.getString("settletnumber"));
            if (BaseDataHelper.isSettleTypeCash(settletypeObj)) {
                DynamicObject payeracctcashObj = bizBill.getDynamicObject("accountcash");
                Long payeracctcash = null;
                if (!EmptyUtil.isEmpty(payeracctcashObj)) {
                    payeracctcash = (Long)payeracctcashObj.getPkValue();
                }
                entryObj.set("payeracctcash", (Object)payeracctcash);
            } else {
                DynamicObject payeracctbankObj = bizBill.getDynamicObject("payeracctbank");
                Long payeracctbank = null;
                if (!EmptyUtil.isEmpty(payeracctbankObj)) {
                    payeracctbank = (Long)payeracctbankObj.getPkValue();
                }
                entryObj.set("payeracctbank", (Object)payeracctbank);
            }
            DynamicObject payerbankObj = bizBill.getDynamicObject("payerbank");
            Long payerbank = null;
            if (!EmptyUtil.isEmpty(payerbankObj)) {
                payerbank = (Long)payerbankObj.getPkValue();
            }
            entryObj.set("payerbank", (Object)payerbank);
            entryObj.set("actpayamt", bizBill.get("payamount"));
            entryObj.set("bizdate", bizBill.get("bizdate"));
            String businessType = bizBill.getString("businesstype");
            entryObj.set("businesstype", (Object)businessType);
            if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                entryObj.set("institutioncode", bizBill.get("institutioncode"));
                entryObj.set("institutionname", bizBill.get("institutionname"));
            }
        } else {
            int seq = 0;
            for (DynamicObject selectAgtEntry : selectAgtEntryDo) {
                DynamicObject entryObj = entryObjCol.addNew();
                entryObj.set("actpayamt", (Object)(needEncrypVisable ? new BigDecimal("0") : selectAgtEntry.getBigDecimal("e_amount")));
                entryObj.set("recer", (Object)(EmptyUtil.isEmpty(selectAgtEntry.get("payee")) ? "" : selectAgtEntry.getDynamicObject("payee").getString("name")));
                entryObj.set("recername", selectAgtEntry.get("payeename"));
                entryObj.set("recacctbank", selectAgtEntry.get("payeeacctbank"));
                entryObj.set("payeebankname", selectAgtEntry.get("payeebankname"));
                entryObj.set("usage", selectAgtEntry.get("e_remark"));
                entryObj.set("payeetype", selectAgtEntry.get("importpayeetype"));
                entryObj.set("sourceentryid", selectAgtEntry.getPkValue());
                entryObj.set("recerid", selectAgtEntry.getDynamicObject("payee") == null ? null : selectAgtEntry.getDynamicObject("payee").getPkValue());
                entryObj.set("recprovince", selectAgtEntry.get("recprovince"));
                entryObj.set("reccity", selectAgtEntry.get("reccity"));
                entryObj.set("recbanknumber", selectAgtEntry.get("payeebanknumber"));
                entryObj.set("Seq", (Object)seq++);
            }
        }
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"save", (String)"cas_paychgbill", (DynamicObject[])new DynamicObject[]{payChgBillObj}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            HashMap<String, Object> payChgMap = new HashMap<String, Object>();
            payChgMap.put("id", operationResult.getSuccessPkIds().get(0));
            payChgMap.put("btnGroup", btnGroup);
            payChgMap.put("changeCause", changeCause);
            payChgMap.put("alterationUser", alterationUser);
            payChgMap.put("billName", billName);
            payChgMap.put("billNo", billNo);
            Long messageId = PayInfoChgHelper.sendNoticeMessage(payChgMap);
            if (null != messageId) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u901a\u77e5\u6210\u529f\uff0c\u53ef\u5728\u652f\u4ed8\u4fe1\u606f\u53d8\u66f4\u5217\u8868\u67e5\u770b\u53d8\u66f4\u8fdb\u5ea6", (String)"PayInfoChgHelper_0", (String)"fi-cas-common", (Object[])new Object[0]), Integer.valueOf(4000));
            }
        }
    }

    public static Long sendNoticeMessage(Map<String, Object> payChgMap) {
        ClaimNoticeMesParam param = new ClaimNoticeMesParam();
        param.setTag(ResManager.loadKDString((String)"\u6536\u6b3e\u53d8\u66f4", (String)"PayInfoChgHelper_1", (String)"fi-cas-common", (Object[])new Object[0]));
        param.setTitle(ResManager.loadKDString((String)"1\u7b14\u4e1a\u52a1\u652f\u4ed8\u5931\u8d25\uff0c\u9700\u8981\u91cd\u65b0\u786e\u8ba4\u6536\u6b3e\u65b9\u4fe1\u606f\u5e76\u5b8c\u6210\u53d8\u66f4\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406", (String)"PayInfoChgHelper_2", (String)"fi-cas-common", (Object[])new Object[0]));
        if ("B".equals(payChgMap.get("btnGroup"))) {
            param.setContent(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u7531\u4e8e\u3010%3$s\u3011\uff0c\u5bfc\u81f4\u4ed8\u6b3e\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u540e\u586b\u5199\u5230\u53d8\u66f4\u540e\u4fe1\u606f\u4e2d", (String)"PayInfoChgHelper_3", (String)"fi-cas-common", (Object[])new Object[0]), payChgMap.get("billName"), payChgMap.get("billNo"), payChgMap.get("changeCause")));
        } else if ("C".equals(payChgMap.get("btnGroup"))) {
            param.setContent(String.format(ResManager.loadKDString((String)"\u7531\u4e8e\u3010%s\u3011\uff0c\u5bfc\u81f4\u4ed8\u6b3e\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u540e\u586b\u5199\u5230\u53d8\u66f4\u540e\u4fe1\u606f\u4e2d", (String)"PayInfoChgHelper_4", (String)"fi-cas-common", (Object[])new Object[0]), payChgMap.get("changeCause")));
        }
        param.setNoticeType("payInfoChg");
        DynamicObject alterationUserObj = (DynamicObject)payChgMap.get("alterationUser");
        Long userIds = (Long)alterationUserObj.getPkValue();
        param.setUserIds(Collections.singleton(userIds));
        param.setPkId((Long)payChgMap.get("id"));
        return RecClaimHelper.sendNoticeMessage(param);
    }

    public static boolean isNeedEncrypVisable(DynamicObject agentBill) {
        return agentBill.getBoolean("isencryption");
    }

    public static void reWriteAgtEntryInfo(DynamicObject sourceBizBill, DynamicObjectCollection chgBillEntrys) {
        DynamicObjectCollection entry = sourceBizBill.getDynamicObjectCollection("entry");
        for (DynamicObject chgRowData : chgBillEntrys) {
            for (DynamicObject agtEntryRow : entry) {
                DynamicObject afterrecerbank;
                String afterrecacctbank;
                if (!agtEntryRow.getPkValue().equals(chgRowData.getLong("sourceentryid"))) continue;
                Object afterrecername = chgRowData.get("afterrecername");
                Object afterusage = chgRowData.get("afterusage");
                if (!CasHelper.isEmpty(afterrecername)) {
                    agtEntryRow.set("payeename", afterrecername);
                }
                if (!CasHelper.isEmpty(afterusage)) {
                    agtEntryRow.set("e_remark", afterusage);
                }
                if (!CasHelper.isEmpty(afterrecacctbank = chgRowData.getString("changerecacctbank"))) {
                    agtEntryRow.set("payeeacctbank", (Object)afterrecacctbank);
                }
                if (CasHelper.isEmpty(afterrecerbank = chgRowData.getDynamicObject("afterrecerbank"))) continue;
                DynamicObject bebank = BusinessDataServiceHelper.loadSingleFromCache((Object)afterrecerbank.getPkValue(), (String)"bd_bebank");
                if (CasHelper.isNotEmpty(bebank)) {
                    agtEntryRow.set("payeebank", bebank.getPkValue());
                    agtEntryRow.set("payeebankname", (Object)bebank.getLocaleString("name").getLocaleValue());
                    agtEntryRow.set("payeebanknumber", (Object)bebank.getString("union_number"));
                    agtEntryRow.set("reccountry", bebank.getDynamicObject("country") == null ? null : bebank.getDynamicObject("country").getPkValue());
                    agtEntryRow.set("recprovince", (Object)(bebank.getDynamicObject("province") == null ? "" : bebank.getDynamicObject("province").getString("name")));
                    agtEntryRow.set("reccity", (Object)(bebank.getDynamicObject("city") == null ? "" : bebank.getDynamicObject("city").getString("name")));
                    agtEntryRow.set("recswiftcode", (Object)bebank.getString("swift_code"));
                    agtEntryRow.set("recroutingnum", (Object)bebank.getString("routingnum"));
                    agtEntryRow.set("recothercode", (Object)bebank.getString("other_code"));
                    agtEntryRow.set("recbankaddress", (Object)bebank.getString("address_eng"));
                }
                agtEntryRow.set("recprovince", (Object)chgRowData.getString("afterrecprovince"));
                agtEntryRow.set("reccity", (Object)chgRowData.getString("afterreccity"));
                agtEntryRow.set("payeebanknumber", (Object)chgRowData.getString("afterrecbanknumber"));
            }
        }
    }

    public static boolean payInfoChanged(DynamicObject payChgBill) {
        String sourceType = payChgBill.getString("sourcetype");
        if (!"cas_agentpaybill".equals(sourceType) && !"cas_paybill".equals(sourceType)) {
            return true;
        }
        DynamicObjectCollection entryList = payChgBill.getDynamicObjectCollection("entrys");
        String chgType = payChgBill.getString("chgtype");
        if ("paychg".equals(chgType)) {
            return entryList.stream().anyMatch(entry -> {
                Object afterbizdate = entry.get("afterbizdate");
                Object afterpaychannel = entry.get("afterpaychannel");
                Object afterpayeracctbank = entry.get("afterpayeracctbank");
                Object afterpayeracctcash = entry.get("afterpayeracctcash");
                Object aftersettletype = entry.get("aftersettletype");
                Object aftersettletnumber = entry.get("aftersettletnumber");
                Object afterpayerbank = entry.get("afterpayerbank");
                Object afterusage = entry.get("afterusage");
                Object afterinstitutioncode = entry.get("afterinstitutioncode");
                Object afterinstitutionname = entry.get("afterinstitutionname");
                boolean iscombinerecord = entry.getBoolean("iscombinerecord");
                boolean isaftercombinerecord = entry.getBoolean("isaftercombinerecord");
                return EmptyUtil.isNoEmpty(afterbizdate) || EmptyUtil.isNoEmpty(afterpaychannel) || EmptyUtil.isNoEmpty(afterpayeracctbank) || EmptyUtil.isNoEmpty(afterpayeracctcash) || EmptyUtil.isNoEmpty(aftersettletype) || EmptyUtil.isNoEmpty(aftersettletnumber) || EmptyUtil.isNoEmpty(afterpayerbank) || iscombinerecord != isaftercombinerecord || EmptyUtil.isNoEmpty(afterusage) || EmptyUtil.isNoEmpty(afterinstitutioncode) || EmptyUtil.isNoEmpty(afterinstitutionname);
            });
        }
        if ("recchg".equals(chgType)) {
            return entryList.stream().allMatch(entry -> {
                Object afterRecerName = entry.get("afterrecername");
                Object changeRecacctBank = entry.get("changerecacctbank");
                String afterRecerBank = entry.getString("afterrecerbankname");
                Object afterUsage = entry.get("afterusage");
                Object afterinstitutioncode = entry.get("afterinstitutioncode");
                Object afterinstitutionname = entry.get("afterinstitutionname");
                return EmptyUtil.isNoEmpty(afterRecerName) || EmptyUtil.isNoEmpty(changeRecacctBank) || EmptyUtil.isNoEmpty(afterRecerBank) || EmptyUtil.isNoEmpty(afterUsage) || EmptyUtil.isNoEmpty(afterinstitutioncode) || EmptyUtil.isNoEmpty(afterinstitutionname);
            });
        }
        return true;
    }
}

