/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PermissionHelper {
    private static final Set<String> ENTRUST_PAY_PERM_ITEMS = new HashSet<String>(){
        {
            this.add("47156aff000000ac");
            this.add("4715e1f1000000ac");
            this.add("804f6478000000ac");
            this.add("4715a0df000000ac");
            this.add("47162f66000000ac");
            this.add("47165e8e000000ac");
        }
    };

    public static boolean hasAddNewRight(long orgId, String entityId) {
        return PermissionHelper.checkCurrentUserPermission(orgId, entityId, "47156aff000000ac");
    }

    public static boolean hasViewRight(long orgId, String entityId) {
        return PermissionHelper.checkCurrentUserPermission(orgId, entityId, "47150e89000000ac");
    }

    public static boolean hasEditRight(long orgId, String entityId) {
        return PermissionHelper.checkCurrentUserPermission(orgId, entityId, "4715a0df000000ac");
    }

    public static boolean checkCurrentUserPermission(long orgId, String entityId, String permissionItemId) {
        return PermissionHelper.checkCurrentUserPermission(orgId, "cas", entityId, permissionItemId);
    }

    public static boolean checkCurrentUserPermission(long orgId, String appId, String entityId, String permissionItemId) {
        String userId = RequestContext.get().getUserId();
        int res = PermissionServiceHelper.checkPermission((long)Long.parseLong(userId), (String)"DIM_ORG", (long)orgId, (String)appId, (String)entityId, (String)permissionItemId);
        return res == 1;
    }

    public static boolean checkCurrentUserPermission(String appId, long orgId, String entityNum, String permissionItemId) {
        String userId = RequestContext.get().getUserId();
        int res = PermissionServiceHelper.checkPermission((long)Long.parseLong(userId), (String)"DIM_ORG", (long)orgId, (String)appId, (String)entityNum, (String)permissionItemId);
        return res == 1;
    }

    public static boolean hasEntrustPayPermission(String appId, String entityId) {
        long orgId = RequestContext.get().getOrgId();
        for (String permissionItemId : ENTRUST_PAY_PERM_ITEMS) {
            if (!PermissionHelper.checkCurrentUserPermission(appId, orgId, entityId, permissionItemId)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkPermission(Long userId, String appId, String entityNum, String permItemId) {
        return PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityNum, (String)permItemId);
    }

    public static boolean checkPermission(Long userId, Long orgId, String appId, String entityNum, String permItemId) {
        return PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)appId, (String)entityNum, (String)permItemId) == 1;
    }
}

