/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.EmptyUtil;

public class SystemStatusCtrolHelper {
    private static final Log logger = LogFactory.getLog(SystemStatusCtrolHelper.class);

    public static Map<Long, Boolean> isInitEnable(Set<Long> orgIds) {
        if (ExtendConfigHelper.isInitOnlySet()) {
            return SystemStatusCtrolHelper.isFinishInitSetting(orgIds);
        }
        return SystemStatusCtrolHelper.isFinishInit(orgIds);
    }

    public static boolean isInitEnable(long orgId) {
        if (ExtendConfigHelper.isInitOnlySet()) {
            return SystemStatusCtrolHelper.isFinishInitSetting(orgId);
        }
        return SystemStatusCtrolHelper.isFinishInit(orgId);
    }

    public static boolean isInitEnable(DynamicObject systemStatusCtrol) {
        if (ExtendConfigHelper.isInitOnlySet()) {
            return SystemStatusCtrolHelper.isFinishInitSetting(systemStatusCtrol);
        }
        return SystemStatusCtrolHelper.isFinishInit(systemStatusCtrol);
    }

    public static String getNotInitMsg(String orgName) {
        if (ExtendConfigHelper.isInitOnlySet()) {
            return SystemStatusCtrolHelper.notFinishInitSetMsg(orgName);
        }
        return SystemStatusCtrolHelper.notFinishInitMsg(orgName);
    }

    public static String getNotInitMsg(long orgId) {
        if (ExtendConfigHelper.isInitOnlySet()) {
            return SystemStatusCtrolHelper.notFinishInitSetMsg(orgId);
        }
        return SystemStatusCtrolHelper.notFinishInitMsg(orgId);
    }

    public static String notFinishInitMsg(String orgName) {
        return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\uff0c\u8bf7\u5148\u5b8c\u6210\u51fa\u7eb3/\u8d44\u91d1\u7ed3\u7b97\u521d\u59cb\u5316\u3002", (String)"SystemStatusCtrolHelper_1", (String)"fi-cas-common", (Object[])new Object[0]), orgName);
    }

    public static String notFinishInitSetMsg(String orgName) {
        return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\uff0c\u8bf7\u5148\u5b8c\u6210\u51fa\u7eb3/\u8d44\u91d1\u7ed3\u7b97\u521d\u59cb\u5316\u3002", (String)"SystemStatusCtrolHelper_1", (String)"fi-cas-common", (Object[])new Object[0]), orgName);
    }

    public static String notFinishInitMsg(long orgId) {
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"name");
        return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\uff0c\u8bf7\u5148\u5b8c\u6210\u51fa\u7eb3/\u8d44\u91d1\u7ed3\u7b97\u521d\u59cb\u5316\u3002", (String)"SystemStatusCtrolHelper_1", (String)"fi-cas-common", (Object[])new Object[0]), CasHelper.getLocalValue(org, "name"));
    }

    public static String notFinishInitSetMsg(long orgId) {
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"name");
        return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\uff0c\u8bf7\u5148\u5b8c\u6210\u51fa\u7eb3/\u8d44\u91d1\u7ed3\u7b97\u521d\u59cb\u5316\u3002", (String)"SystemStatusCtrolHelper_1", (String)"fi-cas-common", (Object[])new Object[0]), CasHelper.getLocalValue(org, "name"));
    }

    public static boolean isFinishInit(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        return SystemStatusCtrolHelper.isFinishInit(systemStatusCtrol);
    }

    public static Map<Long, Boolean> isFinishInit(Set<Long> orgIds) {
        Map<String, DynamicObject> systemStatusCtrols;
        if (orgIds != null && orgIds.size() > 0 && (systemStatusCtrols = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIds)) != null && systemStatusCtrols.size() > 0) {
            HashMap<Long, Boolean> returns = new HashMap<Long, Boolean>(systemStatusCtrols.size());
            systemStatusCtrols.forEach((key, value) -> returns.put(Long.valueOf(key), SystemStatusCtrolHelper.isFinishInit(value)));
            return returns;
        }
        return new HashMap<Long, Boolean>();
    }

    public static boolean isFinishInitSetting(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        return SystemStatusCtrolHelper.isFinishInitSetting(systemStatusCtrol);
    }

    public static Map<Long, Boolean> isFinishInitSetting(Set<Long> orgIds) {
        Map<String, DynamicObject> systemStatusCtrols;
        if (orgIds != null && orgIds.size() > 0 && (systemStatusCtrols = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIds)) != null && systemStatusCtrols.size() > 0) {
            HashMap<Long, Boolean> returns = new HashMap<Long, Boolean>(systemStatusCtrols.size());
            systemStatusCtrols.forEach((key, value) -> returns.put(Long.valueOf(key), SystemStatusCtrolHelper.isFinishInitSetting(value)));
            return returns;
        }
        return new HashMap<Long, Boolean>();
    }

    public static boolean isFinishInit(DynamicObject systemStatusCtrol) {
        if (systemStatusCtrol == null) {
            return false;
        }
        return systemStatusCtrol.getBoolean("isfinishinit");
    }

    public static boolean isFinishInitSetting(DynamicObject systemStatusCtrol) {
        return systemStatusCtrol != null && systemStatusCtrol.getDynamicObject("startperiod") != null;
    }

    public static List<Object> getBatchSystemStatusControl(Set<Long> orgIdList) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIdList)};
        Map result = BusinessDataServiceHelper.loadFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
        ArrayList<Object> isInitOrgList = new ArrayList<Object>(result.size());
        for (Map.Entry entry : result.entrySet()) {
            DynamicObject casInit = (DynamicObject)entry.getValue();
            DynamicObject org = casInit.getDynamicObject("org");
            if (org == null) continue;
            isInitOrgList.add(org.getPkValue());
        }
        return isInitOrgList;
    }

    public static DynamicObject getCurrentPeriod(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null) {
            return null;
        }
        DynamicObject currentperiod = systemStatusCtrol.getDynamicObject("currentperiod");
        if (ExtendConfigHelper.isInitOnlySet() && currentperiod == null) {
            currentperiod = systemStatusCtrol.getDynamicObject("startperiod");
        }
        return currentperiod;
    }

    public static Map<Long, DynamicObject> getCurrentPeriod(Set<Long> orgIdS) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIdS)};
        DynamicObjectCollection idS = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id", (QFilter[])filters);
        List pkList = idS.stream().map(item -> item.get("id")).collect(Collectors.toList());
        DynamicObject[] systemStatusCtrArr = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_cashmgtinit"));
        return Arrays.stream(systemStatusCtrArr).collect(Collectors.toMap(item -> item.getLong("org.id"), Function.identity(), (k1, k2) -> k1));
    }

    public static DynamicObject getPeriodType(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        return systemStatusCtrol == null ? null : systemStatusCtrol.getDynamicObject("periodtype");
    }

    public static DynamicObject getStartPeriod(long orgId) {
        return SystemStatusCtrolHelper.getDyObjFromSysStatusCtrolByOrgId(orgId, "startperiod");
    }

    public static DynamicObject getStandardCurrency(long orgId) {
        return SystemStatusCtrolHelper.getDyObjFromSysStatusCtrolByOrgId(orgId, "standardcurrency");
    }

    public static DynamicObject getExrateTable(long orgId) {
        return SystemStatusCtrolHelper.getDyObjFromSysStatusCtrolByOrgId(orgId, "exratetable");
    }

    private static DynamicObject getDyObjFromSysStatusCtrolByOrgId(long orgId, String objTag) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null || systemStatusCtrol.getDynamicObject(objTag) == null) {
            String msg = SystemStatusCtrolHelper.notFinishInitSetMsg(orgId);
            logger.info(msg);
            throw new KDBizException(msg);
        }
        return systemStatusCtrol.getDynamicObject(objTag);
    }

    public static Map<Long, DynamicObject> getExrateTable(Set<Long> orgIds) {
        if (CasHelper.isEmpty(orgIds)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("exratetable", "is not null", null)};
        Object[] list = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"org,exratetable", (QFilter[])qFilters);
        if (EmptyUtil.isNoEmpty(list) && Arrays.stream(list).anyMatch(d -> d.getDynamicObject("exratetable") != null)) {
            return Arrays.stream(list).filter(d -> d.getDynamicObject("exratetable") != null).collect(Collectors.toMap(d -> d.getDynamicObject("org").getLong("id"), d -> d.getDynamicObject("exratetable"), (k1, k2) -> k1));
        }
        return new HashMap<Long, DynamicObject>(0);
    }

    public static DynamicObject getSystemStatusCtrol(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
    }

    public static Map<String, DynamicObject> getSystemStatusCtrol(Set<Long> orgIds) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds)};
        Collection values = BusinessDataServiceHelper.loadFromCache((String)"cas_cashmgtinit", (QFilter[])filters).values();
        HashMap<String, DynamicObject> orgMap = new HashMap<String, DynamicObject>();
        for (DynamicObject data : values) {
            String orgId = data.getString("org.id");
            if (orgMap.containsKey(orgId)) continue;
            orgMap.put(orgId, data);
        }
        return orgMap;
    }

    public static DynamicObject loadCashMgtInit(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        DynamicObjectCollection cashMgitInitColl = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id", (QFilter[])filters);
        if (cashMgitInitColl.size() == 0) {
            return null;
        }
        DynamicObject cashMgtInit = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cashMgitInitColl.get(0)).getLong("id"), (String)"cas_cashmgtinit");
        return cashMgtInit;
    }

    public static DynamicObject moveToNextPeriod(long orgId) {
        DynamicObject cashMgtInit = SystemStatusCtrolHelper.loadCashMgtInit(orgId);
        if (cashMgtInit == null) {
            return null;
        }
        DynamicObject currentPeriod = cashMgtInit.getDynamicObject("currentperiod");
        DynamicObject nextPeriod = PeriodHelper.getNextPeriodNotAdjustPeriod(currentPeriod.getLong("id"));
        DynamicObjectHelper.setValue(cashMgtInit, "currentperiod", nextPeriod);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cashMgtInit});
        return nextPeriod;
    }

    public static DynamicObject moveToPrevPeriod(long orgId) {
        DynamicObject cashMgtInit = SystemStatusCtrolHelper.loadCashMgtInit(orgId);
        if (cashMgtInit == null) {
            return null;
        }
        DynamicObject currentPeriod = cashMgtInit.getDynamicObject("currentperiod");
        DynamicObject prevPeriod = PeriodHelper.getPrevPeriodNotAdjustPeriod(currentPeriod.getLong("id"));
        DynamicObjectHelper.setValue(cashMgtInit, "currentperiod", prevPeriod);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cashMgtInit});
        return prevPeriod;
    }

    public static DynamicObject testMoveToPrevPeriod(long orgId, DynamicObject period) {
        DynamicObject cashMgtInit = SystemStatusCtrolHelper.loadCashMgtInit(orgId);
        if (cashMgtInit == null) {
            return null;
        }
        DynamicObject currentPeriod = cashMgtInit.getDynamicObject("currentperiod");
        if (currentPeriod == null) {
            cashMgtInit.set("currentperiod", (Object)period);
            currentPeriod = cashMgtInit.getDynamicObject("currentperiod");
        }
        DynamicObject prevPeriod = PeriodHelper.getPrevPeriod(currentPeriod.getLong("id"));
        DynamicObjectHelper.setValue(cashMgtInit, "currentperiod", prevPeriod);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cashMgtInit});
        return prevPeriod;
    }

    public static Map<Long, DynamicObject> loadFinishInits() {
        QFilter[] filters = new QFilter[]{new QFilter("isfinishinit", "=", (Object)"1")};
        Collection values = BusinessDataServiceHelper.loadFromCache((String)"cas_cashmgtinit", (QFilter[])filters).values();
        HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject data : values) {
            Long orgId = data.getLong("org.id");
            if (orgMap.containsKey(orgId)) continue;
            orgMap.put(orgId, data);
        }
        return orgMap;
    }

    public static Map<Long, DynamicObject> loadFinishInits(Set<Long> orgIds) {
        QFilter[] filters = new QFilter[]{new QFilter("isfinishinit", "=", (Object)"1"), new QFilter("org", "in", orgIds)};
        Collection values = BusinessDataServiceHelper.loadFromCache((String)"cas_cashmgtinit", (QFilter[])filters).values();
        HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject data : values) {
            Long orgId = data.getLong("org.id");
            if (orgMap.containsKey(orgId)) continue;
            orgMap.put(orgId, data);
        }
        return orgMap;
    }

    public static Map<Long, DynamicObject> loadRecEdcs(Set<Long> orgIds) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds)};
        Collection values = BusinessDataServiceHelper.loadFromCache((String)"cas_rec_edc", (QFilter[])filters).values();
        HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject data : values) {
            Long orgId = data.getLong("org.id");
            if (orgMap.containsKey(orgId)) continue;
            orgMap.put(orgId, data);
        }
        return orgMap;
    }
}

