/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.param.ParamMap;

public class ViewInputHelper {
    public static void addF7Filter(IFormView view, String prop, F7FilterBuilder builder) {
        BasedataEdit f7 = (BasedataEdit)view.getControl(prop);
        f7.addBeforeF7SelectListener(e -> {
            ListShowParameter sp = (ListShowParameter)e.getFormShowParameter();
            QFilter qFilter = builder.build(e);
            sp.getListFilterParameter().setFilter(qFilter);
        });
    }

    public static void registerMustInput(IFormView view, IDataModel model, String[] propNameArr, String billStatusName, String ... statusArr) {
        for (String propName : propNameArr) {
            ViewInputHelper.registerMustInput(view, model, propName, billStatusName, statusArr);
        }
    }

    public static void registerMustInput(IFormView view, IDataModel model, String propName, String billStatusName, String ... statusArr) {
        FieldEdit fieldEdit = (FieldEdit)view.getControl(propName);
        boolean statusMatch = ViewInputHelper.isStatusMatch(model, billStatusName, statusArr);
        fieldEdit.setMustInput(statusMatch);
    }

    public static void registerMustInput(IFormView view, String[] propNameArr) {
        ViewInputHelper.registerMustInput(view, true, propNameArr);
    }

    public static void registerMustInput(IFormView view, boolean isMustInput, String[] propNameArr) {
        for (String propName : propNameArr) {
            FieldEdit fieldEdit = (FieldEdit)view.getControl(propName);
            fieldEdit.setMustInput(isMustInput);
        }
    }

    public static void registerShowingStatus(IFormView view, IDataModel model, String[] propNameArr, String billStatusName, String ... statusArr) {
        for (String propName : propNameArr) {
            ViewInputHelper.registerShowingStatus(view, model, propName, billStatusName, statusArr);
        }
    }

    public static void registerShowingStatus(IFormView view, IDataModel model, String propName, String billStatusName, String ... statusArr) {
        boolean statusMatch = ViewInputHelper.isStatusMatch(model, billStatusName, statusArr);
        view.setVisible(Boolean.valueOf(statusMatch), new String[]{propName});
    }

    private static void showErrTip(IFormView view, String field, String message) {
        FieldTip tip = new FieldTip();
        tip.setFieldKey(field);
        tip.setLevel(FieldTip.FieldTipsLevel.Error);
        tip.setTip(message);
        view.showFieldTip(tip);
    }

    public static void hideErrTip(IFormView view, String field) {
        FieldTip tip = new FieldTip();
        tip.setFieldKey(field);
        tip.setSuccess(true);
        view.showFieldTip(tip);
    }

    public static void registerShowingStatus(IFormView view, String[] propNameArr) {
        for (String propName : propNameArr) {
            view.setVisible(Boolean.TRUE, new String[]{propName});
        }
    }

    public static void registerVisibleStatus(IFormView view, String[] propNameArr, boolean visibleFlag) {
        for (String propName : propNameArr) {
            view.setVisible(Boolean.valueOf(visibleFlag), new String[]{propName});
        }
    }

    public static void registerDisableStatus(IFormView view, IDataModel model, String[] propNameArr, String billStatusName, String ... statusArr) {
        for (String propName : propNameArr) {
            ViewInputHelper.registerDisableStatus(view, model, propName, billStatusName, statusArr);
        }
    }

    public static void registerDisableStatus(IFormView view, IDataModel model, String propName, String billStatusName, String ... statusArr) {
        boolean statusMatch = ViewInputHelper.isStatusMatch(model, billStatusName, statusArr);
        view.setEnable(Boolean.valueOf(!statusMatch), new String[]{propName});
    }

    public static void registerDisableStatus(IFormView view, String[] propNameArr) {
        for (String propName : propNameArr) {
            view.setEnable(Boolean.FALSE, new String[]{propName});
        }
    }

    public static void batchFillEntity(String entryName, AbstractFormDataModel model, List<Map<String, Object>> dataMap) {
        model.deleteEntryData(entryName);
        if (null != dataMap && dataMap.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            for (Map<String, Object> map : dataMap) {
                map.forEach((key, value) -> {
                    if (value instanceof DynamicObject) {
                        value = ((DynamicObject)value).getPkValue();
                    }
                    vs.addField(key, new Object[]{value});
                });
            }
            model.batchCreateNewEntryRow(entryName, vs);
        }
    }

    public static void setValWithoutPropChgEvt(IFormView view, IDataModel model, String propName, Object value) {
        ViewInputHelper.setValWithoutPropChgEvt(view, model, new ParamMap().put(propName, value).getParams());
    }

    public static void setValWithoutPropChgEvt(IFormView view, IDataModel model, Map<String, Object> valueMap) {
        model.beginInit();
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            model.setValue(entry.getKey(), entry.getValue());
        }
        model.endInit();
        for (String prop : valueMap.keySet()) {
            view.updateView(prop);
        }
    }

    public static void setValWithoutPropChgEvt(IFormView view, IDataModel model, String propName, Object value, int rowIndex) {
        model.beginInit();
        model.setValue(propName, value, rowIndex);
        model.endInit();
        view.updateView(propName, rowIndex);
    }

    public static void setValWithoutDataChanged(IDataModel model, String propName, Object value) {
        ViewInputHelper.setValWithoutDataChanged(model, new ParamMap().put(propName, value).getParams());
    }

    public static void setValWithoutDataChanged(IDataModel model, String propName, Object value, int i) {
        boolean isChanged = model.getDataChanged();
        model.setValue(propName, value, i);
        if (!isChanged) {
            model.setDataChanged(false);
        }
    }

    public static void setValWithoutDataChanged(IDataModel model, Map<String, Object> valueMap) {
        boolean isChanged = model.getDataChanged();
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            model.setValue(entry.getKey(), entry.getValue());
        }
        if (!isChanged) {
            model.setDataChanged(false);
        }
    }

    public static boolean isStatusMatch(IDataModel model, String billStatusName, String ... statusArr) {
        Object currStatus = model.getValue(billStatusName);
        return Stream.of(statusArr).anyMatch(b -> b.equals(currStatus));
    }

    public static interface F7FilterBuilder {
        public QFilter build(BeforeF7SelectEvent var1);
    }
}

