/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.extplugin.PluginProxy;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.sdk.fi.cas.extpoint.journal.IJournalVoucherBookInterface;

public class VoucherBookHelper {
    private static Log logger = LogFactory.getLog(VoucherBookHelper.class);
    private Map<Long, DynamicObject> accountViewCache = new HashMap<Long, DynamicObject>();
    public Map<Object, DynamicObject> resultBankCash = new HashMap<Object, DynamicObject>();

    public Map<String, Long> readAsstactValue(DynamicObject assgrp) {
        if (assgrp != null) {
            return this.readBasedata(assgrp.getString("value"));
        }
        return new HashMap<String, Long>();
    }

    public DynamicObject getCasAccount(DynamicObject voucherEntryRow) {
        DynamicObject accountView = voucherEntryRow.getDynamicObject("account");
        if (accountView == null) {
            return null;
        }
        boolean isJournal = this.isJournal(accountView);
        boolean isCashAccount = this.isCashAccount(accountView);
        if (!isJournal && !isCashAccount) {
            return null;
        }
        DynamicObject assgrp = voucherEntryRow.getDynamicObject("assgrp");
        Map<String, Long> assgrpValue = this.readAsstactValue(assgrp);
        if (assgrpValue.containsKey("bd_accountbanks") && isJournal) {
            return AccountBankHelper.getAccountBankById(assgrpValue.get("bd_accountbanks"));
        }
        if (assgrpValue.containsKey("cas_accountcash") && isJournal) {
            return AccountCashHelper.getAccountCashById(assgrpValue.get("cas_accountcash"));
        }
        if (isCashAccount) {
            return this.getExtCashAccount(voucherEntryRow);
        }
        return null;
    }

    public boolean isJournal(DynamicObject accountView) {
        return (accountView = this.getCachedAccountView(accountView)) != null && accountView.getBoolean("isjournal");
    }

    public boolean isCashAccount(DynamicObject accountView) {
        return (accountView = this.getCachedAccountView(accountView)) != null && accountView.getBoolean("iscash");
    }

    public boolean isMainBookType(DynamicObject bookType) {
        return bookType != null && "1".equals(bookType.getString("accounttype"));
    }

    private DynamicObject getCachedAccountView(DynamicObject accountView) {
        if (accountView == null) {
            return null;
        }
        Object accountViewPk = accountView.getPkValue();
        if (this.accountViewCache.containsKey(accountViewPk)) {
            accountView = this.accountViewCache.get(accountViewPk);
        } else {
            accountView = BusinessDataServiceHelper.loadSingleFromCache((Object)accountViewPk, (String)accountView.getDataEntityType().getName());
            this.accountViewCache.put((Long)accountViewPk, accountView);
        }
        return accountView;
    }

    private Map<String, Long> readBasedata(String assgrpJson) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (assgrpJson == null) {
            return map;
        }
        JSONObject valueJson = JSONObject.parseObject((String)assgrpJson);
        Set ks = valueJson.keySet();
        for (String k : ks) {
            QFilter q = new QFilter("flexfield", "=", (Object)k);
            Map asstacttypes = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"number,valuetype,valuesource,assistanttype", (QFilter[])new QFilter[]{q});
            if (asstacttypes.isEmpty()) continue;
            if (asstacttypes.size() > 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u5f02\u5e38,flexfield = %s \u91cd\u590d", (String)"VoucherBookHelper_0", (String)"fi-cas-common", (Object[])new Object[0]), k));
            }
            DynamicObject asstacttype = (DynamicObject)asstacttypes.values().iterator().next();
            if (!"1".equals(asstacttype.getString("valuetype"))) continue;
            String formid = asstacttype.getString("valuesource.id");
            try {
                Long valueData = valueJson.getLong(k);
                if (formid == null) continue;
                map.put(formid, valueData);
            }
            catch (Exception e) {
                logger.error("readBasedata has error:", (Throwable)e);
                logger.error("readBasedata assgrpJson:" + assgrpJson);
            }
        }
        return map;
    }

    public static void saveDapTracker(DynamicObject againstVoucher, Long voucherId) {
        DynamicObject againstDaptracker = BusinessDataServiceHelper.newDynamicObject((String)"ai_daptracker");
        DynamicObject daptracker = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"billtype,vchtemplateid,sourcebillid", (QFilter[])new QFilter[]{new QFilter("voucherid", "=", (Object)voucherId)})[0];
        againstDaptracker.set("billtype", daptracker.getDynamicObject("billtype").getPkValue());
        againstDaptracker.set("sourcebillid", (Object)daptracker.getLong("sourcebillid"));
        againstDaptracker.set("createdate", (Object)DateUtils.getCurrentDate());
        againstDaptracker.set("voucherid", againstVoucher.getPkValue());
        againstDaptracker.set("vchtemplateid", (Object)daptracker.getLong("vchtemplateid"));
        againstDaptracker.set("org", againstVoucher.getDynamicObject("org").getPkValue());
        againstDaptracker.set("booktype", againstVoucher.getDynamicObject("booktype").getPkValue());
        againstDaptracker.set("period", againstVoucher.getDynamicObject("period").getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{againstDaptracker});
    }

    public static boolean checkVoucherIsPost(Set<Long> vouchers) {
        if (vouchers == null || vouchers.size() == 0) {
            return Boolean.FALSE;
        }
        QFilter filter = new QFilter("id", "in", vouchers);
        filter.and("isreverse", "=", (Object)"0");
        filter.and("hasreverse", "=", (Object)"0");
        filter.and("ispost", "=", (Object)"0");
        return QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])filter.toArray());
    }

    public static List<Long> getVoucherExistIds(Set<Long> billIds, String entityName) {
        ArrayList<Long> list = new ArrayList<Long>(10);
        Map returnMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"DapQueryDataService", (String)"getVoucherInfofromBill", (Object[])new Object[]{entityName, new HashSet<Long>(billIds)});
        HashSet allVouchers = new HashSet(16);
        for (Set vouchers : returnMap.values()) {
            allVouchers.addAll(vouchers);
        }
        QFilter filter = new QFilter("id", "in", allVouchers);
        filter.and("isreverse", "=", (Object)"0");
        filter.and("hasreverse", "=", (Object)"0");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"gl_voucher", (String)"id", (QFilter[])filter.toArray());
        if (query.size() > 0) {
            for (Map.Entry entry : returnMap.entrySet()) {
                Long billId = (Long)entry.getKey();
                Set vouchers = (Set)entry.getValue();
                boolean exists = false;
                for (DynamicObject gl : query) {
                    long voucherId = gl.getLong("id");
                    if (!vouchers.contains(voucherId)) continue;
                    exists = true;
                    break;
                }
                if (!exists) continue;
                list.add(billId);
            }
        }
        return list;
    }

    public static boolean checkVoucherNotSubmit(Object billId, String entityName) {
        Set vouchers = DapVoucherUtil.getBuildVch(Collections.singleton(billId), (String)entityName);
        DynamicObject[] voucherObjs = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)vouchers), new QFilter("isreverse", "=", (Object)"1"), new QFilter("billstatus", "=", (Object)"A")});
        if (CasHelper.isEmpty(voucherObjs)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Set<Long> batchCheckVoucherNotSubmit(List<Object> billIds, String entityName) {
        Set voucherIds = DapVoucherUtil.getBuildVch(billIds, (String)entityName);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)voucherIds), new QFilter("isreverse", "=", (Object)"1"), new QFilter("billstatus", "=", (Object)"A")};
        DynamicObjectCollection glVouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id", (QFilter[])qFilters);
        if (EmptyUtil.isEmpty(glVouchers)) {
            return new HashSet<Long>(0);
        }
        return glVouchers.parallelStream().map(d -> d.getLong("id")).collect(Collectors.toSet());
    }

    public static Map<Object, Boolean> checkVoucherNotSubmit(Set<Object> billIdS, String entityName) {
        HashMap<Object, Boolean> result = new HashMap<Object, Boolean>(billIdS.size());
        Set vouchers = DapVoucherUtil.getBuildVch(billIdS, (String)entityName);
        HashSet<Long> voucherIds = new HashSet<Long>(vouchers.size());
        if (vouchers.size() > 0) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryGl", (String)"gl_voucher", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)vouchers), new QFilter("isreverse", "=", (Object)"1"), new QFilter("billstatus", "=", (Object)"A")}, null);){
                while (ds.hasNext()) {
                    voucherIds.add(ds.next().getLong("id"));
                }
            }
        }
        for (Object billId : billIdS) {
            result.put(billId, voucherIds.contains(billId));
        }
        return result;
    }

    public static List<Long> reverseVoucher(Set<Long> voucherIds, Object voucerOp) {
        List aginstVids = null;
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            DynamicObjectCollection voucherObjs = QueryServiceHelper.query((String)"gl_voucher", (String)"id,ispost", (QFilter[])new QFilter[]{new QFilter("id", "in", voucherIds), new QFilter("ispost", "=", (Object)"1"), new QFilter("isreverse", "=", (Object)"0"), new QFilter("billstatus", "!=", (Object)"A"), new QFilter("hasreverse", "=", (Object)"0")});
            OperationResult voucheragainstResult = null;
            if (!CasHelper.isEmpty(voucherObjs)) {
                List<Long> voucherId = voucherObjs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
                List<Long> afterCheckVouchers = VoucherBookHelper.getAfterCheckVoucher(voucherId);
                if (afterCheckVouchers == null || afterCheckVouchers.size() == 0) {
                    List<Long> list = null;
                    return list;
                }
                String execOperate = CasHelper.isNotEmpty(voucerOp) ? String.valueOf(voucerOp) : "voucheragainst";
                OperateOption operate = OperateOption.create();
                if ("voucheragainst".equals(execOperate)) {
                    operate.setVariableValue("handtype", Boolean.FALSE.toString());
                }
                if (!(voucheragainstResult = OperateServiceHelper.execOperate(execOperate, "gl_voucher", voucherId.toArray(), operate)).isSuccess()) {
                    logger.info(voucheragainstResult.getMessage());
                    throw new KDBizException(ResManager.loadKDString((String)"\u51b2\u9500\u51ed\u8bc1\u5931\u8d25\u3002", (String)"RecBillCancelRecImpl_3", (String)"fi-cas-common", (Object[])new Object[0]));
                }
                DynamicObject[] againstVouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,org,period,booktype,sourcebill", (QFilter[])new QFilter[]{new QFilter("isreverse", "=", (Object)"1"), new QFilter("sourcebill", "in", voucherId)}, (String)"createtime desc");
                if (null == againstVouchers || againstVouchers.length != voucherId.size()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u51b2\u51ed\u8bc1\u751f\u6210\u5931\u8d25\uff0c\u672a\u751f\u6210\u51b2\u9500\u51ed\u8bc1\u3002", (String)"RecBillCancelRecImpl_2", (String)"fi-cas-common", (Object[])new Object[0]));
                }
                aginstVids = Arrays.stream(againstVouchers).map(v -> v.getLong("id")).collect(Collectors.toList());
                for (DynamicObject againstVoucher : againstVouchers) {
                    VoucherBookHelper.saveDapTracker(againstVoucher, againstVoucher.getLong("sourcebill"));
                }
            }
            List list = aginstVids;
            return list;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                if (aginstVids != null && aginstVids.size() > 0) {
                    OperateServiceHelper.execOperate("delete", "gl_voucher", aginstVids.toArray(), OperateOption.create());
                }
                throw new KDBizException(e.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static List<Long> getAfterCheckVoucher(List<Long> voucherIds) {
        if (StringUtils.isNotBlank(voucherIds)) {
            ArrayList<Long> tempList = new ArrayList<Long>();
            DynamicObjectCollection isReverseVouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,sourcebill", (QFilter[])new QFilter[]{new QFilter("sourcebill", "in", voucherIds), new QFilter("isreverse", "=", (Object)"1"), new QFilter("billstatus", "=", (Object)"A")});
            if (!CasHelper.isEmpty(isReverseVouchers)) {
                Set sourceBillIds = isReverseVouchers.stream().map(r -> r.getLong("sourcebill")).collect(Collectors.toSet());
                voucherIds.forEach(v -> {
                    if (!sourceBillIds.contains(v)) {
                        tempList.add((Long)v);
                    }
                });
                return tempList;
            }
            return voucherIds;
        }
        return null;
    }

    public void getCachedAccountViewsBatch(Set<Long> accountView, String tableName) {
        this.getCachedAccountViews(accountView, tableName);
    }

    private void getCachedAccountViews(Set<Long> accountView, String tableName) {
        long startTime = System.currentTimeMillis();
        logger.info("getCachedAccountViews start:" + startTime);
        QFilter qFilter = new QFilter("id", "in", accountView);
        Map result = BusinessDataServiceHelper.loadFromCache((String)tableName, (String)"id,isjournal,iscashequivalent,isbank,iscash", (QFilter[])new QFilter[]{qFilter});
        logger.info("getCachedAccountViews end:" + (System.currentTimeMillis() - startTime));
        for (Map.Entry data : result.entrySet()) {
            this.accountViewCache.put((Long)data.getKey(), (DynamicObject)data.getValue());
        }
    }

    public Map<String, Exception> readBasedatasByEntry(Set<String> assgrpJson) {
        Map result;
        logger.info("readBasedatasByEntry is start");
        HashMap<String, Exception> errorMap = new HashMap<String, Exception>();
        HashSet filterList = new HashSet();
        HashMap jsonValueMap = new HashMap();
        for (String assgrpObj : assgrpJson) {
            JSONObject valueJson = JSONObject.parseObject((String)assgrpObj);
            Set ks = valueJson.keySet();
            filterList.addAll(ks);
            for (String keyStr : ks) {
                try {
                    if (null != jsonValueMap.get(keyStr)) {
                        ((Set)jsonValueMap.get(keyStr)).add(valueJson.getLong(keyStr));
                        continue;
                    }
                    HashSet<Long> valueSet = new HashSet<Long>();
                    if (!(valueJson.get((Object)keyStr) instanceof Long)) continue;
                    valueSet.add(valueJson.getLong(keyStr));
                    jsonValueMap.put(keyStr, valueSet);
                }
                catch (Exception e) {
                    logger.error("is error is that e:", (Throwable)e);
                    logger.error("is error thar assgrpObj" + assgrpObj);
                }
            }
        }
        ArrayList<String> valuesourceIds = new ArrayList<String>();
        HashSet jsonValuesOfBank = new HashSet();
        HashSet jsonValuesOfCash = new HashSet();
        valuesourceIds.add("bd_accountbanks");
        valuesourceIds.add("cas_accountcash");
        QFilter q = new QFilter("flexfield", "in", filterList);
        QFilter q1 = new QFilter("valuetype", "=", (Object)"1");
        QFilter q2 = new QFilter("valuesource.id", "in", valuesourceIds);
        QFilter q3 = q.and(q1).and(q2);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"queryAsstacttype", (String)"bd_asstacttype", (String)"flexfield,valuesource.id", (QFilter[])new QFilter[]{q3}, null);
        HashSet<String> resultAssgrpMapNew = new HashSet<String>(16);
        HashMap resultBankCashNew = new HashMap();
        while (ds.hasNext()) {
            Row row = ds.next();
            String keyStr = row.getString("flexfield");
            if (resultAssgrpMapNew.contains(keyStr)) {
                KDBizException exception = new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u5f02\u5e38,flexfield = %s \u91cd\u590d", (String)"VoucherBookHelper_0", (String)"fi-cas-common", (Object[])new Object[0]), keyStr));
                errorMap.put(keyStr, (Exception)((Object)exception));
                continue;
            }
            String formid = row.getString("valuesource.id");
            Set valueId = (Set)jsonValueMap.get(keyStr);
            if (formid != null && null != valueId) {
                if (formid.equalsIgnoreCase("bd_accountbanks")) {
                    jsonValuesOfBank.addAll(valueId);
                }
                if (formid.equalsIgnoreCase("cas_accountcash")) {
                    jsonValuesOfCash.addAll(valueId);
                }
            }
            resultAssgrpMapNew.add(keyStr);
        }
        long startTime1 = System.currentTimeMillis();
        logger.info("readBasedatasByEntry loadAcc start:" + startTime1);
        if (jsonValuesOfBank.size() > 0) {
            result = BusinessDataServiceHelper.loadFromCache((Object[])jsonValuesOfBank.toArray(), (String)"bd_accountbanks");
            resultBankCashNew.putAll(result);
        }
        if (jsonValuesOfCash.size() > 0) {
            result = BusinessDataServiceHelper.loadFromCache((Object[])jsonValuesOfCash.toArray(), (String)"cas_accountcash");
            resultBankCashNew.putAll(result);
        }
        logger.info("readBasedatasByEntry loadAcc end:" + (System.currentTimeMillis() - startTime1));
        this.resultBankCash.putAll(resultBankCashNew);
        return errorMap;
    }

    public DynamicObject getCasAccounts(DynamicObject voucherEntryRow) {
        DynamicObject result = null;
        DynamicObject accountView = voucherEntryRow.getDynamicObject("account");
        if (accountView == null) {
            logger.info("getCasAccounts.accountView is null.");
            return null;
        }
        boolean isJournal = this.isJournal(accountView);
        boolean isCashAccount = this.isCashAccount(accountView);
        if (!isCashAccount && !isJournal) {
            logger.info("getCasAccounts.accountView is not cash || bank.");
            return null;
        }
        DynamicObject assgrp = voucherEntryRow.getDynamicObject("assgrp");
        if (assgrp == null) {
            logger.info("getCasAccounts.assgrp is null.");
            if (isCashAccount) {
                result = this.getExtCashAccount(voucherEntryRow);
            }
            return result;
        }
        String value = assgrp.getString("value");
        logger.info("getCasAccounts.assgrpvalue:" + value);
        JSONObject valueJson = JSONObject.parseObject((String)value);
        Set keyDataSet = valueJson.keySet();
        if (isJournal) {
            String keyStr;
            logger.info("getCasAccounts.resultBankCash.size:" + this.resultBankCash.size());
            Iterator iterator = keyDataSet.iterator();
            while (iterator.hasNext() && null == (result = this.resultBankCash.get(valueJson.get((Object)(keyStr = (String)iterator.next()))))) {
            }
        }
        if (result == null && isCashAccount) {
            result = this.getExtCashAccount(voucherEntryRow);
        }
        return result;
    }

    private DynamicObject getExtCashAccount(DynamicObject voucherEntryRow) {
        String extFieldName = this.voucherBookCashAccountExt();
        if (EmptyUtil.isNoEmpty(extFieldName) && voucherEntryRow.containsProperty(extFieldName)) {
            DynamicObject accountCash;
            Object acct = voucherEntryRow.get(extFieldName);
            if (acct == null) {
                return null;
            }
            if (acct instanceof DynamicObject) {
                accountCash = voucherEntryRow.getDynamicObject(extFieldName);
            } else {
                String acctCashStr = String.valueOf(acct);
                accountCash = AccountCashHelper.getAccountCashById(Long.parseLong(acctCashStr));
            }
            if (EmptyUtil.isNoEmpty(accountCash)) {
                logger.info("getExtCashAccount: {}", accountCash.getPkValue());
                return accountCash;
            }
        } else {
            logger.warn("voucherBookCashAccountExt extFieldName is empty or voucherEntryRow.containsProperty({}) is false.", (Object)extFieldName);
        }
        return null;
    }

    private String voucherBookCashAccountExt() {
        PluginProxy pluginProxy = PluginProxy.create(IJournalVoucherBookInterface.class, (String)"kd.sdk.fi.cas.extpoint.journal.IJournalVoucherBookInterface.cashJournalBookExt");
        List resultList = pluginProxy.callReplace(IJournalVoucherBookInterface::cashJournalBookExt);
        if (EmptyUtil.isNoEmpty(resultList) && EmptyUtil.isNoEmpty((String)resultList.get(0))) {
            String extField = (String)resultList.get(0);
            String isv = ISVService.getISVInfo().getId();
            logger.info("\u51ed\u8bc1\u767b\u8d26 -- \u51ed\u8bc1\u5206\u5f55\u73b0\u91d1\u8d26\u6237id\u4e8c\u5f00\u6269\u5c55\u5b57\u6bb5\u6807\u8bc6:" + extField + " \u5f00\u53d1\u5546\u6807\u8bc6:" + isv);
            if (extField.startsWith(isv)) {
                return extField;
            }
        }
        return "";
    }
}

