/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.log;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.Pair;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.RefundHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RefundLogExecutor {
    private static final Log logger = LogFactory.getLog(RefundLogExecutor.class);
    private Long revId;
    private String revBillNo;
    private Object currency;
    private String billEntity;
    private DynamicObject[] bills;
    private final Map<Long, List<DynamicObject>> refundEntrys;
    private Map<Long, BigDecimal> currentRefundAmt;
    private String operate;

    public RefundLogExecutor(DynamicObject refundData, String operate) {
        block3: {
            DynamicObjectCollection relaList;
            block2: {
                this.refundEntrys = new LinkedHashMap<Long, List<DynamicObject>>();
                this.currentRefundAmt = new HashMap<Long, BigDecimal>();
                DynamicObjectCollection revList = refundData.getDynamicObjectCollection("revlist");
                DynamicObject rev = (DynamicObject)revList.get(0);
                this.revId = rev.getLong("revid");
                this.revBillNo = rev.getString("billno");
                this.currency = rev.get("currency");
                this.operate = operate;
                this.billEntity = refundData.getString("relebilltype");
                boolean relewithinfo = refundData.getBoolean("relewithinfo");
                relaList = RefundHelper.filterNotZeroRelaList((List<DynamicObject>)refundData.getDynamicObjectCollection("relebilllist"));
                Set billIds = relaList.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
                QFilter qFilter = new QFilter("id", "in", billIds);
                this.bills = BusinessDataServiceHelper.load((String)this.billEntity, (String)"id,org.id,billno,refundrevlist,isdiffcur,entry.id,entry.e_payableamt,entry.seq,entry.e_remainrefundamt,entry.e_refundamt", (QFilter[])qFilter.toArray());
                if (!"cas_paybill".equals(this.billEntity)) break block2;
                for (DynamicObject payBill : this.bills) {
                    Pair<List<DynamicObject>, Map<Long, BigDecimal>> refundEntryAndAmt = RefundHelper.getRefundEntryAndAmt(payBill, (List<DynamicObject>)relaList, relewithinfo);
                    this.refundEntrys.put((Long)payBill.getPkValue(), (List<DynamicObject>)refundEntryAndAmt.getKey());
                    this.currentRefundAmt.putAll((Map)refundEntryAndAmt.getValue());
                }
                break block3;
            }
            if (!"cas_agentpaybill".equals(this.billEntity)) break block3;
            this.currentRefundAmt = relaList.stream().filter(r -> BigDecimal.ZERO.compareTo(r.getBigDecimal("currentrefundamt")) != 0).collect(Collectors.toMap(r -> r.getLong("entryid"), r -> r.getBigDecimal("currentrefundamt")));
            for (DynamicObject bill : this.bills) {
                DynamicObjectCollection entryList = bill.getDynamicObjectCollection("entry");
                List refundEntryList = entryList.stream().filter(e -> this.currentRefundAmt.containsKey(e.getLong("id"))).collect(Collectors.toList());
                this.refundEntrys.put((Long)bill.getPkValue(), refundEntryList);
            }
        }
    }

    public RefundLogExecutor(Long revId, Long ifmId, String operateForIfm) {
        this.refundEntrys = new LinkedHashMap<Long, List<DynamicObject>>();
        this.currentRefundAmt = new HashMap<Long, BigDecimal>();
        DynamicObject revBill = BusinessDataServiceHelper.loadSingle((Object)revId, (String)"cas_recbill", (String)"id,billno,currency.id");
        this.revId = revId;
        this.revBillNo = revBill.getString("billno");
        this.currency = revBill.get("currency");
        this.operate = operateForIfm;
        this.billEntity = "ifm_transhandlebill";
        DynamicObject ifmBill = BusinessDataServiceHelper.loadSingle((Object)ifmId, (String)"ifm_transhandlebill", (String)"id,org.id,billno");
        this.bills = new DynamicObject[]{ifmBill};
    }

    public RefundLogExecutor(Long revId) {
        this.refundEntrys = new LinkedHashMap<Long, List<DynamicObject>>();
        this.currentRefundAmt = new HashMap<Long, BigDecimal>();
        DynamicObject revBill = BusinessDataServiceHelper.loadSingle((Object)revId, (String)"cas_recbill", (String)"id,billno,currency.id");
        this.revId = revId;
        this.revBillNo = revBill.getString("billno");
        this.currency = revBill.get("currency");
        this.operate = "cancelRefundRenote";
        Object[] payBills = RefundHelper.queryHadRefundBills(revId, "cas_paybill");
        if (ArrayUtils.isNotEmpty((Object[])payBills)) {
            this.billEntity = "cas_paybill";
            this.bills = payBills;
            this.buildBillFields(revId);
            return;
        }
        Object[] agentBills = RefundHelper.queryHadRefundBills(revId, "cas_agentpaybill");
        if (ArrayUtils.isNotEmpty((Object[])agentBills)) {
            this.billEntity = "cas_agentpaybill";
            this.bills = agentBills;
            this.buildBillFields(revId);
        }
    }

    public RefundLogExecutor(String billEntity, String operate) {
        this.refundEntrys = new LinkedHashMap<Long, List<DynamicObject>>();
        this.currentRefundAmt = new HashMap<Long, BigDecimal>();
        this.operate = operate;
        this.billEntity = billEntity;
    }

    public RefundLogExecutor() {
        this.refundEntrys = new LinkedHashMap<Long, List<DynamicObject>>();
        this.currentRefundAmt = new HashMap<Long, BigDecimal>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long[] saveAutoRenoteLog(OperationResult result, DynamicObject[] revBills, DynamicObject businessBill) {
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject[] logArr;
            String failResultMsg = CasHelper.getFailResultMsg(result);
            if (revBills != null && revBills.length > 0) {
                logArr = new DynamicObject[revBills.length];
                for (int i = 0; i < revBills.length; ++i) {
                    DynamicObject log;
                    logArr[i] = log = this.buildHeadLog(result, businessBill, revBills[i], failResultMsg);
                }
            } else {
                DynamicObject log = this.buildHeadLog(result, businessBill, null, failResultMsg);
                logArr = new DynamicObject[]{log};
            }
            SaveServiceHelper.save((DynamicObject[])logArr);
            Long[] longArray = (Long[])Arrays.stream(logArr).map(l -> (Long)l.getPkValue()).toArray(Long[]::new);
            return longArray;
        }
        catch (Exception e) {
            logger.error("RefundLogExecutor saveAutoRenoteLog error", (Throwable)e);
            return new Long[0];
        }
    }

    public void updateLogResult(Long logId, OperationResult result) {
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject log = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_refund_oplog"), (Object)logId);
            String failResultMsg = CasHelper.getFailResultMsg(result);
            log.set("opresult", (Object)(result.isSuccess() ? "0" : "1"));
            log.set("errorlog", (Object)StringUtils.substring((String)failResultMsg, (int)0, (int)2048));
            SaveServiceHelper.update((DynamicObject)log);
        }
        catch (Exception e) {
            logger.error("RefundLogExecutor updateLogResult error", (Throwable)e);
        }
    }

    private DynamicObject buildHeadLog(OperationResult result, DynamicObject businessBill, DynamicObject revBill, String failResultMsg) {
        MainEntityType logEntityType = EntityMetadataCache.getDataEntityType((String)"cas_refund_oplog");
        DynamicObject logObj = new DynamicObject((DynamicObjectType)logEntityType, (Object)DBServiceHelper.genGlobalLongId());
        logObj.set("billentity", (Object)this.billEntity);
        logObj.set("operatetype", (Object)this.operate);
        logObj.set("opresult", (Object)(result.isSuccess() ? "0" : "1"));
        logObj.set("errorlog", (Object)StringUtils.substring((String)failResultMsg, (int)0, (int)2048));
        logObj.set("opdatetime", (Object)new Date());
        logObj.set("creater", (Object)UserServiceHelper.getCurrentUserId());
        logObj.set("traceid", (Object)RequestContext.get().getTraceId());
        logObj.set("currency", businessBill.get("currency"));
        if (businessBill.containsProperty("company")) {
            logObj.set("org", (Object)businessBill.getString("company"));
        } else {
            logObj.set("org", businessBill.get("org"));
        }
        logObj.set("refundbillno", businessBill.get("billno"));
        logObj.set("refundbillid", businessBill.getPkValue());
        if (revBill != null) {
            logObj.set("revbillno", (Object)revBill.getString("billno"));
            logObj.set("revid", (Object)revBill.getLong("id"));
        }
        return logObj;
    }

    public void saveLog(OperationResult result) {
        boolean success = result.isSuccess();
        String errorInfo = "";
        try (TXHandle tx = TX.requiresNew();){
            if (!success) {
                StringBuilder message = new StringBuilder(StringUtils.defaultString((String)result.getMessage(), (String)""));
                List operateInfoList = result.getAllErrorOrValidateInfo();
                if (CollectionUtils.isNotEmpty((Collection)operateInfoList)) {
                    for (IOperateInfo info : operateInfoList) {
                        message.append("\r\n").append(info.getMessage());
                    }
                }
                errorInfo = message.toString();
            }
            errorInfo = StringUtils.substring((String)errorInfo, (int)0, (int)2048);
            MainEntityType logEntityType = EntityMetadataCache.getDataEntityType((String)"cas_refund_oplog");
            Date now = new Date();
            if (ArrayUtils.isEmpty((Object[])this.bills)) {
                DynamicObject logObj = this.buildLogBase(logEntityType, success, errorInfo, now);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
                return;
            }
            ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(this.bills.length);
            for (DynamicObject bill : this.bills) {
                DynamicObject logObj = this.buildLogBase(logEntityType, success, errorInfo, now);
                logObj.set("org", bill.get("org"));
                logObj.set("refundbillno", bill.get("billno"));
                logObj.set("refundbillid", bill.getPkValue());
                if ("ifm_transhandlebill".equals(this.billEntity)) continue;
                DynamicObject newBill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)this.billEntity, (String)"id,entry.id,entry.e_refundamt");
                Map<Long, DynamicObject> newBillEntryMap = newBill.getDynamicObjectCollection("entry").stream().collect(Collectors.toMap(e -> (Long)e.getPkValue(), e -> e));
                List<DynamicObject> refundEntryList = this.refundEntrys.get((Long)bill.getPkValue());
                if (CollectionUtils.isNotEmpty(refundEntryList)) {
                    DynamicCollectionProperty logEntryPro = (DynamicCollectionProperty)logEntityType.getProperty("entryentity");
                    DynamicObjectType logEntryType = logEntryPro.getDynamicCollectionItemPropertyType();
                    DynamicObjectCollection logEntryList = new DynamicObjectCollection(logEntryType, (Object)logObj);
                    for (DynamicObject refundEntry : refundEntryList) {
                        Long refundEntryId = (Long)refundEntry.getPkValue();
                        DynamicObject logEntry = new DynamicObject(logEntryType, (Object)DBServiceHelper.genGlobalLongId());
                        logEntry.set("lineno", refundEntry.get("seq"));
                        logEntry.set("rentryid", (Object)refundEntryId);
                        logEntry.set("amount", (Object)this.currentRefundAmt.getOrDefault(refundEntryId, BigDecimal.ZERO));
                        logEntry.set("beforerefundamt", refundEntry.get("e_refundamt"));
                        DynamicObject newBillEntry = newBillEntryMap.get(refundEntryId);
                        if (newBillEntry != null) {
                            logEntry.set("afterrefundamt", newBillEntry.get("e_refundamt"));
                        }
                        logEntryList.add((Object)logEntry);
                    }
                    logObj.set("entryentity", (Object)logEntryList);
                }
                logList.add(logObj);
            }
            SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
        }
        catch (Exception e2) {
            logger.error("RefundLogExecutor save log error", (Throwable)e2);
        }
    }

    private DynamicObject buildLogBase(MainEntityType logEntityType, boolean success, String errorInfo, Date now) {
        DynamicObject logObj = new DynamicObject((DynamicObjectType)logEntityType, (Object)DBServiceHelper.genGlobalLongId());
        logObj.set("billentity", (Object)this.billEntity);
        logObj.set("revbillno", (Object)this.revBillNo);
        logObj.set("revid", (Object)this.revId);
        logObj.set("operatetype", (Object)this.operate);
        logObj.set("opresult", (Object)(success ? "0" : "1"));
        logObj.set("errorlog", (Object)errorInfo);
        logObj.set("currency", this.currency);
        logObj.set("opdatetime", (Object)now);
        logObj.set("creater", (Object)UserServiceHelper.getCurrentUserId());
        logObj.set("traceid", (Object)RequestContext.get().getTraceId());
        return logObj;
    }

    private void buildBillFields(Long revId) {
        for (DynamicObject bill : this.bills) {
            DynamicObjectCollection refundRevList = bill.getDynamicObjectCollection("refundrevlist");
            HashSet<Long> entryIds = new HashSet<Long>(refundRevList.size());
            for (DynamicObject refundRev : refundRevList) {
                if (!revId.equals(refundRev.getLong("revid"))) continue;
                long pentryid = refundRev.getLong("pentryid");
                this.currentRefundAmt.put(pentryid, refundRev.getBigDecimal("refundamt"));
                entryIds.add(pentryid);
            }
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("entry");
            List refundEntryList = entryList.stream().filter(e -> entryIds.contains((Long)e.getPkValue())).collect(Collectors.toList());
            this.refundEntrys.put((Long)bill.getPkValue(), refundEntryList);
        }
    }
}

