/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.mock;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UserProp;
import kd.bos.util.StringUtils;
import kd.fi.cas.mock.DynamicObjectMocker;

public class DynamicObjectMockerHelper {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String BOS_CHECK_THREAD_CONTEXT = "bos.checkThreadContext";
    private static final List<String> NULL_FIELD_LIST = Arrays.asList("creator", "createtime", "modifier", "modifytime", "auditor", "auditdate");
    private static final List<String> BLACK_FIELD_LIST = Arrays.asList("billhead_lk", "masterid");

    public static String dynamicObjectToJson(DynamicObject entityData) {
        return DynamicObjectMockerHelper.dynamicObjectToJson(entityData, Collections.emptyList(), Boolean.TRUE);
    }

    public static String dynamicObjectToJson(DynamicObject[] entityDatas) {
        ArrayList<DynamicObject> entitys = new ArrayList<DynamicObject>(entityDatas.length);
        for (DynamicObject entityData : entityDatas) {
            entitys.add(DynamicObjectMockerHelper.updateEntityData(entityData, Boolean.TRUE, true, false));
        }
        return SerializationUtils.toJsonString(entitys, (boolean)Boolean.FALSE);
    }

    public static String dynamicObjectToJson(DynamicObjectCollection entityDatas) {
        ArrayList<DynamicObject> entitys = new ArrayList<DynamicObject>(entityDatas.size());
        for (DynamicObject entityData : entityDatas) {
            entitys.add(DynamicObjectMockerHelper.updateEntityData(entityData, Boolean.TRUE, true, false));
        }
        return SerializationUtils.toJsonString(entitys, (boolean)Boolean.FALSE);
    }

    public static String dynamicObjectToJson(DynamicObject entityData, List<String> selectProps, boolean includeEntry) {
        entityData = DynamicObjectMockerHelper.updateEntityData(entityData, includeEntry, true, false);
        String json = SerializationUtils.toJsonString((Object)entityData, (boolean)Boolean.FALSE);
        if (selectProps != null && !selectProps.isEmpty()) {
            Map map = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
            ArrayList keySet = new ArrayList(map.keySet());
            for (String key : keySet) {
                if (selectProps.contains(key)) continue;
                map.remove(key);
            }
            return SerializationUtils.toJsonString((Object)map);
        }
        return json;
    }

    private static DynamicObject updateEntityData(DynamicObject entityData, boolean includeEntry, boolean isRootEntity, boolean isEntryProp) {
        IDataEntityType entityType = entityData.getDataEntityType();
        DataEntityPropertyCollection properties = entityType.getProperties();
        DynamicObjectMocker mocker = new DynamicObjectMocker(entityType.getName());
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            Object data = entityData.get(name);
            if (BLACK_FIELD_LIST.contains(name) || property instanceof DynamicLocaleProperty || !isRootEntity && NULL_FIELD_LIST.contains(name) || name.endsWith("_id") || name.endsWith("_tag")) continue;
            if (data == null || NULL_FIELD_LIST.contains(name)) {
                mocker.add(name, null);
                continue;
            }
            if (property instanceof MuliLangTextProp) {
                mocker.add(name, ((OrmLocaleValue)data).getLocaleValue());
                continue;
            }
            if (property instanceof CurrencyProp) {
                mocker.add(name, DynamicObjectMockerHelper.getCurrencyData((DynamicObject)data));
                continue;
            }
            if (property instanceof OrgProp) {
                mocker.add(name, DynamicObjectMockerHelper.getOrgData((DynamicObject)data));
                continue;
            }
            if (property instanceof UserProp) {
                mocker.add(name, DynamicObjectMockerHelper.getOrgData((DynamicObject)data));
                continue;
            }
            if (property instanceof BasedataProp) {
                if (isEntryProp) {
                    mocker.add(name, DynamicObjectMockerHelper.getOrgData((DynamicObject)data));
                    continue;
                }
                mocker.add(name, DynamicObjectMockerHelper.updateEntityData((DynamicObject)data, includeEntry, false, isEntryProp));
                continue;
            }
            if (property instanceof EntryProp) {
                if (!includeEntry) {
                    mocker.add(name, null);
                    continue;
                }
                if (!(data instanceof DynamicObjectCollection)) continue;
                DynamicObjectCollection entryData = new DynamicObjectCollection();
                DynamicObjectCollection entrys = (DynamicObjectCollection)data;
                for (DynamicObject entry : entrys) {
                    entryData.add((Object)DynamicObjectMockerHelper.updateEntityData(entry, includeEntry, false, true));
                }
                mocker.add(name, entryData);
                continue;
            }
            mocker.add(name, data);
        }
        return mocker.getObject();
    }

    private static DynamicObject getOrgData(DynamicObject data) {
        DynamicObjectMocker mocker = new DynamicObjectMocker();
        mocker.add("id", data.get("id"));
        return mocker.getObject();
    }

    private static DynamicObject getCurrencyData(DynamicObject currency) {
        DynamicObjectMocker currencyMocker = new DynamicObjectMocker("bd_currency");
        currencyMocker.add("id", currency.get("id"));
        currencyMocker.add("number", currency.get("number"));
        currencyMocker.add("amtprecision", currency.get("amtprecision"));
        currencyMocker.add("priceprecision", currency.get("priceprecision"));
        currencyMocker.add("sign", currency.get("sign"));
        return currencyMocker.getObject();
    }

    public static DynamicObject jsonToDynamicObject(String entiyName, String json, boolean includeEntry) {
        Map map = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
        return DynamicObjectMockerHelper.map2DynamicObject(entiyName, map, includeEntry);
    }

    public static DynamicObject jsonToDynamicObject(String entiyName, String json) {
        return DynamicObjectMockerHelper.jsonToDynamicObject(entiyName, json, Boolean.TRUE);
    }

    public static DynamicObjectCollection jsonToDynamicObjectCollection(String entiyName, String json) {
        DynamicObjectMocker objectMocker = DynamicObjectMockerHelper.getDynamicObjectMocker(json, entiyName);
        return objectMocker.getCollection();
    }

    public static DataSet jsonToDataSet(String json) {
        List items = SerializationUtils.fromJsonStringToList((String)json, Map.class);
        return DynamicObjectMockerHelper.mapToDataSet(items);
    }

    public static DynamicObjectMocker getDynamicObjectMocker(String json, String entiyName) {
        List items = SerializationUtils.fromJsonStringToList((String)json, Map.class);
        DynamicObjectMocker objectMocker = new DynamicObjectMocker(entiyName);
        for (Map item : items) {
            objectMocker = objectMocker.insert();
            DynamicObjectMockerHelper.addDynamicObject(objectMocker, item, Boolean.FALSE);
        }
        return objectMocker;
    }

    public static DynamicObject map2DynamicObject(String entiyName, Map<String, Object> map, boolean includeEntry) {
        DynamicObjectMocker objectMocker = new DynamicObjectMocker(entiyName);
        DynamicObjectMockerHelper.addDynamicObject(objectMocker, map, includeEntry);
        return objectMocker.getObject();
    }

    private static void addDynamicObject(DynamicObjectMocker objectMocker, Map<String, Object> map, boolean includeEntry) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                objectMocker.add(key, DynamicObjectMockerHelper.map2DynamicObject(key, (Map)value, includeEntry));
                continue;
            }
            if (value instanceof List) {
                if (!includeEntry) continue;
                DynamicObjectCollection entryColls = new DynamicObjectCollection();
                List entrys = (List)value;
                for (Map objectMap : entrys) {
                    entryColls.add((Object)DynamicObjectMockerHelper.map2DynamicObject(null, objectMap, includeEntry));
                }
                objectMocker.add(key, entryColls);
                continue;
            }
            if (key.endsWith("date") && value instanceof String) {
                objectMocker.add(key, DynamicObjectMockerHelper.str2Date((String)value));
                continue;
            }
            if (key.endsWith("time") && value instanceof String) {
                objectMocker.add(key, DynamicObjectMockerHelper.str2DateTime((String)value));
                continue;
            }
            objectMocker.add(key, value);
        }
    }

    public static DynamicObject createDynamicObject(Long id) {
        DynamicObjectMocker mocker = new DynamicObjectMocker();
        mocker.add("id", id);
        return mocker.getObject();
    }

    public static DynamicObject createDynamicObject(Map<String, Object> map) {
        return DynamicObjectMockerHelper.map2DynamicObject(null, map, false);
    }

    public static DynamicObject createEmptyDynamicObject(String entityNumber, String ... props) {
        DynamicObjectMocker mocker = new DynamicObjectMocker(entityNumber);
        for (String prop : props) {
            mocker.add(prop, null);
        }
        return mocker.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet mapToDataSet(List<Map<String, Object>> items) {
        String context = System.getProperty(BOS_CHECK_THREAD_CONTEXT);
        System.setProperty(BOS_CHECK_THREAD_CONTEXT, "false");
        try {
            ArrayList datas = new ArrayList(10);
            List<Field> fields = DynamicObjectMockerHelper.getFields(items.get(0));
            for (Map<String, Object> item : items) {
                ArrayList<Object> values = new ArrayList<Object>(fields.size());
                for (Field field : fields) {
                    values.add(item.get(field.getName()));
                }
                datas.add(values);
            }
            RowMeta rowMeta = new RowMeta(fields.toArray(new Field[0]));
            Algo algo = Algo.create((String)("mapToDataSet" + System.currentTimeMillis()));
            DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
            for (List list : datas) {
                dsBuilder.append(list.toArray());
            }
            Iterator<Object> iterator = dsBuilder.build();
            return iterator;
        }
        finally {
            if (context != null) {
                System.setProperty(BOS_CHECK_THREAD_CONTEXT, context);
            }
        }
    }

    private static List<Field> getFields(Map<String, Object> item) {
        ArrayList<Field> fields = new ArrayList<Field>(item.size());
        for (Map.Entry<String, Object> entry : item.entrySet()) {
            Field field;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Long) {
                field = new Field(key, (DataType)DataType.LongType, true);
            } else if (value instanceof Integer) {
                field = new Field(key, (DataType)DataType.IntegerType, true);
            } else if (value instanceof String) {
                field = new Field(key, (DataType)DataType.StringType, true);
            } else if (value instanceof Boolean) {
                field = new Field(key, (DataType)DataType.BooleanType, true);
            } else if (value instanceof Timestamp) {
                field = new Field(key, (DataType)DataType.TimestampType, true);
            } else if (value instanceof Date) {
                field = new Field(key, (DataType)DataType.DateType, true);
            } else if (value instanceof Double) {
                field = new Field(key, (DataType)DataType.DoubleType, true);
            } else {
                if (!(value instanceof BigDecimal)) continue;
                field = new Field(key, (DataType)DataType.BigDecimalType, true);
            }
            fields.add(field);
        }
        return fields;
    }

    public static String datasetToJson(DataSet dataSet) {
        ArrayList datas = new ArrayList(10);
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        while (dataSet.hasNext()) {
            HashMap<String, Object> map = new HashMap<String, Object>(10);
            Row next = dataSet.next();
            for (String fieldName : fieldNames) {
                map.put(fieldName, next.get(fieldName));
            }
            datas.add(map);
        }
        return SerializationUtils.toJsonString(datas);
    }

    private static Object str2Date(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        try {
            return DATE_FORMAT.parse(value);
        }
        catch (Exception e) {
            return value;
        }
    }

    private static Object str2DateTime(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        try {
            return DATETIME_FORMAT.parse(value);
        }
        catch (Exception e) {
            return value;
        }
    }
}

