/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.pojo;

import java.io.Serializable;
import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.cas.helper.AgentPayBillHelper;

public class ReceiptRefund
implements Serializable {
    private long id;
    private String targetBillType;
    private String billNo;
    private String payerAccountBank;
    private long currency;
    private BigDecimal paymentAmt;
    private String payee;
    private String payeeBankNum;
    private String description;
    private String usage;
    private String sourceBillType;
    private String billType;
    private Long entryid;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getTargetBillType() {
        return this.targetBillType;
    }

    public void setTargetBillType(String targetBillType) {
        this.targetBillType = targetBillType;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public String getPayerAccountBank() {
        return this.payerAccountBank;
    }

    public void setPayerAccountBank(String payerAccountBank) {
        this.payerAccountBank = payerAccountBank;
    }

    public long getCurrency() {
        return this.currency;
    }

    public void setCurrency(long currency) {
        this.currency = currency;
    }

    public BigDecimal getPaymentAmt() {
        return this.paymentAmt;
    }

    public void setPaymentAmt(BigDecimal paymentAmt) {
        this.paymentAmt = paymentAmt;
    }

    public String getPayee() {
        return this.payee;
    }

    public void setPayee(String payee) {
        this.payee = payee;
    }

    public String getPayeeBankNum() {
        return this.payeeBankNum;
    }

    public void setPayeeBankNum(String payeeBankNum) {
        this.payeeBankNum = payeeBankNum;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getSourceBillType() {
        return this.sourceBillType;
    }

    public void setSourceBillType(String sourceBillType) {
        this.sourceBillType = sourceBillType;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public Long getEntryid() {
        return this.entryid;
    }

    public void setEntryid(Long entryid) {
        this.entryid = entryid;
    }

    public ReceiptRefund(long id, String targetBillType, String billNo, String payerAccountBank, long currency, BigDecimal paymentAmt, String payee, String payeeBankNum, String description, String usage, String sourceBillType, String billType) {
        this.id = id;
        this.targetBillType = targetBillType;
        this.billNo = billNo;
        this.payerAccountBank = payerAccountBank;
        this.currency = currency;
        this.paymentAmt = paymentAmt;
        this.payee = payee;
        this.payeeBankNum = payeeBankNum;
        this.description = description;
        this.usage = usage;
        this.sourceBillType = sourceBillType;
        this.billType = billType;
    }

    public ReceiptRefund(DynamicObject payBillOrIfmTransBill, String entityType) {
        if ("cas_paybill".equals(entityType)) {
            this.id = payBillOrIfmTransBill.getLong("id");
            this.targetBillType = "cas_paybill";
            this.billNo = payBillOrIfmTransBill.getString("billno");
            this.payerAccountBank = payBillOrIfmTransBill.getString("payeracctbank.bankaccountnumber");
            this.currency = payBillOrIfmTransBill.getLong("dpcurrency.id");
            this.paymentAmt = payBillOrIfmTransBill.getBigDecimal("dpamt");
            this.payee = payBillOrIfmTransBill.getString("payeename");
            this.payeeBankNum = payBillOrIfmTransBill.getString("payeebanknum");
            this.description = payBillOrIfmTransBill.getString("description");
            this.usage = payBillOrIfmTransBill.getString("usage");
            this.sourceBillType = payBillOrIfmTransBill.getString("sourcebilltype");
            this.billType = "cas_paybill";
        } else if ("ifm_transhandlebill".equals(entityType)) {
            this.id = payBillOrIfmTransBill.getLong("id");
            this.targetBillType = "ifm_transhandlebill";
            this.billNo = payBillOrIfmTransBill.getString("billno");
            this.payerAccountBank = payBillOrIfmTransBill.getString("payeracctbank.number");
            this.currency = payBillOrIfmTransBill.getLong("currency.id");
            this.paymentAmt = payBillOrIfmTransBill.getBigDecimal("actpayamt");
            this.payee = payBillOrIfmTransBill.getString("payeename");
            this.payeeBankNum = payBillOrIfmTransBill.getString("payeebanknum");
            this.description = payBillOrIfmTransBill.getString("description");
            this.usage = payBillOrIfmTransBill.getString("usage");
            this.sourceBillType = payBillOrIfmTransBill.getString("sourcebilltype");
            this.billType = "ifm_transhandlebill";
        }
    }

    public ReceiptRefund(DynamicObject agentBill, DynamicObject agentEntry) {
        this.id = agentBill.getLong("id");
        this.targetBillType = "cas_agentpaybill";
        this.billNo = agentBill.getString("billno");
        this.payerAccountBank = agentBill.getString("payeracctbank.bankaccountnumber");
        this.currency = agentBill.getLong("currency.id");
        BigDecimal payAmt = AgentPayBillHelper.decodeAmount(agentEntry.getString("e_encryptamount"));
        if (agentBill.getBoolean("isencryption")) {
            payAmt = null;
        }
        this.paymentAmt = payAmt;
        this.payee = agentEntry.getString("payeename");
        this.payeeBankNum = agentEntry.getString("payeeacctbank");
        this.description = agentBill.getString("description");
        this.usage = agentEntry.getString("e_remark");
        this.sourceBillType = agentBill.getString("sourcebilltype");
        this.billType = "cas_agentpaybill";
        this.entryid = agentEntry.getLong("id");
    }

    public ReceiptRefund(DynamicObject agentBill) {
        this.id = agentBill.getLong("id");
        this.targetBillType = "cas_agentpaybill";
        this.billNo = agentBill.getString("billno");
        this.payerAccountBank = agentBill.getString("payeracctbank.bankaccountnumber");
        this.currency = agentBill.getLong("currency.id");
        BigDecimal payAmt = AgentPayBillHelper.decodeAmount(agentBill.getString("entry.e_encryptamount"));
        if (agentBill.getBoolean("isencryption")) {
            payAmt = null;
        }
        this.paymentAmt = payAmt;
        this.payee = agentBill.getString("entry.payeename");
        this.payeeBankNum = agentBill.getString("entry.payeeacctbank");
        this.description = agentBill.getString("description");
        this.usage = agentBill.getString("entry.e_remark");
        this.sourceBillType = agentBill.getString("sourcebilltype");
        this.billType = "cas_agentpaybill";
        this.entryid = agentBill.getLong("entry.id");
    }

    public ReceiptRefund() {
    }
}

