/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.fi.cas.errorcode.ErrorCodeUtils;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EntityMetadataUtils;

public class CheckUtils {
    public static String checkEmpty(DynamicObject info, List<String> checkFields) {
        StringBuilder errMsg = null;
        List<IDataEntityProperty> mustInputFields = CheckUtils.getMustInputFields(info.getDataEntityType(), false);
        errMsg = CheckUtils.checkProEmpty(mustInputFields, checkFields, info);
        StringBuilder entryCheckInfo = new StringBuilder();
        EntryProp entryProp = EntityMetadataUtils.getEntryProp(info.getDataEntityType());
        if (entryProp != null) {
            info.getDataEntityType();
            List<IDataEntityProperty> entryMustInputFields = CheckUtils.getMustInputFields((IDataEntityType)entryProp._collectionItemPropertyType, false);
            DynamicObjectCollection entry = info.getDynamicObjectCollection(entryProp.getName());
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject rowInfo = (DynamicObject)entry.get(i);
                StringBuilder rowMessage = CheckUtils.checkProEmpty(entryMustInputFields, checkFields, rowInfo);
                if (rowMessage.length() <= 0) continue;
                rowMessage.deleteCharAt(rowMessage.length() - 1);
                rowMessage.append('\uff01');
                String rowTitle = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55-", (String)"CheckUtils_0", (String)"fi-cas-common", (Object[])new Object[0]), i + 1);
                rowMessage.insert(0, rowTitle);
                entryCheckInfo.append((CharSequence)rowMessage).append('\n');
            }
        }
        if (entryCheckInfo.length() > 0) {
            errMsg.append((CharSequence)entryCheckInfo);
        }
        return errMsg.toString();
    }

    private static StringBuilder checkProEmpty(List<IDataEntityProperty> mustInputFields, List<String> checkFields, DynamicObject dynamicInfo) {
        StringBuilder checkMsg = new StringBuilder();
        for (IDataEntityProperty pro : mustInputFields) {
            boolean check = true;
            if (checkFields != null) {
                check = checkFields.contains(pro.getName());
            }
            if (!check || !CasHelper.isEmpty(pro.getValueFast((Object)dynamicInfo))) continue;
            String displayName = ((DynamicProperty)pro).getDisplayName().getLocaleValue();
            String message = null;
            message = pro instanceof AmountProp ? String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u62160", (String)"CheckUtils_1", (String)"fi-cas-common", (Object[])new Object[0]), displayName) : String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"CheckUtils_2", (String)"fi-cas-common", (Object[])new Object[0]), displayName);
            checkMsg.append(message);
            if (dynamicInfo.getDataEntityType() instanceof EntryType) {
                checkMsg.append('\uff0c');
                continue;
            }
            checkMsg.append('\n');
        }
        return checkMsg;
    }

    public static List<IDataEntityProperty> getMustInputFields(IDataEntityType dataType, boolean containsEntryFileds) {
        ArrayList<IDataEntityProperty> proList = new ArrayList<IDataEntityProperty>();
        for (IDataEntityProperty pro : dataType.getProperties()) {
            if (pro instanceof EntryProp && containsEntryFileds) {
                proList.addAll(CheckUtils.getMustInputFields((IDataEntityType)((EntryProp)pro)._collectionItemPropertyType, containsEntryFileds));
            }
            if (!CheckUtils.isMustInput(pro)) continue;
            proList.add(pro);
        }
        return proList;
    }

    public static boolean isMustInput(IDataEntityProperty pro) {
        if (pro instanceof FieldProp) {
            return ((FieldProp)pro).isMustInput();
        }
        if (pro instanceof BasedataProp) {
            return ((BasedataProp)pro).isMustInput();
        }
        if (pro instanceof EntryProp) {
            return ((EntryProp)pro).isEntryMustInput();
        }
        throw new KDException(new ErrorCode("UNKNOWN_PROPERTY_TYPE", ResManager.loadKDString((String)"\u672a\u77e5\u7684property\u7c7b\u578b:%1$s\uff0c\u5bf9\u5e94\u5b57\u6bb5\uff1a%2$s", (String)"CheckUtils_3", (String)"fi-cas-common", (Object[])new Object[0])), new Object[]{pro.getPropertyType(), pro.getName()});
    }

    public static void setPropMustInput(DynamicObject info, boolean mustInput, String ... fields) {
        CheckUtils.setMustInput(info.getDataEntityType(), mustInput, fields);
    }

    private static void setMustInput(IDataEntityType dataEntityType, boolean mustInput, String ... fields) {
        for (IDataEntityProperty next : dataEntityType.getProperties()) {
            if (next instanceof EntryProp) {
                CheckUtils.setMustInput((IDataEntityType)((EntryProp)next)._collectionItemPropertyType, mustInput, fields);
                continue;
            }
            for (String field : fields) {
                if (!next.getName().equals(field)) continue;
                CheckUtils.setPropMustInput(next, mustInput);
            }
        }
    }

    private static void setPropMustInput(IDataEntityProperty pro, boolean mustInput) {
        if (pro instanceof FieldProp) {
            ((FieldProp)pro).setMustInput(mustInput);
        } else if (pro instanceof BasedataProp) {
            ((BasedataProp)pro).setMustInput(mustInput);
        } else if (pro instanceof EntryProp) {
            ((EntryProp)pro).setEntryMustInput(mustInput);
        } else {
            throw new KDException(new ErrorCode("UNKNOWN_PROPERT_YTYPE", ResManager.loadKDString((String)"\u672a\u77e5\u7684property\u7c7b\u578b:%1$s\uff0c\u5bf9\u5e94\u5b57\u6bb5\uff1a%2$s", (String)"CheckUtils_3", (String)"fi-cas-common", (Object[])new Object[0])), new Object[]{pro.getPropertyType(), pro.getName()});
        }
    }

    public static void checkTextLength(DynamicObject info) {
        List<TextProp> textProps = CheckUtils.getTextProp(info.getDataEntityType(), false);
        for (TextProp prop : textProps) {
            String checkResult = CheckUtils.checkTextLength(prop, info);
            if (checkResult == null) continue;
            ErrorCode errorCode = ErrorCodeUtils.create("Filed out of length", "%s");
            throw new KDBizException(errorCode, new Object[]{checkResult});
        }
        EntryProp entryProp = EntityMetadataUtils.getEntryProp(info.getDataEntityType());
        if (entryProp != null) {
            List<TextProp> entryTextProps = CheckUtils.getTextProp((IDataEntityType)entryProp._collectionItemPropertyType, false);
            DynamicObjectCollection entry = info.getDynamicObjectCollection(entryProp.getName());
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject row = (DynamicObject)entry.get(i);
                for (TextProp prop : entryTextProps) {
                    String checkResult = CheckUtils.checkTextLength(prop, row);
                    if (checkResult == null) continue;
                    ErrorCode errorCode = ErrorCodeUtils.create("Filed out of length", ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff0c%2$s", (String)"CheckUtils_4", (String)"fi-cas-common", (Object[])new Object[0]));
                    throw new KDBizException(errorCode, new Object[]{i + 1, checkResult});
                }
            }
        }
    }

    private static String checkTextLength(TextProp prop, DynamicObject info) {
        int actLength;
        int maxLenth = prop.getMaxLenth();
        Object value = prop.getValueFast((Object)info);
        int n = actLength = value == null ? 0 : value.toString().length();
        if (actLength > maxLenth) {
            String message = ResManager.loadKDString((String)"%1$s\u5b57\u6bb5\u957f\u5ea6\u8d85\u957f\uff0c\u5141\u8bb8\u6700\u5927\u957f\u5ea6%2$s\uff0c\u5b9e\u9645\u957f\u5ea6%3$s", (String)"CheckUtils_5", (String)"fi-cas-common", (Object[])new Object[0]);
            return String.format(message, prop.getDisplayName().getLocaleValue(), maxLenth, actLength);
        }
        return null;
    }

    private static List<TextProp> getTextProp(IDataEntityType dataType, boolean containsEntryFileds) {
        ArrayList<TextProp> textProps = new ArrayList<TextProp>();
        for (IDataEntityProperty prop : dataType.getProperties()) {
            if (prop instanceof EntryProp && containsEntryFileds) {
                textProps.addAll(CheckUtils.getTextProp((IDataEntityType)((EntryProp)prop)._collectionItemPropertyType, containsEntryFileds));
            }
            if (!(prop instanceof TextProp)) continue;
            textProps.add((TextProp)prop);
        }
        return textProps;
    }

    public static String bankNumberCheck(String value) {
        value = value.replaceAll("\r|\n|\\s", "");
        return value;
    }

    public static String removeSpaces(String value) {
        value = value.trim();
        value = value.replaceAll("\r|\n", "");
        return value;
    }

    public static void checkBizTypeEmpty(DynamicObject billObject) {
        String formId = billObject.getDataEntityType().getName();
        String type = Arrays.asList("cas_paybill", "cas_agentpaybill").contains(formId) ? "paymenttype" : "receivingtype";
        DynamicObject pt = billObject.getDynamicObject(type);
        String biztype = Optional.ofNullable(pt).map(value -> value.getString("biztype")).orElse(null);
        if (StringUtils.isEmpty((CharSequence)biztype)) {
            if (Arrays.asList("cas_paybill", "cas_agentpaybill").contains(formId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"CheckUtils_6", (String)"fi-cas-common", (Object[])new Object[0]));
            }
            if ("cas_recbill".equals(formId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u6536\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"CheckUtils_7", (String)"fi-cas-common", (Object[])new Object[0]));
            }
        }
    }

    public static String checkBizType(DynamicObject billObject) {
        String errorMsg = null;
        String entityName = billObject.getDataEntityType().getName();
        boolean paymentType = "cas_paybill".equals(entityName) || "cas_agentpaybill".equals(entityName);
        String type = paymentType ? "paymenttype" : "receivingtype";
        DynamicObject pt = billObject.getDynamicObject(type);
        String bizType = Optional.ofNullable(pt).map(value -> value.getString("biztype")).orElse(null);
        if (StringUtils.isEmpty((CharSequence)bizType)) {
            if (paymentType) {
                errorMsg = ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"CheckUtils_6", (String)"fi-cas-common", (Object[])new Object[0]);
            } else if ("cas_recbill".equals(entityName)) {
                errorMsg = ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u6536\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"CheckUtils_7", (String)"fi-cas-common", (Object[])new Object[0]);
            }
        }
        return errorMsg;
    }

    public static String checkAmtEqualEAmt(DynamicObject billObject, String amount, String e_amount) {
        BigDecimal e_amountSum = BigDecimal.ZERO;
        e_amountSum = "cas_agentpaybill".equals(billObject.getDataEntityType().getName()) && billObject.getBoolean("isencryption") ? billObject.getDynamicObjectCollection("entry").stream().map(v -> AgentPayBillHelper.decodeAmount(v.getString(e_amount))).reduce(BigDecimal.ZERO, BigDecimal::add) : billObject.getDynamicObjectCollection("entry").stream().map(v -> v.getBigDecimal(e_amount)).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (e_amountSum.compareTo(billObject.getBigDecimal(amount)) != 0) {
            return ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u4e0e\u660e\u7ec6\u5206\u5f55\u4e2d\u91d1\u989d\u4e4b\u548c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"CheckUtils_8", (String)"fi-cas-common", (Object[])new Object[0]);
        }
        return null;
    }
}

