/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.util.EmptyUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CreateExcelUtil {
    private static final Log logger = LogFactory.getLog(CreateExcelUtil.class);
    private static final int maxLength = 50;

    public static void createExcelFile(SXSSFWorkbook wb, String sheetName, String[] exportTitle, List<Map<String, Object>> exportEntity) {
        if (wb == null || exportTitle.length == 0) {
            return;
        }
        int count = 1;
        DataFormat decimalDataFormat = wb.createDataFormat();
        CellStyle styleYellow1 = wb.createCellStyle();
        CellStyle styleYellow2 = wb.createCellStyle();
        styleYellow1.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        styleYellow1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleYellow1.setAlignment(HorizontalAlignment.RIGHT);
        styleYellow1.setDataFormat(decimalDataFormat.getFormat("#,##0.0000"));
        styleYellow2.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        styleYellow2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleYellow2.setAlignment(HorizontalAlignment.RIGHT);
        styleYellow2.setDataFormat(decimalDataFormat.getFormat("#,##0.00"));
        CellStyle dateStyle = wb.createCellStyle();
        DataFormat createDataFormat = wb.createDataFormat();
        dateStyle.setDataFormat(createDataFormat.getFormat("yyyy/MM/dd"));
        CellStyle rowDataStyle1 = wb.createCellStyle();
        rowDataStyle1.setAlignment(HorizontalAlignment.RIGHT);
        rowDataStyle1.setDataFormat(decimalDataFormat.getFormat("#,##0.0000"));
        CellStyle rowDataStyle2 = wb.createCellStyle();
        rowDataStyle2.setAlignment(HorizontalAlignment.RIGHT);
        rowDataStyle2.setDataFormat(decimalDataFormat.getFormat("#,##0.00"));
        SXSSFSheet sheet = StringUtils.isNotEmpty((CharSequence)sheetName) ? wb.createSheet(sheetName) : wb.createSheet("sheet1");
        SXSSFRow createRow = sheet.createRow(0);
        ArrayList<Integer> columnLength = new ArrayList<Integer>();
        for (int i = 0; i < exportTitle.length; ++i) {
            SXSSFCell createCell = createRow.createCell(i);
            createCell.setCellValue(exportTitle[i]);
            try {
                columnLength.add(CreateExcelUtil.getCellLength(exportTitle[i]) * 256);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
                columnLength.add(3072);
            }
        }
        int curLength = 8;
        StringBuilder amountAccuracy = new StringBuilder();
        StringBuilder tempStr = new StringBuilder();
        int dateLength = 12;
        for (Map<String, Object> dynObj : exportEntity) {
            int amtprecision = 4;
            createRow = sheet.createRow(count);
            boolean headCount = false;
            String cellValue = "";
            Object amtPrecisionObj = dynObj.remove("amtprecision");
            if (EmptyUtil.isNoEmpty(amtPrecisionObj)) {
                amtprecision = Integer.parseInt(amtPrecisionObj.toString());
            }
            ArrayList<Map.Entry<String, Object>> indexedList = new ArrayList<Map.Entry<String, Object>>(dynObj.entrySet());
            for (int i = 0; i < dynObj.size(); ++i) {
                amountAccuracy = new StringBuilder();
                amountAccuracy.append("0.");
                Object fieldValue = ((Map.Entry)indexedList.get(i)).getValue();
                SXSSFCell createCell = createRow.createCell(i);
                curLength = 8;
                try {
                    if (fieldValue != null) {
                        if (fieldValue instanceof String) {
                            cellValue = fieldValue.toString();
                            createCell.setCellValue(cellValue);
                            curLength = CreateExcelUtil.getCellLength(cellValue);
                        } else if (fieldValue instanceof BigDecimal) {
                            String str1 = fieldValue.toString();
                            StringBuilder tempString = new StringBuilder();
                            if (StringUtils.equals((CharSequence)sheetName, (CharSequence)ResManager.loadKDString((String)"\u5df2\u5bf9\u8d26\u7ed3\u679c", (String)"CreateExcelUtil_0", (String)"fi-cas-common", (Object[])new Object[0])) && ((BigDecimal)fieldValue).compareTo(BigDecimal.ZERO) == 0) continue;
                            if (dynObj.get("currency") != null || dynObj.get("currency.name") != null) {
                                if (StringUtils.equals((CharSequence)sheetName, (CharSequence)ResManager.loadKDString((String)"\u4f59\u989d\u8c03\u8282\u8868", (String)"CreateExcelUtil_2", (String)"fi-cas-common", (Object[])new Object[0])) && StringUtils.equals((CharSequence)exportTitle[i], (CharSequence)ResManager.loadKDString((String)"\u5dee\u5f02", (String)"CreateExcelUtil_3", (String)"fi-cas-common", (Object[])new Object[0])) && ((BigDecimal)fieldValue).compareTo(BigDecimal.ZERO) != 0) {
                                    if (amtprecision == 4) {
                                        createCell.setCellStyle(styleYellow1);
                                    } else {
                                        createCell.setCellStyle(styleYellow2);
                                    }
                                } else if (amtprecision == 4) {
                                    createCell.setCellStyle(rowDataStyle1);
                                } else {
                                    createCell.setCellStyle(rowDataStyle2);
                                }
                                tempString.append("0000");
                            } else {
                                if (StringUtils.equals((CharSequence)sheetName, (CharSequence)ResManager.loadKDString((String)"\u4f59\u989d\u8c03\u8282\u8868", (String)"CreateExcelUtil_2", (String)"fi-cas-common", (Object[])new Object[0])) && StringUtils.equals((CharSequence)exportTitle[i], (CharSequence)ResManager.loadKDString((String)"\u5dee\u5f02", (String)"CreateExcelUtil_3", (String)"fi-cas-common", (Object[])new Object[0])) && ((BigDecimal)fieldValue).compareTo(BigDecimal.ZERO) != 0) {
                                    createCell.setCellStyle(styleYellow2);
                                } else {
                                    createCell.setCellStyle(rowDataStyle2);
                                }
                                tempString.append("00");
                            }
                            BigDecimal tempAmount = (BigDecimal)fieldValue;
                            createCell.setCellValue(tempAmount.doubleValue());
                            tempString.append(tempAmount.intValue());
                            tempString.append("000000");
                            curLength = CreateExcelUtil.getCellLength(tempString.toString());
                        } else if (fieldValue instanceof Date) {
                            Date date = (Date)fieldValue;
                            createCell.setCellValue(date);
                            createCell.setCellStyle(dateStyle);
                            curLength = dateLength;
                        } else if (fieldValue instanceof Boolean) {
                            if (((Boolean)fieldValue).booleanValue()) {
                                createCell.setCellValue("\u221a");
                            }
                        } else if (fieldValue instanceof OrmLocaleValue) {
                            cellValue = ((OrmLocaleValue)fieldValue).getLocaleValue();
                            createCell.setCellValue(cellValue);
                            curLength = CreateExcelUtil.getCellLength(cellValue);
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                columnLength.set(i, Math.max((Integer)columnLength.get(i), curLength * 256));
            }
            ++count;
        }
        for (int i = 0; i < exportTitle.length; ++i) {
            int length = (Integer)columnLength.get(i) / 256;
            if (length > 50) {
                sheet.setColumnWidth(i, 12800);
                continue;
            }
            sheet.setColumnWidth(i, ((Integer)columnLength.get(i)).intValue());
        }
    }

    public static int getCellLength(String str) throws UnsupportedEncodingException {
        return str.getBytes("GBK").length + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(SXSSFWorkbook wb, String formName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(formName, (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public static String getTempFilename(String formName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        String currDateTime = dateFormat.format(new Date());
        String userName = RequestContext.get().getUserName();
        return formName + "-" + currDateTime + "-" + userName + ".xlsx";
    }

    public static String getTempFilename1(String formName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String currDateTime = dateFormat.format(new Date());
        return formName + "_" + currDateTime + ".xlsx";
    }
}

