/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.util;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import org.apache.commons.codec.binary.Base64;

public class StringUtils {
    public static boolean isEmpty(String string) {
        return StringUtils.isNull(string) || StringUtils.isBlank(string);
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static String getEmpty() {
        return "";
    }

    public static boolean isNull(String string) {
        return string == null;
    }

    public static boolean isNotNull(String string) {
        return !StringUtils.isNull(string);
    }

    public static boolean isBlank(String string) {
        return StringUtils.isNotNull(string) && string.trim().length() == 0;
    }

    public static String trim(String string) {
        return StringUtils.isNull(string) ? StringUtils.getEmpty() : string.trim();
    }

    public static String formatMessage(String msg, Object[] params) {
        return MessageFormat.format(msg, params);
    }

    public static String setToString(Set<? extends Object> valueSet) {
        StringBuilder returnValue = new StringBuilder("(");
        if (valueSet != null && valueSet.size() != 0) {
            Iterator<? extends Object> it = valueSet.iterator();
            boolean flag = false;
            String tempValue = null;
            Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                tempValue = obj instanceof String ? (String)obj : obj.toString();
                if (tempValue == null || tempValue.trim().length() == 0) continue;
                if (flag) {
                    returnValue.append(',');
                }
                returnValue.append('\'');
                returnValue.append(tempValue);
                returnValue.append('\'');
                flag = true;
            }
        } else {
            returnValue.append("'null'");
        }
        returnValue.append(')');
        return returnValue.toString();
    }

    public static String splitString(String number, int step, String split) {
        String value = null;
        if (!StringUtils.isEmpty(number)) {
            while (number.length() > 0) {
                int cutStep = step;
                if (step > number.length()) {
                    cutStep = number.length();
                }
                value = StringUtils.isEmpty(value) ? number.substring(0, cutStep) : value + split + number.substring(0, cutStep);
                number = number.substring(cutStep);
            }
        }
        return value;
    }

    public static String toBase64String(byte[] bytes) {
        return new String(Base64.encodeBase64((byte[])bytes));
    }

    public static byte[] decodeBase64(String base64String) {
        return Base64.decodeBase64((String)base64String);
    }

    public static Object[] getPks(DynamicObject[] objArray) {
        if (objArray == null || objArray.length == 0) {
            return new Object[0];
        }
        Object[] pks = new Object[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            pks[i] = objArray[i].getPkValue();
        }
        return pks;
    }

    public static Boolean equalAllValues(String compare, String[] compareValues) {
        Boolean result = false;
        for (String compareValue : compareValues) {
            if (!compare.equals(compareValue)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String joinKeyString(String split, Object ... names) {
        if (split == null || "".equals(split)) {
            split = "_";
        }
        StringBuilder builder = new StringBuilder();
        for (Object name : names) {
            builder.append(name).append(split);
        }
        String result = builder.toString();
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

