/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.mservice.digit.handler.bankstatement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.mservice.digit.ICombineDataProcessHandler;

public class ThisMonthBankStatementProcessHandler
implements ICombineDataProcessHandler {
    @Override
    public List<Map<String, String>> combineData() {
        Tuple<Date, Date> dateRange = this.getThisMonthDateRange();
        Date startDate = (Date)dateRange.item1;
        Date endDate = (Date)dateRange.item2;
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>(3);
        QFilter qFilter = new QFilter("checkdate", ">=", (Object)startDate).and(new QFilter("checkdate", "<", (Object)endDate));
        DynamicObject[] bankStatement = BusinessDataServiceHelper.load((String)"cas_checkedresult", (String)"id,checktype", (QFilter[])new QFilter[]{qFilter});
        int lastPayEntryCount = bankStatement != null ? bankStatement.length : 0;
        data.add(this.buildData(ResManager.loadKDString((String)"\u672c\u6708\u5bf9\u8d26\u603b\u6570", (String)"ThisMonthBankStatementProcessHandler_01", (String)"fi-cas-mservice", (Object[])new Object[0]), String.valueOf(lastPayEntryCount), "bydzzs", true));
        List checkTypeList = Arrays.stream(bankStatement).filter(o -> "byauto".equalsIgnoreCase(o.getString("checktype"))).collect(Collectors.toList());
        data.add(this.buildData(ResManager.loadKDString((String)"\u672c\u6708\u81ea\u52a8\u5bf9\u8d26\u6570", (String)"ThisMonthBankStatementProcessHandler_02", (String)"fi-cas-mservice", (Object[])new Object[0]), String.valueOf(checkTypeList.size()), "byzddzs", true));
        int percent = 0;
        if (lastPayEntryCount > 0) {
            percent = (int)Math.ceil((float)checkTypeList.size() * 1.0f / (float)lastPayEntryCount * 100.0f);
        }
        data.add(this.buildData(ResManager.loadKDString((String)"\u672c\u6708\u667a\u80fd\u5bf9\u8d26\u5360\u6bd4", (String)"ThisMonthBankStatementProcessHandler_03", (String)"fi-cas-mservice", (Object[])new Object[0]), String.valueOf(percent), "byzndzzb", false));
        return data;
    }
}

