/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.calculate;

import java.util.Map;
import kd.fi.cas.business.balancemodel.calculate.AntiCalculateBalance;
import kd.fi.cas.business.balancemodel.calculate.ICalculateBalance;
import kd.fi.cas.business.balancemodel.calculate.InitCalculateBalance;
import kd.fi.cas.business.balancemodel.calculate.LogCalculateBalance;
import kd.fi.cas.business.balancemodel.calculate.RecalculateBalance;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceData;

public class CalculateServiceFactory {
    public static CalculateServiceFactory getInstance() {
        return Singleton.INSTANCE;
    }

    private CalculateServiceFactory() {
    }

    public ICalculateBalance getBean(String operationType, Map<String, BalanceData> dataSourceBalances, Map<String, BalanceData> dealBalanceData) {
        switch (operationType) {
            case "BALANCE_LOG": {
                return new LogCalculateBalance(dataSourceBalances, dealBalanceData);
            }
            case "BALANCE_RECALCULATE": {
                return new RecalculateBalance(dataSourceBalances, dealBalanceData);
            }
            case "BALANCE_INIT": {
                return new InitCalculateBalance(dataSourceBalances, dealBalanceData);
            }
            case "BALANCE_ANTI_INIT": {
                return new AntiCalculateBalance(dataSourceBalances, dealBalanceData);
            }
        }
        return null;
    }

    static class Singleton {
        private static final CalculateServiceFactory INSTANCE = new CalculateServiceFactory();

        Singleton() {
        }
    }
}

