/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.calculate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.fi.cas.business.balancemodel.calculate.AbstractCalculateBalance;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceData;
import kd.fi.cas.business.balancemodel.calculate.util.BalanceUtil;
import kd.fi.cas.util.DateUtils;

public class RecalculateBalance
extends AbstractCalculateBalance {
    private BigDecimal payDiff;
    private BigDecimal recDiff;

    public RecalculateBalance(Map<String, BalanceData> dataSourceBalances, Map<String, BalanceData> dealBalanceData) {
        super(dataSourceBalances, dealBalanceData);
    }

    @Override
    protected BigDecimal doUpdateBalance(BalanceData sourceBalanceData, Balance balance) throws Exception {
        Balance preBalance;
        Set<Date> dates = sourceBalanceData.getStartDates();
        Date startDate = balance.getStartDate();
        Balance sourceBalance = sourceBalanceData.getBalance(startDate);
        BigDecimal sourceMonthBalance = sourceBalance.getMonthBalance();
        BigDecimal sourceMonthStart = sourceBalance.getMonthStart();
        BigDecimal sourceYearStart = BalanceUtil.dealBigDecimal(sourceBalance.getYearStart());
        BigDecimal sourceYearPayAmount = BalanceUtil.dealBigDecimal(sourceBalance.getYearPayAmount());
        BigDecimal sourceYearRecAmount = BalanceUtil.dealBigDecimal(sourceBalance.getYearRecAmount());
        BigDecimal sourcePayAmount = BalanceUtil.dealBigDecimal(sourceBalance.getPayAmount());
        BigDecimal sourceRecAmount = BalanceUtil.dealBigDecimal(sourceBalance.getRevenueAmount());
        BigDecimal monthBalance = balance.getMonthBalance();
        BigDecimal payAmount = balance.getPayAmount();
        BigDecimal revenueAmount = balance.getRevenueAmount();
        int stroke = balance.getStroke() == null ? 0 : balance.getStroke();
        BigDecimal difference = BigDecimal.ZERO;
        Date preDate = DateUtils.preDate(dates, (Date)startDate);
        if (preDate.getTime() < startDate.getTime() && (preBalance = sourceBalanceData.getBalance(preDate)) != null) {
            BigDecimal preMonthBalance;
            sourceMonthStart = preMonthBalance = preBalance.getMonthBalance();
        }
        BigDecimal reCalMonthBalance = sourceMonthStart.add(monthBalance);
        difference = difference.add(reCalMonthBalance.subtract(sourceMonthBalance));
        balance.setMonthStart(sourceMonthStart);
        balance.setMonthBalance(reCalMonthBalance);
        balance.setPayAmount(payAmount);
        balance.setRevenueAmount(revenueAmount);
        balance.setStroke(stroke);
        balance.setReset(sourceBalance.getReset());
        BigDecimal newYearPayAmount = sourceYearPayAmount.add(payAmount).subtract(sourcePayAmount);
        BigDecimal newYearRecAmount = sourceYearRecAmount.add(revenueAmount).subtract(sourceRecAmount);
        balance.setYearStart(sourceYearStart);
        balance.setYearBalance(reCalMonthBalance);
        balance.setYearPayAmount(newYearPayAmount);
        balance.setYearRecAmount(newYearRecAmount);
        this.payDiff = payAmount.subtract(sourcePayAmount);
        this.recDiff = revenueAmount.subtract(sourceRecAmount);
        this.persistBalanceData.updateBalance(balance);
        return difference;
    }

    @Override
    public void dealFollow(Balance balance, Balance follow) {
        BigDecimal fYearPayAmount = BalanceUtil.dealBigDecimal(follow.getYearPayAmount());
        BigDecimal fYearRecAmount = BalanceUtil.dealBigDecimal(follow.getYearRecAmount());
        follow.setYearPayAmount(fYearPayAmount.add(this.payDiff));
        follow.setYearRecAmount(fYearRecAmount.add(this.recDiff));
    }

    @Override
    protected void saveNonLatBalance(Balance balance, BalanceData sourceBalanceData, BalanceData balanceData) throws Exception {
        super.saveNewBalance(balance, null, balanceData);
    }

    @Override
    protected void saveNewBalance(Balance balance, BalanceData sourceBalanceData, BalanceData balanceData) throws Exception {
        super.saveNewBalance(balance, sourceBalanceData, balanceData);
    }

    @Override
    protected BigDecimal doSaveBalance(BalanceData sourceBalanceData, BalanceData balanceData, Balance balance) throws Exception {
        return super.doSaveBalance(sourceBalanceData, balanceData, balance);
    }
}

